/*
ESUP-portail is a french academic project developed under the GPL (General Public License) augmented according to the following :
A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.
The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .
A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .
The different kinds of licenses governing the products developed by the Apache foundation can be found here : http://www.apache.org/licenses .
It follows that you can as well as use download contents as well modify and redistribute them provided you respect the GPL terms.
Downloading and using such contents do not provide any guaranty.
Be sure that you have well understood the terms of the license before using the contents it covers.
The ESUP-portail distribution includes the following distributions :
    * UPortal : 
      software developed by JA-SIG (Java Architecture - Special Interest Group)
      You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html
    * CAS :
      SSO solution developed by Yale University
      You can find the project page here : http://www.yale.edu/tp/auth
    * Cocoon :
      XML framework distributed by the Apache foundation under Apache license;
      Please find the full text here : http://cocoon.apache.org/2.1/license.html
    * Mod_dav:
      A DAV module for Apache web server
      You can find the project page here : http://www.webdav.org/mod_dav
    * IMP :
      webmail from Horde application framework
      You can find the project page here : http://www.horde.org
    * . To be completed
*/
package org.esupportail.portal.channels.CSMS.properties;





/**
 * <p>Titre : Properties</p>
 * <p>Description : Pour utiliser les properties </p>
 * <p>Copyright : Copyright (c) 2004</p>
 * <p>Socit : Universit de Valenciennes et du Hainaut Cambrsis </p>
 * @author Yohan Colmant
 * @version 1.0
 */


public class ProprietesCanal {
	
	/**
	 * L'url du serveur de multidiffusion
	 */
	private String smsServeur;
	
	/**
	 * Le login du serveur
	 */
	private String smsLogin;
	
	/**
	 * Le password pour le serveur
	 */
	private String smsPassword;
	
	

	/**
	 * Nombre de caracteres que peut contenir un SMS
	 */	
	private String smsSize;

	/**
	 * Dit de qui ca vient (par exemple "De" ou "From")
	 */	
	private String smsFrom;
	
	/**
	 * Emetteur lors de l'envoi du code d'activation
	 */	
	private String smsFromActivation;
	
	/**
	 * Sujet du message lors de l'envoi du code d'activation
	 */
	private String smsSubjectActivation;
	
	/**
	 * Message lors de l'envoi du code d'activation (ce qui precede le code d'activation)
	 */	
	private String smsMessageActivation;

	
	

	/**
	 * L'url du serveur de mails
	 */
	private String mailServeur;
	
	
	
	
	/**
	 * l'URL de l'annuaire
	 */
	private String ldapUrl;

	/**
	 * Pour acceder a l'annuaire
	 */
	private String loginLdap;
	
	/**
	 * Mot de passe pour lire les numeros de telephone et profils d'envoi dans LDAP
	 */
	private String passwordLdap;	
	
	/**
	 * le dn de la branche groupes de ldap
	 */
	private String ldapGroups;
	
	/**
	 * le dn de la branche people de ldap
	 */
	private String ldapPeople;
	
	/**
	 * Le filtre pour chercher les instituts
	 */
	private String filtreInstituts;
	
	/**
	 * Le filtre pour chercher les formations
	 */
	private String filtreFormations;
	
	
	
	
	/**
	 * Attribut qui contient le numero de telephone d'une personne au format international. Par exemple +33 6 00 00 00 00
	 */
	private String mobileAttribute;
	
	/**
	 * Attribut qui contient le mode de contact choisi par l'utilisateur
	 */	
	private String contactModeAttribute;
	
	/**
	 * attribut qui contient le mail de l'utilisateur
	 */
	private String mailAttribute;

	/**
	 * Attribut qui contient le nom complet d'un user
	 */
	private String displayNameAttribute;
	
	
	
	
	
	/**
	 * Le fichier de log
	 */
	private String logFile;
	
	
	
	/**
	 * Constructeur	 
	 */
	public ProprietesCanal() {		
	}
	
	
	
	
	/**
	 * @return Returns the smsSize.
	 */
	public String getSmsSize() {
		return smsSize;
	}
	/**
	 * @param smsSize The smsSize to set.
	 */
	public void setSmsSize(String smsSize) {
		this.smsSize = smsSize;
	}
	/**
	 * @return Returns the contactModeAttribute.
	 */
	public String getContactModeAttribute() {
		return contactModeAttribute;
	}
	/**
	 * @param contactModeAttribute The contactModeAttribute to set.
	 */
	public void setContactModeAttribute(String contactModeAttribute) {
		this.contactModeAttribute = contactModeAttribute;
	}
	/**
	 * @return Returns the displayNameAttribute.
	 */
	public String getDisplayNameAttribute() {
		return displayNameAttribute;
	}
	/**
	 * @param displayNameAttribute The displayNameAttribute to set.
	 */
	public void setDisplayNameAttribute(String displayNameAttribute) {
		this.displayNameAttribute = displayNameAttribute;
	}
	/**
	 * @return Returns the mailAttribute.
	 */
	public String getMailAttribute() {
		return mailAttribute;
	}
	/**
	 * @param mailAttribute The mailAttribute to set.
	 */
	public void setMailAttribute(String mailAttribute) {
		this.mailAttribute = mailAttribute;
	}
	/**
	 * @return Returns the mobileAttribute.
	 */
	public String getMobileAttribute() {
		return mobileAttribute;
	}
	/**
	 * @param mobileAttribute The mobileAttribute to set.
	 */
	public void setMobileAttribute(String mobileAttribute) {
		this.mobileAttribute = mobileAttribute;
	}
	/**
	 * @return Returns the smsFrom.
	 */
	public String getSmsFrom() {
		return smsFrom;
	}
	/**
	 * @param smsFrom The smsFrom to set.
	 */
	public void setSmsFrom(String smsFrom) {
		this.smsFrom = smsFrom;
	}
	
	/**
	 * @return Returns the smsFromActivation.
	 */
	public String getSmsFromActivation() {
		return smsFromActivation;
	}
	/**
	 * @param smsFromActivation The smsFromActivation to set.
	 */
	public void setSmsFromActivation(String smsFromActivation) {
		this.smsFromActivation = smsFromActivation;
	}
	/**
	 * @return Returns the smsMessageActivation.
	 */
	public String getSmsMessageActivation() {
		return smsMessageActivation;
	}
	/**
	 * @param smsMessageActivation The smsMessageActivation to set.
	 */
	public void setSmsMessageActivation(String smsMessageActivation) {
		this.smsMessageActivation = smsMessageActivation;
	}
	/**
	 * @return Returns the smsSubjectActivation.
	 */
	public String getSmsSubjectActivation() {
		return smsSubjectActivation;
	}
	/**
	 * @param smsSubjectActivation The smsSubjectActivation to set.
	 */
	public void setSmsSubjectActivation(String smsSubjectActivation) {
		this.smsSubjectActivation = smsSubjectActivation;
	}	
	/**
	 * @return Returns the mailServeur.
	 */
	public String getMailServeur() {
		return mailServeur;
	}
	/**
	 * @param mailServeur The mailServeur to set.
	 */
	public void setMailServeur(String mailServeur) {
		this.mailServeur = mailServeur;
	}
	/**
	 * Recupere l'url du serveur sms
	 * @return l'url du serveur sms
	 */
	public String getSmsServeur() {
		return this.smsServeur;
	}
	
	/**
	 * Recupere le login pour le serveur sms
	 * @return le login pour le du serveur sms
	 */
	public String getSmsLogin() {
		return this.smsLogin;
	}
	
	/**
	 * Recupere le password pour le serveur sms
	 * @return le password pour le serveur sms
	 */
	public String getSmsPassword() {
		return this.smsPassword;
	}
	
	/**
	 * Recupere l'url de l'annuaire
	 * @return l'url de l'annuaire
	 */
	public String getLdapUrl() {
		return this.ldapUrl;
	}
	
	/**
	 * Recupere le dn de la branche groups de l'annuaire
	 * @return le dn de la branche groups de l'annuaire
	 */
	public String getLdapGroups() {
		return this.ldapGroups;
	}
	
	/**
	 * Recupere le dn de la branche people de l'annuaire
	 * @return le dn de la branche people de l'annuaire
	 */
	public String getLdapPeople() {
		return this.ldapPeople;
	}
	
	/**
	 * Recupere le filtre pour chercher les instituts
	 * @return le filtre pour chercher les instituts
	 */
	public String getFiltreInstituts() {
		return this.filtreInstituts;
	}
	
	/**
	 * Recupere le filtre pour chercher les formations
	 * @return le filtre pour chercher les formations
	 */
	public String getFiltreFormations() {
		return this.filtreFormations;
	}

	/**
	 * Recupere le nom du fichier de log
	 * @return le nom du fichier de log
	 */
	public String getLogFile() {
		return this.logFile;
	}
	
	/**
	 * Recupere le login d'acces a LDAP
	 * @return le login 
	 */
	public String getLoginLdap() {
		return this.loginLdap;
	}
	
	/**
	 * Recupere le mot de passe d'acces a LDAP
	 * @return le mot de passe 
	 */
	public String getPasswordLdap() {
		return this.passwordLdap;
	}
	
	
	/**
	 * Affecte l'url du serveur sms
	 * @param smsServeur l'url du serveur sms
	 */
	public void setSmsServeur(String smsServeur) {
		this.smsServeur = smsServeur;
	}
	
	/**
	 * Affecte le login au serveur sms
	 * @param smsLogin le login au serveur sms
	 */
	public void setSmsLogin(String smsLogin) {
		this.smsLogin = smsLogin;
	}
	
	/**
	 * Affecte le password sms
	 * @param smsPassword le password sms
	 */
	public void setSmsPassword(String smsPassword) {
		this.smsPassword = smsPassword;
	}
	
	/**
	 * Affecte l'url de l'annuaire
	 * @param ldapUrl l'url de l'annuaire
	 */
	public void setLdapUrl(String ldapUrl) {
		this.ldapUrl = ldapUrl;
	}
	
	/**
	 * Affecte le dn de la branche groups de l'annuaire
	 * @param ldapGroups le dn de la branche groups de l'annuaire
	 */
	public void setLdapGroups(String ldapGroups) {
		this.ldapGroups = ldapGroups;
	}
	
	/**
	 * Affecte le dn de la branche people de l'annuaire
	 * @param ldapPeople le dn de la branche people de l'annuaire
	 */
	public void setLdapPeople(String ldapPeople) {
		this.ldapPeople = ldapPeople;
	}
	
	/**
	 * Affecte le filtre pour chercher les instituts
	 * @param filtreInstituts le filtre pour chercher les instituts
	 */
	public void setFiltreInstituts(String filtreInstituts) {
		this.filtreInstituts = filtreInstituts;
	}
	
	/**
	 * Affecte le filtre pour chercher les formations
	 * @param filtreFormations le filtre pour chercher les formations
	 */
	public void setFiltreFormations(String filtreFormations) {
		this.filtreFormations = filtreFormations;
	}
	
	/**
	 * Affecte le nom du fichier de log
	 * @param logFile le nom du fichier de log
	 */
	public void setLogFile(String logFile) {
		this.logFile = logFile;
	}
	
	/**
	 * Affecte le login d'acces a LDAP
	 * @param loginLdap le login d'acces a LDAP
	 */	
	public void setLoginLdap(String loginLdap) {
		this.loginLdap = loginLdap;
	}
	
	/**
	 * Affecte le mot de passe d'acces a LDAP
	 * @param passwordLdap le mot de passe d'acces a LDAP
	 */
	public void setPasswordLdap(String passwordLdap) {
		this.passwordLdap = passwordLdap;
	}
	
	/**
	 * Renvoie une chaine representant les infos
	 * @return une chaine representant les infos
	 */
	public String toString() {
		return "url sms: "+smsServeur+"\nlogin sms: "+smsLogin+"\npassword sms: "+smsPassword+"\n"+
		"ldapUrl: "+ldapUrl+"\nldapGroups: "+ldapGroups+"\nfiltreInstituts: "+filtreInstituts+"\nfiltreFormations: "+filtreFormations+
		"\nlogFile: "+logFile;
	}
	
	
	
	
}
