/*
ESUP-portail is a french academic project developed under the GPL (General Public License) augmented according to the following :
A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.
The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .
A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .
The different kinds of licenses governing the products developed by the Apache foundation can be found here : http://www.apache.org/licenses .
It follows that you can as well as use download contents as well modify and redistribute them provided you respect the GPL terms.
Downloading and using such contents do not provide any guaranty.
Be sure that you have well understood the terms of the license before using the contents it covers.
The ESUP-portail distribution includes the following distributions :
    * UPortal : 
      software developed by JA-SIG (Java Architecture - Special Interest Group)
      You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html
    * CAS :
      SSO solution developed by Yale University
      You can find the project page here : http://www.yale.edu/tp/auth
    * Cocoon :
      XML framework distributed by the Apache foundation under Apache license;
      Please find the full text here : http://cocoon.apache.org/2.1/license.html
    * Mod_dav:
      A DAV module for Apache web server
      You can find the project page here : http://www.webdav.org/mod_dav
    * IMP :
      webmail from Horde application framework
      You can find the project page here : http://www.horde.org
    * . To be completed
*/
package org.esupportail.portal.channels.CSMS.serverSending;


import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

/**
 * <p>Titre : PostURLConnection</p>
 * <p>Description : Permet de poster sur un serveur </p>
 * <p>Copyright : Copyright (c) 2004</p>
 * <p>Socit : Universit de Valenciennes et du Hainaut Cambrsis </p>
 * @author Yohan Colmant
 * @version 1.0
 */
public class PostURLConnection {
	
	/**
	 * La taille du buffer
	 */
	private static final int BUFF_SIZE = 1024;
    
	/**
	 * Le buffer d'envoi de fichier
	 */
	private static final byte[] buffer = new byte[BUFF_SIZE];
    
	/**
	 * La sortie
	 */
    private DataOutputStream out;
    
    /**
     * ???
     */
    private String boundary;
    
    /**
     * La connexion URL
     */
    private URLConnection conn;
	
    
    
    
    /**
     * Constructeur
     * @param URL l'url de connexion, exemple: "http://mon.serveur/page.php"
     * @throws MalformedURLException
     * @throws IOException
     */
    public PostURLConnection(String URL) throws MalformedURLException, IOException {
    	URL servlet = new URL(URL);   
        conn=servlet.openConnection();
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setUseCaches(false);
        boundary = "---------------------------7d226f700d0";
        conn.setRequestProperty("Content-type","multipart/form-data; boundary=" + boundary);
        conn.setRequestProperty("Cache-Control", "no-cache");
             
        out = new DataOutputStream(conn.getOutputStream());
        out.writeBytes("--" + boundary + "\r\n");  
    }
    
    /**
     * Pour ajouter un parametre
     * @param name le nom du parametre
     * @param value la valeur de ce parametre
     * @throws IOException l'exception retournee si erreur avec le serveur
     */
    public void writeParam(String name, String value) throws IOException {
        out.writeBytes("content-disposition: form-data; name=\"" + name + "\"\r\n\r\n");
        out.writeBytes(value);
        out.writeBytes("\r\n" + "--" + boundary + "\r\n");
    }
    
    /**
     * Pour uploader un fichier
     * @param name le nom du parametre
     * @param filePath le path du fichier
     * @param fileName le nom du fichier a charger
     * @throws IOException l'exception retournee si erreur avec le serveur
     */    
    public void writeFile(String name, String filePath, String fileName) throws IOException {
        out.writeBytes("content-disposition: form-data; name=\""+name+"\"; filename=\""+fileName+"\"\r\n");
        out.writeBytes("content-type: application/octet-stream"+"\r\n\r\n");
        FileInputStream fis = new FileInputStream(filePath);
        while (true) {
        	synchronized (buffer) {
        		int amountRead = fis.read(buffer);
        		if (amountRead == -1) {
        			break;
        		}
        		out.write(buffer, 0, amountRead); 
        	}
        }
        fis.close();
        out.writeBytes("\r\n" + "--" + boundary + "\r\n");     
    }
    
    
    
    /**
     * Pour uploader un fichier
     * @param name le nom du parametre
     * @param content le contenu du fichier
     * @param fileName le nom du fichier XML
     * @throws IOException l'exception retournee si erreur avec le serveur
     */    
    public void writeFileContent(String name, String content, String fileName) throws IOException {
        out.writeBytes("content-disposition: form-data; name=\""+name+"\"; filename=\""+fileName+"\"\r\n");
        out.writeBytes("content-type: application/octet-stream"+"\r\n\r\n");
        
        out.write(content.getBytes());
        
        out.writeBytes("\r\n" + "--" + boundary + "\r\n");     
    }
    
    
    /**
     * Fermeture des flux
     * @throws IOException l'exception retournee si erreur avec le serveur
     */
    public void close() throws IOException {
    	out.flush();
    	out.close();
    }
    
    
    /**
     * Recuperation de la reponse du serveur
     * @return un flux provenant du serveur
     * @throws IOException l'exception retournee si erreur avec le serveur
     */
    public InputStream getInputStream() throws IOException {
    	return conn.getInputStream();
    }
    
   
    
}
