/*
ESUP-portail is a french academic project developed under the GPL (General Public License) augmented according to the following :
A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.
The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .
A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .
The different kinds of licenses governing the products developed by the Apache foundation can be found here : http://www.apache.org/licenses .
It follows that you can as well as use download contents as well modify and redistribute them provided you respect the GPL terms.
Downloading and using such contents do not provide any guaranty.
Be sure that you have well understood the terms of the license before using the contents it covers.
The ESUP-portail distribution includes the following distributions :
    * UPortal : 
      software developed by JA-SIG (Java Architecture - Special Interest Group)
      You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html
    * CAS :
      SSO solution developed by Yale University
      You can find the project page here : http://www.yale.edu/tp/auth
    * Cocoon :
      XML framework distributed by the Apache foundation under Apache license;
      Please find the full text here : http://cocoon.apache.org/2.1/license.html
    * Mod_dav:
      A DAV module for Apache web server
      You can find the project page here : http://www.webdav.org/mod_dav
    * IMP :
      webmail from Horde application framework
      You can find the project page here : http://www.horde.org
    * . To be completed
*/
package org.esupportail.portal.channels.CSMS.smsServerResponse;


import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import org.apache.commons.digester.Digester;
import org.esupportail.portal.channels.CSMS.exception.ExceptionConfirmationEnvoiSms;
import org.jasig.portal.services.LogService;
import org.xml.sax.SAXException;


/**
 * <p>Titre : ParseServerResponse</p>
 * <p>Description : Pour parser un fichier de properties SMS </p>
 * <p>Copyright : Copyright (c) 2004</p>
 * <p>Socit : Universit de Valenciennes et du Hainaut Cambrsis </p>
 * @author Yohan Colmant
 * @version 1.0
 */
public class ParseReponseServeurSms {
	
	/**
	 * Les proprietes retrouvees
	 */
	private RapportServeurSms report;
	
	
	
	/**
	 * Constructeur
	 * @param stringReader un objet StringReader sur le flux de donnees dans lequel se trouve la reponse
	 * throws ExceptionConfirmationEnvoiSms
	 */
	public ParseReponseServeurSms(StringReader stringReader) throws ExceptionConfirmationEnvoiSms {
		try {						
			Digester dig = new Digester();
			
			dig.setValidating(false);
			dig.addObjectCreate("REPORT","org.esupportail.portal.channels.CSMS.smsServerResponse.RapportServeurSms");			
			dig.addBeanPropertySetter("REPORT/MSG_ID", "msgId");
			dig.addBeanPropertySetter("REPORT/MSG_DATE", "msgDate");
			
			dig.addObjectCreate("ERROR_LIST","org.esupportail.portal.channels.CSMS.serverResponse.ServerReport");
			dig.addObjectCreate("ERROR_LIST/ERROR","org.esupportail.portal.channels.CSMS.serverResponse.ServerError");
			dig.addSetNext("ERROR_LIST/ERROR", "setErrors");
			dig.addBeanPropertySetter("ERROR_LIST/ERROR/CODE", "errorCode");
			dig.addBeanPropertySetter("ERROR_LIST/ERROR/MODULE", "errorModule");
			dig.addBeanPropertySetter("ERROR_LIST/ERROR/MESSAGE", "errorMessage");
			
			report = (RapportServeurSms)dig.parse(stringReader);
		}
		catch (SAXException e) {
			//e.printStackTrace();
			LogService.log(LogService.ERROR, "ParseReponseServeurSms::ParseReponseServeurSms: "+e);
			throw new ExceptionConfirmationEnvoiSms();
		}
		catch (IOException e) {
			//e.printStackTrace();
			LogService.log(LogService.ERROR, "ParseReponseServeurSms::ParseReponseServeurSms: "+e);
			throw new ExceptionConfirmationEnvoiSms();
		}
	}
	
	
	
	
	
	
	/**
	 * Retourne l'id du message envoye
	 * @return l'id du message
	 */
	public String getMsgId() {
		return report.getMsgId();
	}
	
	/**
	 * Retourne la date d'envoi du message
	 * @return la date d'envoi du message
	 */
	public String getMsgDate() {
		return report.getMsgDate();
	}
	
	/**
	 * Retourne les erreurs
	 * @return les erreurs
	 */
	public ArrayList getErrors() {
		return report.getErrors();
	}
	
	

}
