<?xml version="1.0" encoding="ISO-8859-1"?>
<!-- destinataire.xsl, pour la saisie du destinataire du message -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">  
<xsl:output method="html" encoding="ISO-8859-1"/>

<xsl:param name="baseActionURL"/>

	<xsl:template match="DESTINATAIRE">
	
	<xsl:variable name="actionMessage">actionMessage</xsl:variable>
	<xsl:variable name="actionDestinataire">actionDestinataire</xsl:variable>
	<xsl:variable name="actionConfirmation">actionConfirmation</xsl:variable>
	
		<script language="javascript">
<![CDATA[

// affiche un message d'erreur
function erreur(message) {
	alert(message);
}

// affiche un message d'erreur et recharge la page
function recharge(message) {
	alert(message);
	document.recharge.submit();
}


// action effectuee quand on envoit le message
function envoyer() {
	if (document.Etudiants != null) {
		if (document.Etudiants.Etudiants.selectedIndex != -1) {
			document.envoi.action = document.envoi.action + "&etudiants=";
			if (document.Etudiants.Etudiants.selectedIndex == 0)
				document.envoi.action = document.envoi.action + "0";
				else {
					for (i=1;i< document.Etudiants.Etudiants.length ;i++) {
						if (document.Etudiants.Etudiants.options[i].selected) {
							document.envoi.action = document.envoi.action + i +"-";
						}
					}				
				}
			document.envoi.submit();
		}
		else alert('Veuillez choisir au minimum un etudiant.');	
		}
	else alert('Veuillez choisir une formation');
}

// action effectuee quand on choisit un institut
function InstituteChoice(formulaire) {		
	if (formulaire.Institut.selectedIndex != 0)	{
		document.valideInstitut.action = document.valideInstitut.action + "&institut=" + formulaire.Institut.options[formulaire.Institut.selectedIndex].value    ;		
		document.valideInstitut.submit();
	 	}
	else {
		alert('Veuillez choisir un institut.');
		}
	}
	
	
// action effectuee quand on choisit une formation
function FormationChoice(formulaire) {		
	if (formulaire.Formation.selectedIndex != 0) {
		document.valideFormation.action = document.valideFormation.action + "&institut=" + document.Institut.Institut.options[document.Institut.Institut.selectedIndex].value + "&formation=" + formulaire.Formation.options[formulaire.Formation.selectedIndex].value    ;		
		document.valideFormation.submit();
	 	}
	else {
		alert('Veuillez choisir une formation.');
		}
	}
]]>
		</script>
  


  	
	  	
  	<!-- xsl:for-each select="baseActionURL">
  	</xsl:for-each --> 
  	
  	
  	
  	
  	<table border="1" cellspacing="0" cellpadding="0" width="100%" bordercolor="#002863" align="center">  
				
		<tr> 
			<td>
		
  		 		
  		<table width="100%" align="center"  border="0" cellspacing="5" cellpadding="5">
  			
  			<tr class="uportal-background-light"> 
          		<td class="uportal-channel-table-caption" align="center" colspan="2"> 
            		Saisissez le(s) destinataire(s)
          		</td>
        	</tr>	
  		
  		</table>
  			
  		<table width="50%" align="center"  border="0" cellspacing="5" cellpadding="5">
		
  	
  	
  			<xsl:for-each select="ERREUR">  	
  				<script language="JavaScript">
  					erreur("<xsl:value-of select="."/>");
				</script>  	  	  	  			
  			</xsl:for-each>
  	
  			<form name="recharge" action="{$baseActionURL}?action={$actionMessage}" method="post">
    		</form>
  	
  			<xsl:for-each select="RECHARGE">  	
  				<script language="JavaScript">
		  			recharge('Annuaire non joignable');  			
				</script>  	  	  	  			
		  	</xsl:for-each>
  	
  	
  	
  	<xsl:for-each select="INSTITUTS">  	  
		<FORM NAME="Institut">		
			<tr class="uportal-background-highlight">
				<td class="uportal-channel-table-header" align="left">Institut</td>		
			</tr>
			<tr>
				<td align="center">
		   			<SELECT NAME="Institut" SIZE="1" onChange="InstituteChoice(this.form)">
		      			<OPTION SELECTED="true" VALUE="">-S&#233;lectionnez l'institut-</OPTION>
						<xsl:for-each select="INSTITUT">
							<xsl:choose>						
								<xsl:when test="@SELECTED='true'">
									<xsl:variable name="val"><xsl:value-of select="."/></xsl:variable>						
									<OPTION SELECTED="true" VALUE="{$val}"><xsl:value-of select="."/></OPTION>
								</xsl:when>
								<xsl:otherwise>
									<xsl:variable name="val"><xsl:value-of select="."/></xsl:variable>
									<OPTION VALUE="{$val}"><xsl:value-of select="."/></OPTION>
								</xsl:otherwise>
							</xsl:choose>					
						</xsl:for-each>
					</SELECT>
				</td>
			</tr>
		</FORM>	
	</xsl:for-each>
	
		
	<xsl:for-each select="FORMATIONS">	
		<FORM NAME="Formation">
			<tr class="uportal-background-highlight">
				<td class="uportal-channel-table-header" align="left">Formation</td>		
			</tr>
			<tr>
				<td align="center">
   					<SELECT NAME="Formation" SIZE="1" onChange="FormationChoice(this.form)">
		      			<OPTION SELECTED="true" VALUE="">-S&#233;lectionnez la formation-</OPTION>
						<xsl:for-each select="FORMATION">
							<xsl:choose>
								<xsl:when test="@SELECTED='true'">
									<xsl:variable name="val"><xsl:value-of select="."/></xsl:variable>												
									<OPTION SELECTED="true" VALUE="{$val}"><xsl:value-of select="."/></OPTION>		
								</xsl:when>
								<xsl:otherwise>
									<xsl:variable name="val"><xsl:value-of select="."/></xsl:variable>						
									<OPTION VALUE="{$val}"><xsl:value-of select="."/></OPTION>
								</xsl:otherwise>
							</xsl:choose>					
						</xsl:for-each>
					</SELECT>
				</td>
			</tr>
		</FORM>
	</xsl:for-each>
	
	
	 
	<xsl:for-each select="ETUDIANTS">		
		<FORM NAME="Etudiants">
			<tr class="uportal-background-highlight">
				<td class="uportal-channel-table-header" align="left">Etudiant(s)</td>		
			</tr>
			<tr>
				<td align="center">		
   					<SELECT NAME="Etudiants" SIZE="8" MULTIPLE="true">
		   				<OPTION VALUE="">-Toute la formation-</OPTION>
						<xsl:for-each select="ETUDIANT">
							<xsl:choose>
								<xsl:when test="@SELECTED='true'">
									<OPTION SELECTED="true"><xsl:value-of select="@NOM"/></OPTION>	
								</xsl:when>
								<xsl:otherwise>
									<OPTION><xsl:value-of select="@NOM"/></OPTION>
								</xsl:otherwise>
							</xsl:choose>										
						</xsl:for-each>
					</SELECT>
				</td>
			</tr>				
		</FORM>			
	</xsl:for-each>
	
	</table>
	
		
	<table width="40%" align="center" border="0" cellspacing="0" cellpadding="0">
		<tbody>
		<FORM action="{$baseActionURL}?action={$actionMessage}" method="post">  
			<tr>				
				<td style="vertical-align: top; text-align: center;">
					<INPUT TYPE="submit" class ="uportal-button" VALUE="Prcdent" />
				</td>
				<td style="vertical-align: top; text-align: center;">
					<INPUT TYPE="button" class="uportal-button" VALUE="Suivant" onclick="javascript:envoyer()" />
				</td>		
			</tr>
		</FORM>
		</tbody>
	</table>
			
	    	
    	
    	<form name="valideInstitut" action="{$baseActionURL}?action={$actionDestinataire}" method="post">
    	</form>    	
    	    
    	<form name="valideFormation" action="{$baseActionURL}?action={$actionDestinataire}" method="post">
    	</form>
    	
    	<form name="envoi" action="{$baseActionURL}?action={$actionConfirmation}" method="post">
    	</form>
    	
    	
    	
			</td>
		</tr>
	</table>
	
	
  	</xsl:template> 
  </xsl:stylesheet>