/*
ESUP-portail is a french academic project developed under the GPL (General Public License) augmented according to the following :
A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.
The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .
A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .
The different kinds of licenses governing the products developed by the Apache foundation can be found here : http://www.apache.org/licenses .
It follows that you can as well as use download contents as well modify and redistribute them provided you respect the GPL terms.
Downloading and using such contents do not provide any guaranty.
Be sure that you have well understood the terms of the license before using the contents it covers.
The ESUP-portail distribution includes the following distributions :
    * UPortal : 
      software developed by JA-SIG (Java Architecture - Special Interest Group)
      You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html
    * CAS :
      SSO solution developed by Yale University
      You can find the project page here : http://www.yale.edu/tp/auth
    * Cocoon :
      XML framework distributed by the Apache foundation under Apache license;
      Please find the full text here : http://cocoon.apache.org/2.1/license.html
    * Mod_dav:
      A DAV module for Apache web server
      You can find the project page here : http://www.webdav.org/mod_dav
    * IMP :
      webmail from Horde application framework
      You can find the project page here : http://www.horde.org
    * . To be completed
*/
package org.esupportail.portal.channels.CSMS;

import java.util.Random;
import java.util.Vector;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CSMS.changeProfile.AccesLdap;
import org.esupportail.portal.channels.CSMS.exception.ExceptionAccesLdap;
import org.esupportail.portal.channels.CSMS.exception.ExceptionCanal;
import org.esupportail.portal.channels.CSMS.exception.ExceptionCodeActivation;
import org.esupportail.portal.channels.CSMS.exception.ExceptionConfigurationCanal;
import org.esupportail.portal.channels.CSMS.exception.ExceptionConfirmationEnvoiSms;
import org.esupportail.portal.channels.CSMS.exception.ExceptionEnvoi;
import org.esupportail.portal.channels.CSMS.exception.ExceptionEnvoiMail;
import org.esupportail.portal.channels.CSMS.exception.ExceptionEnvoiSms;
import org.esupportail.portal.channels.CSMS.exception.ExceptionNumeroTelephone;
import org.esupportail.portal.channels.CSMS.properties.ParseProprietesCanal;
import org.esupportail.portal.channels.CSMS.properties.ProprietesCanal;
import org.esupportail.portal.channels.CSMS.serverSending.GereMessage;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;
import org.jasig.portal.utils.XSLT;
import org.xml.sax.ContentHandler;

/**
 * Id: ActionSaisieProfil.java,v 1.0 3 janv. 2005
 * Copyright (c) 2004 Esup Portail (www.esup-portail.org)
 * Classes: ActionSaisieProfil
 * Original Author: Yohan Colmant
 * Gere les actions lors de la saisie du profil
 */
public class ActionSaisieProfil {

	/**
	 * Logger object
	 */
	protected static final Log log = LogFactory.getLog(ActionSaisieProfil.class);
	
	/**
	 * Action de saisie de profil
	 */
	private String SAISIE_PROFIL = "saisie_profil";		
	
	/**
	 * Effectue le traitement apres validation de l'etudiant
	 */
	private String TRAITEMENT = "traitement";	
	
	
	
	
	

	/**
	 * La feuille de style utilisee
	 */
	private String stylesheet;
	
	
	/**
	 * Le login de l'utilisateur
	 */
	private String login;

	/**
	 * Le numero de telephone de l'utilisateur
	 */
	private String phoneNumber;
	
	/**
	 * Le mode de contact de l'utilisateur (courriel, sms, both ou code d'activation)
	 */ 
	private String contactMode;
	
	
	
	
	
	
	
	
	
	
	
	/**
	 * Constructeur par defaut
	 * @param login le login de la personne connectee
	 */
	public ActionSaisieProfil(String login) {
		this.login = login;
	}
	
	
	

	/**
	 * Output channel content to the portal
	 * @param out a sax document handler
	 * @param xslt object used for the rendering
	 * @param runtimeData the channelRuntimeData object
	 * @throws PortalException
	 */
	public void renderXML(ContentHandler out, XSLT xslt, ChannelRuntimeData runtimeData) throws PortalException {				
		
		String action = runtimeData.getParameter("action");		
		
		// le XML a generer
		String xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>";		
		xml += "<ROOT>";
		
		try {
		
			// si action est null
			// on est en mode saisie du profil
			if (action == null || action.equals("null")) {		
				action = SAISIE_PROFIL;						
			}
			
		
			// si on est en edition de profil
			if (action.equals(SAISIE_PROFIL)) {
				stylesheet = "saisie_profil";
				xml += renderXmlSaisieProfil();			
			}
			else 
		
				// si on est en edition de profil
				if (action.equals(TRAITEMENT)) {
					stylesheet = "message_profil";
					xml += renderXmlTraitement(runtimeData);			
				}
		
		
		}
		catch(ExceptionCanal e) {
			xml += renderXmlMessage(e.getErrorCode(), e.getNextState());
			stylesheet = "message_profil";
			if (log.isDebugEnabled()){
				log.debug("renderXML: "+e);
			}	
		}
		
		
		
		// fin du XML
		xml += "</ROOT>";
		
		
		// pass the result XML to the styling engine.
		xslt.setXML(xml);
		// specify the stylesheet selector
		xslt.setXSL("CSMS.ssl", stylesheet, runtimeData.getBrowserInfo());
		// set parameters that the stylesheet needs.
		xslt.setStylesheetParameter("baseActionURL", runtimeData.getBaseActionURL());	
		// set the output Handler for the output.
		xslt.setTarget(out);
		// do the deed
		xslt.transform();
	}
	
	
	/**
	 * On genere le XML de sortie pour l'affichage d'un message
	 * @param messageCode le code de message a afficher
	 * @param etatSuivant l'etat dans lequel devra se retrouver le canal apres ce message
	 * @return le XML
	 */
	private String renderXmlMessage(int messageCode, String etatSuivant) {		
		String xml = "";						
		xml += "<MESSAGE state=\""+etatSuivant+"\">"+messageCode+"</MESSAGE>";		
		return xml;
	}


	/**
	 * On genere le XML de sortie pour la saisie du profil
	 * @return le XML
	 * @throws ExceptionAccesLdap
	 * @throws ExceptionConfigurationCanal
	 */
	private String renderXmlSaisieProfil () throws ExceptionAccesLdap, ExceptionConfigurationCanal {		
			
		try {
		
			// on recherche le mode de contact de l'etudiant
			this.contactMode = AccesLdap.getContactMode(login);
		
			// si le contactMode est null, c'est la premiere connection
			if (this.contactMode == null) {
				AccesLdap.setContactMode(login, AccesLdap.MAIL);
				this.contactMode = AccesLdap.MAIL;
			}
		
			// si le contactMode est different de MAIL, on recherche le numero de telephone
			if (!this.contactMode.equals(AccesLdap.MAIL)) {					
				// on recherche le numero de telephone de l'etudiant
				this.phoneNumber = AccesLdap.getPhoneNumber(login);
			}
			
					
			// le XML a retourner
			String xml = "";
						
			// si mode courriel
			if (this.contactMode.equals(AccesLdap.MAIL)) {
				
				xml += "<COURRIEL selected=\"true\"/>";
				xml += "<SMS selected=\"false\"/>";
				xml += "<BOTH selected=\"false\"/>";						
				xml += "<TEL active=\"true\" number=\"\"/>";
										
			}
			
			// si mode sms
			else if (this.contactMode.equals(AccesLdap.SMS)) {
				
				xml += "<COURRIEL selected=\"false\"/>";
				xml += "<SMS selected=\"true\"/>";
				xml += "<BOTH selected=\"false\"/>";						
				xml += "<TEL active=\"true\" number=\""+this.phoneNumber+"\"/>";
				
			}
			
			// si mode courriel et sms
			else if (this.contactMode.equals(AccesLdap.MAIL_AND_SMS)) {
				
				xml += "<COURRIEL selected=\"false\"/>";
				xml += "<SMS selected=\"false\"/>";
				xml += "<BOTH selected=\"true\"/>";						
				xml += "<TEL active=\"true\" number=\""+this.phoneNumber+"\"/>";	
				
			}
			
			// on a un code d'activation
			else {
				
				xml += "<COURRIEL selected=\"false\"/>";
				xml += "<SMS selected=\"true\"/>";
				xml += "<BOTH selected=\"false\"/>";						
				xml += "<TEL active=\"false\" number=\""+this.phoneNumber+"\"/>";
				
			}
					
				
			
			return xml;
				
		}
		catch(ExceptionAccesLdap e) {
			if (log.isDebugEnabled()){
				log.debug("renderXmlSaisieProfil: "+e);
			}	
			
			this.phoneNumber = null;
			this.contactMode = null;							
			
			throw e;			
		}
		
		
	}
	
	
	
	
	
	
	
	
	
	/**
	 * On genere le XML de sortie pour l'affichage d'un message apres traitement
	 * @param runtimeData
	 * @return le XML
	 * @throws ExceptionAccesLdap
	 * @throws ExceptionEnvoi
	 * @throws ExceptionEnvoiMail
	 * @throws ExceptionEnvoiSms
	 * @throws ExceptionConfirmationEnvoiSms
	 * @throws ExceptionConfigurationCanal
	 * @throws ExceptionNumeroTelephone
	 * @throws ExceptionCodeActivation
	 */	
	private String renderXmlTraitement (ChannelRuntimeData runtimeData) throws ExceptionAccesLdap, ExceptionEnvoi, ExceptionEnvoiMail, ExceptionEnvoiSms, ExceptionConfirmationEnvoiSms, ExceptionConfigurationCanal, ExceptionNumeroTelephone, ExceptionCodeActivation {		
		
		try {
			
				
			int messageCode = 1;
			
			String type = runtimeData.getParameter("type");
			String phone = runtimeData.getParameter("phone");
			String code = runtimeData.getParameter("code");
			String newPhone = runtimeData.getParameter("new_phone");
		
			// on regarde les changements qui ont ete faits

			///////////////////////////
			// si on etait en mode MAIL
			///////////////////////////
			if (this.contactMode.equals(AccesLdap.MAIL)) {
				
				// on a laisse MAIL coche
				if (type.equals(AccesLdap.MAIL))
					messageCode = 5;
				else
				
				// on a coche SMS ou MAIL et SMS
				if (type.equals(AccesLdap.SMS) || type.equals(AccesLdap.MAIL_AND_SMS)) {
					
					// on verifie que le numero de telephone saisi est bien forme
					if (!isWellFormed(phone))
						throw new ExceptionNumeroTelephone();
					
					// on fait les modifications dans l'annuaire
					else {
						
						// on genere un code d'acces
						String codeGenere = newCode();
						
						// on envoie un SMS avec le code d'activation
						sendActivationCode(phone, codeGenere);
												
						// on ecrit le numero dans l'annuaire et on change le mode de contact
						AccesLdap.setPhoneNumber(login, phone);
						AccesLdap.setContactMode(login, codeGenere);
												
						messageCode = 7;						
					}				
				}			
			}
			else 
			
			//////////////////////////
			// si on etait en mode SMS
			//////////////////////////
			if (this.contactMode.equals(AccesLdap.SMS)) {
				
				// on a coche MAIL
				if (type.equals(AccesLdap.MAIL)) {
					
					// on efface le numero de telephone
					AccesLdap.deletePhoneNumber(login);
					AccesLdap.setContactMode(login, AccesLdap.MAIL);
					
					messageCode = 3;														
				}
				else
				
				// on a coche SMS ou MAIL et SMS
				if (type.equals(AccesLdap.SMS) || type.equals(AccesLdap.MAIL_AND_SMS)) {
					
					// si le numero de telephone a ete change
					if (!phone.equals(this.phoneNumber)) {
					
						// on verifie que le numero de telephone saisi est bien forme
						if (!isWellFormed(phone))
							throw new ExceptionNumeroTelephone();
					
						// on fait les modifications dans l'annuaire
						else {
							
							// on genere un code d'acces
							String codeGenere = newCode();
						
							// on envoie un SMS avec le code d'activation
							sendActivationCode(phone, codeGenere);
												
							// on ecrit le numero dans l'annuaire et on change le mode de contact
							AccesLdap.setPhoneNumber(login, phone);
							AccesLdap.setContactMode(login, codeGenere);
														
							messageCode = 7;						
						}
					}
					else { // si le numero n'a pas ete change
						
						// on n'a pas change de mode
						if (type.equals(AccesLdap.SMS) ) {
							// rien n'a change
							messageCode = 5;
						}
						else {						
							// on change le mode dans l'annuaire
							AccesLdap.setContactMode(login, AccesLdap.MAIL_AND_SMS);
							messageCode = 2;						
						}
					}				
				}			
			}
			else
			
			///////////////////////////////////
			// si on etait en mode MAIL_AND_SMS
			///////////////////////////////////
			if (this.contactMode.equals(AccesLdap.MAIL_AND_SMS)) {
				
				// on a coche MAIL
				if (type.equals(AccesLdap.MAIL)) {
					
					// on efface le numero de telephone
					AccesLdap.deletePhoneNumber(login);
					AccesLdap.setContactMode(login, AccesLdap.MAIL);
					
					messageCode = 3;														
				}
				else
				
				// on a coche SMS ou MAIL et SMS
				if (type.equals(AccesLdap.SMS) || type.equals(AccesLdap.MAIL_AND_SMS)) {
					
					// si le numero de telephone a ete change
					if (!phone.equals(this.phoneNumber)) {
					
						// on verifie que le numero de telephone saisi est bien forme
						if (!isWellFormed(phone))
							throw new ExceptionNumeroTelephone();
					
						// on fait les modifications dans l'annuaire
						else {
							
							// on genere un code d'acces
							String codeGenere = newCode();
						
							// on envoie un SMS avec le code d'activation
							sendActivationCode(phone, codeGenere);
												
							// on ecrit le numero dans l'annuaire et on change le mode de contact
							AccesLdap.setPhoneNumber(login, phone);
							AccesLdap.setContactMode(login, codeGenere);
														
							messageCode = 7;						
						}
					}
					else { // si le numero n'a pas ete change
						
						// on n'a pas change de mode
						if (type.equals(AccesLdap.MAIL_AND_SMS) ) {
							// rien n'a change
							messageCode = 5;
						}
						else {						
							// on change le mode dans l'annuaire
							AccesLdap.setContactMode(login, AccesLdap.SMS);
							messageCode = 4;						
						}
					}				
				}			
			}
			else {
			
			
			////////////////////////////////////////////////////////
			// si on etait en attente de saisie du code d'activation
			////////////////////////////////////////////////////////
							
				// on verifie les parametres --> code d'activation? nouveau numero ?
				
				// si on a coche MAIL, on passe en mode MAIL
				if (type.equals(AccesLdap.MAIL)) {
					
					// on efface le numero de telephone
					AccesLdap.deletePhoneNumber(login);
					AccesLdap.setContactMode(login, AccesLdap.MAIL);
					
					messageCode = 3;														
				}
				else {
				
					// si on n'a pas tape de code ou tape un code eronne
					
					if (code.trim().equals("") || !code.equals(this.contactMode)) {
					
						// on regarde si on a tape un nouveau numero de portable
						if (!newPhone.trim().equals("")) {
					
							// on verifie que le numero de telephone saisi est bien forme
							if (!isWellFormed(newPhone))
								throw new ExceptionNumeroTelephone();
					
							// on fait les modifications dans l'annuaire
							else {
								
								// on genere un code d'acces
								String codeGenere = newCode();
							
								// on envoie un SMS avec le code d'activation
								sendActivationCode(newPhone, codeGenere);
												
								// on ecrit le numero dans l'annuaire et on change le mode de contact
								AccesLdap.setPhoneNumber(login, newPhone);
								AccesLdap.setContactMode(login, codeGenere);
													
								messageCode = 7;						
							}
						}
						else { // on n'a pas tape de numero
							throw new ExceptionCodeActivation();
						}				
					}
				
					// si on a tape le bon code
					else if (code.equals(this.contactMode)) {
						
						// on a choisi le mode SMS
						if (type.equals(AccesLdap.SMS)) {
							AccesLdap.setContactMode(login, type);												
							messageCode = 4;														
						}
						else { // on a choisi le mode MAIL_AND_SMS
							AccesLdap.setContactMode(login, type);		
							messageCode = 2;							
						}
					}
				}										
			}
			
			return renderXmlMessage(messageCode, null);
		}					
		catch(ExceptionAccesLdap e) {
			
			// une erreur s'est produite
			//e.printStackTrace();
			if (log.isDebugEnabled()){
				log.debug("renderXmlTraitement: "+e);
			}	
			
			throw e;
		}
		catch(ExceptionEnvoi e) {
			
			// une erreur s'est produite
			//e.printStackTrace();
			if (log.isDebugEnabled()){
				log.debug("renderXmlTraitement: "+e);
			}	
			
			throw e;
		}
		catch(ExceptionEnvoiMail e) {
			
			// une erreur s'est produite
			//e.printStackTrace();
			if (log.isDebugEnabled()){
				log.debug("renderXmlTraitement: "+e);
			}	
			
			throw e;
		}
		catch(ExceptionEnvoiSms e) {
			
			// une erreur s'est produite
			//e.printStackTrace();
			if (log.isDebugEnabled()){
				log.debug("renderXmlTraitement: "+e);
			}	
			
			throw e;
		}
		catch(ExceptionNumeroTelephone e) {
			
			// une erreur s'est produite
			//e.printStackTrace();
			if (log.isDebugEnabled()){
				log.debug("renderXmlTraitement: "+e);
			}	
			
			throw e;
		}
		catch(ExceptionCodeActivation e) {
			
			// une erreur s'est produite
			//e.printStackTrace();
			if (log.isDebugEnabled()){
				log.debug("renderXmlTraitement: "+e);
			}	
			
			throw e;
		}
		
		
		
	}
	
	
	
	
	

	/**
	 * On verifie que le numero de telephone a un bon format
	 * @param phone le numero de telephone
	 * @return true si bien forme, false sinon
	 */
	private boolean isWellFormed(String phone) {
		
		if (phone == null)
			return false;
		
		String ph = phone.trim();
		
		if (ph.length()!=10)
			return false;
		
		if (!ph.startsWith("06"))
			return false;
			
		try {
			Integer.parseInt(ph);
			return true;
		}
		catch(Exception e) {
			return false;
		}
	}
	
	
	
	/**
	 * On genere un code d'activation 
	 * @return un code d'activation
	 */
	private String newCode() {
		Random random = new Random();		
		
		String s1 = random.nextInt()+"";
		String s2 = random.nextInt()+"";
		String s3 = random.nextInt()+"";
		String s4 = random.nextInt()+"";		
		
		String code = s1.substring(s1.length()-1) + s2.substring(s2.length()-1) +s3.substring(s3.length()-1) + s4.substring(s4.length()-1);
		return code;
	}
	
	/**
	 * On envoie le code d'activation dans un message
	 * @param phoneNumber le numero de telephone
	 * @param activationCode le code d'activation
	 * @throws ExceptionEnvoi
	 * @throws ExceptionEnvoiMail
	 * @throws ExceptionEnvoiSms
	 * @throws ExceptionConfirmationEnvoiSms
	 * @throws ExceptionConfigurationCanal
	 */
	private void sendActivationCode(String phoneNumber, String activationCode) throws ExceptionEnvoi, ExceptionEnvoiMail, ExceptionEnvoiSms, ExceptionConfirmationEnvoiSms, ExceptionConfigurationCanal {
		
		ProprietesCanal prop = ParseProprietesCanal.getInstance();
		
		GereMessage mess = new GereMessage();
		mess.setNomExpediteur(prop.getSmsFromActivation());
		mess.setSujet(prop.getSmsSubjectActivation());
		mess.setMessage(prop.getSmsMessageActivation()+" : "+activationCode);
		
		Vector destinataires = new Vector();
		Etudiant etudiant = new Etudiant(login, null, phoneNumber);
		destinataires.addElement(etudiant);
		
		mess.sendMessage(destinataires);	
	}
	
	
	
	
}
