/*
ESUP-portail is a french academic project developed under the GPL (General Public License) augmented according to the following :
A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.
The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .
A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .
The different kinds of licenses governing the products developed by the Apache foundation can be found here : http://www.apache.org/licenses .
It follows that you can as well as use download contents as well modify and redistribute them provided you respect the GPL terms.
Downloading and using such contents do not provide any guaranty.
Be sure that you have well understood the terms of the license before using the contents it covers.
The ESUP-portail distribution includes the following distributions :
    * UPortal : 
      software developed by JA-SIG (Java Architecture - Special Interest Group)
      You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html
    * CAS :
      SSO solution developed by Yale University
      You can find the project page here : http://www.yale.edu/tp/auth
    * Cocoon :
      XML framework distributed by the Apache foundation under Apache license;
      Please find the full text here : http://cocoon.apache.org/2.1/license.html
    * Mod_dav:
      A DAV module for Apache web server
      You can find the project page here : http://www.webdav.org/mod_dav
    * IMP :
      webmail from Horde application framework
      You can find the project page here : http://www.horde.org
    * . To be completed
*/
package org.esupportail.portal.channels.CSMS;




import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CSMS.exception.ExceptionConfigurationCanal;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.PortalException;
import org.jasig.portal.channels.BaseChannel;
import org.jasig.portal.utils.XSLT;
import org.xml.sax.ContentHandler;



/**
 * <p> Titre : CSMS </p>
 * <p> Description : Un canal pour envoyer des messages aux etudiants </p>
 * <p> Copyright : Copyright (c) 2004 </p>
 * <p> Socit : Universit de Valenciennes et du Hainaut Cambrsis </p>
 * @author Yohan Colmant
 * @version 1.0
 */
public class CSMS extends BaseChannel {
	

	/**
	 * Logger object
	 */
	protected static final Log log = LogFactory.getLog(CSMS.class);
	
	private ChannelStaticData staticData;
	private ChannelRuntimeData runtimeData;	
	
	
	
	/**
	 * Le login de l'utilisateur
	 */
	private String login = null;
	
	
	
	
	/**
	 * Le mode du canal: Envoi de message ou saisie du profil de l'etudiant: "profil" ou "envoi"
	 */
	private String mode = "profil";
	
	
	/**
	 * Object utilise si on est en mode de saisie du profil
	 */
	private ActionSaisieProfil actionSaisieProfil;

	
	/**
	 * Object utilise si on est en mode d'envoi de messages
	 */
	private ActionEnvoiMessage actionEnvoiMessage;
	
	
	
	
	
	
	
	/**
	 * Constructeur
	 */
	public CSMS() {		
				
		// on initialise le fichier de log
		try {
			org.esupportail.portal.channels.CSMS.log.Log.init();
		}
		catch(ExceptionConfigurationCanal e) {
			log.error("CSMS: "+e);
		}
		
	}
	
	
	
	
	
	/**
	 * Receive static channel data from the portal. Satisfies implementation of
	 * IChannel Interface.
	 * 
	 * @param sd static channel data
	 */
	public void setStaticData(ChannelStaticData sd) {
		this.staticData = sd;
		
		// le mode du canal: envoi ou profil
		mode = sd.getParameter("channelMode");
				
		// on recupere le login de l'utilisateur				
		login = (String)staticData.getPerson().getAttribute("uid");		
	}
	
	

	/**
	 * Receive channel runtime data from the portal. Satisfies implementation
	 * of IChannel Interface.
	 * 
	 * @param rd handle to channel runtime data
	 */
	public void setRuntimeData(ChannelRuntimeData rd) {
		this.runtimeData = rd;
	}
	
	
	
	
	/**
	 * Output channel content to the portal
	 * @param out a sax document handler
	 * @throws PortalException
	 */
	public void renderXML(ContentHandler out) throws PortalException {		
		
		// Create a new XSLT styling engine
		XSLT xslt = new XSLT(this);
		
		// suivant le mode dans lequel on se trouve
		if (mode.equals("envoi")) {
			if (actionEnvoiMessage==null)
				actionEnvoiMessage = new ActionEnvoiMessage(this.login);
			actionEnvoiMessage.renderXML(out, xslt, runtimeData);
		}
		else {
			if (actionSaisieProfil==null)
				actionSaisieProfil = new ActionSaisieProfil(this.login);
			actionSaisieProfil.renderXML(out, xslt, runtimeData);
		}
		
	}
	
	
	
	
	
}
