/*
ESUP-portail is a french academic project developed under the GPL (General Public License) augmented according to the following :
A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.
The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .
A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .
The different kinds of licenses governing the products developed by the Apache foundation can be found here : http://www.apache.org/licenses .
It follows that you can as well as use download contents as well modify and redistribute them provided you respect the GPL terms.
Downloading and using such contents do not provide any guaranty.
Be sure that you have well understood the terms of the license before using the contents it covers.
The ESUP-portail distribution includes the following distributions :
    * UPortal : 
      software developed by JA-SIG (Java Architecture - Special Interest Group)
      You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html
    * CAS :
      SSO solution developed by Yale University
      You can find the project page here : http://www.yale.edu/tp/auth
    * Cocoon :
      XML framework distributed by the Apache foundation under Apache license;
      Please find the full text here : http://cocoon.apache.org/2.1/license.html
    * Mod_dav:
      A DAV module for Apache web server
      You can find the project page here : http://www.webdav.org/mod_dav
    * IMP :
      webmail from Horde application framework
      You can find the project page here : http://www.horde.org
    * . To be completed
*/
package org.esupportail.portal.channels.CSMS;


/**
 * <p>Titre : Student</p>
 * <p>Description : Represente un etudiant par son nom et prenom, son email et son numero de mobile </p>
 * <p>Copyright : Copyright (c) 2004</p>
 * <p>Socit : Universit de Valenciennes et du Hainaut Cambrsis </p>
 * @author Yohan Colmant
 * @version 1.0
 */

public class Etudiant implements Comparable {
	
	/**
	 * Le nom de l'etudiant. par Exemple: "Dupont Jacques"
	 */
	private String name;
	
	/**
	 * L'email de l'etudiant
	 */
	private String email;
	
	/**
	 * Le numero de telephone de l'etudiant au format 06********
	 */
	private String phone;
	
	
	/**
	 * Constructeur
	 * @param name le nom de l'etudiant
	 * @param email l'email de l'etudiant
	 * @param phone le numero de telephone. Si le numero n'est pas au format 06********, il sera transforme en ce format
	 */
	public Etudiant(String name, String email, String phone) {
		this.name = name;
		this.email = email;
		
		// on regarde le format du numero de telephone
		if (phone != null) {						
			//this.phone = this.phone.replaceAll("[\\p{Punct}33]","0");
			this.phone = phone;
			this.phone = this.phone.trim();
			if (this.phone.startsWith("+33"))
				this.phone = "0"+this.phone.substring(3);			
			this.phone = this.phone.replace('*',' ');
			this.phone = this.phone.replace('-',' ');
			this.phone = this.phone.replace('/',' ');
			this.phone = this.phone.replace('$',' ');
			this.phone = this.phone.replace('.',' ');
			this.phone = this.phone.replace('_',' ');
			this.phone = this.phone.replaceAll(" ","");
			if (this.phone.length()!=10)
				this.phone = null;
		}
		else this.phone = null;		
	}
	
	/**
	 * Retourne le nom
	 * @return le nom
	 */
	public String getName() {
		return this.name;
	}
	
	/**
	 * Retourne l'email
	 * @return l'email
	 */
	public String getEmail() {
		return this.email;
	}
	
	/**
	 * Retourne le numero de telephone
	 * @return le numero au format 06********
	 */
	public String getPhone() {
		return this.phone;
	}
	
	
	/* (non-Javadoc)
	 * @see java.lang.Comparable#compareTo(java.lang.Object)
	 */
	public int compareTo(Object arg0) {
		Etudiant s = (Etudiant)arg0;
		return this.name.compareTo(s.getName());		
	}
	
	
	/**
	 * Retourne une chaine de caractere
	 * @return le nom
	 */
	public String toString() {
		return this.name;
	}
}
