/*
ESUP-portail is a french academic project developed under the GPL (General Public License) augmented according to the following :
A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.
The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .
A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .
The different kinds of licenses governing the products developed by the Apache foundation can be found here : http://www.apache.org/licenses .
It follows that you can as well as use download contents as well modify and redistribute them provided you respect the GPL terms.
Downloading and using such contents do not provide any guaranty.
Be sure that you have well understood the terms of the license before using the contents it covers.
The ESUP-portail distribution includes the following distributions :
    * UPortal : 
      software developed by JA-SIG (Java Architecture - Special Interest Group)
      You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html
    * CAS :
      SSO solution developed by Yale University
      You can find the project page here : http://www.yale.edu/tp/auth
    * Cocoon :
      XML framework distributed by the Apache foundation under Apache license;
      Please find the full text here : http://cocoon.apache.org/2.1/license.html
    * Mod_dav:
      A DAV module for Apache web server
      You can find the project page here : http://www.webdav.org/mod_dav
    * IMP :
      webmail from Horde application framework
      You can find the project page here : http://www.horde.org
    * . To be completed
*/
package org.esupportail.portal.channels.CSMS.log;

import java.util.StringTokenizer;

/**
 * <p>Titre : LogLine</p>
 * <p>Description : Classe permettant de gerer une ligne du fichier de log </p>
 * <p>Copyright : Copyright (c) 2004</p>
 * <p>Socit : Universit de Valenciennes et du Hainaut Cambrsis </p>
 * @author Yohan Colmant
 * @version 1.0
 */
public class LogLine {
	
	/**
	 * La ligne comme elle est dans le fichier
	 */
	private String ligne;
	
	/**
	 * L'id du message
	 */
	private String id;
	
	/**
	 * Le nom de l'expediteur
	 */
	private String expediteur;
	
	/**
	 * La date d'envoi
	 */
	private String date;
	
	/**
	 * Le nombre de SMS envoyes dans ce message
	 */
	private int nombreSms;
	
	
	/**
	 * Constructeur
	 * @param id l'id du message
	 * @param expediteur l'expediteur du message
	 * @param date date d'envoi du message
	 * @param nombreSms Le nombre de SMS envoyes dans ce message
	 */
	public LogLine(String id, String expediteur, String date, int nombreSms) {
		this.ligne = id+";"+expediteur+";"+date+";"+nombreSms;
		this.id = id;
		this.expediteur = expediteur;
		this.date = date;
		this.nombreSms = nombreSms;		
	}
	
	/**
	 * Constructeur
	 * @param ligne une ligne provenant du fichier
	 */
	public LogLine(String ligne) {
		this.ligne = ligne;
		StringTokenizer strToken = new StringTokenizer(ligne,";");
		this.id = strToken.nextToken();
		this.expediteur = strToken.nextToken();
		this.date = strToken.nextToken();
		this.nombreSms = Integer.parseInt(strToken.nextToken());
	}
	
	/**
	 * Retourne l'id du message
	 * @return l'id du message
	 */
	public String getID() {
		return this.id;
	}
	
	/**
	 * Retourne le nom de l'expediteur
	 * @return l'expediteur
	 */
	public String getExpediteur() {
		return this.expediteur;
	}
	
	/**
	 * Retourne La date d'envoi
	 * @return La date d'envoi
	 */
	public String getDate() {
		return this.date;
	}
	
	/**
	 * Retourne Le nombre de SMS envoyes dans ce message
	 * @return Le nombre de SMS envoyes dans ce message
	 */
	public int getNombreSms() {
		return this.nombreSms;
	}
	
	/**
	 * Donne une version String de cette ligne
	 */
	public String toString() {
		return this.ligne;
	}
	
	
}
