/*
ESUP-portail is a french academic project developed under the GPL (General Public License) augmented according to the following :
A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.
The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .
A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .
The different kinds of licenses governing the products developed by the Apache foundation can be found here : http://www.apache.org/licenses .
It follows that you can as well as use download contents as well modify and redistribute them provided you respect the GPL terms.
Downloading and using such contents do not provide any guaranty.
Be sure that you have well understood the terms of the license before using the contents it covers.
The ESUP-portail distribution includes the following distributions :
    * UPortal : 
      software developed by JA-SIG (Java Architecture - Special Interest Group)
      You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html
    * CAS :
      SSO solution developed by Yale University
      You can find the project page here : http://www.yale.edu/tp/auth
    * Cocoon :
      XML framework distributed by the Apache foundation under Apache license;
      Please find the full text here : http://cocoon.apache.org/2.1/license.html
    * Mod_dav:
      A DAV module for Apache web server
      You can find the project page here : http://www.webdav.org/mod_dav
    * IMP :
      webmail from Horde application framework
      You can find the project page here : http://www.horde.org
    * . To be completed
*/
package org.esupportail.portal.channels.CSMS.properties;


import java.net.URL;

import org.apache.commons.digester.Digester;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CSMS.exception.ExceptionConfigurationCanal;

/**
 * <p>Titre : ParseSmsProperties</p>
 * <p>Description : Pour parser un fichier de properties SMS </p>
 * <p>Copyright : Copyright (c) 2004</p>
 * <p>Socit : Universit de Valenciennes et du Hainaut Cambrsis </p>
 * @author Yohan Colmant
 * @version 1.0
 */
public class ParseProprietesCanal {
	
	/**
	 * Logger object
	 */
	protected static final Log log = LogFactory.getLog(ParseProprietesCanal.class);
	
	/**
	 * Les proprietes retrouvees
	 */
	private ProprietesCanal prop;
	
	/**
	 * Le fichier
	 */
	private String file = "properties/channels/org_esup/CSMS/CSms.xml";
	
	
	/**
	 * Singleton permettant de ne pas instancier plusieurs fois cette classe
	 */
	private static ParseProprietesCanal singleton;
	
	
	
	
	
	/**
	 * Constructeur
	 * @throws ExceptionConfigurationCanal
	 */
	private ParseProprietesCanal() throws ExceptionConfigurationCanal {
		try {
			
			URL path = this.getClass().getClassLoader().getResource("");
			String chemin = path+file;
		
			Digester dig = new Digester();
			
			dig.setValidating(false);
			dig.addObjectCreate("properties","org.esupportail.portal.channels.CSMS.properties.ProprietesCanal");
			
			dig.addBeanPropertySetter("properties/sms_cust_id", "smsCustId");
			dig.addBeanPropertySetter("properties/sms_cert", "smsCert");
			dig.addBeanPropertySetter("properties/sms_trust_store", "smsTrustStore");
			dig.addBeanPropertySetter("properties/sms_store_password", "smsStorePassword");
			dig.addBeanPropertySetter("properties/sms_strategy", "smsStrategy");
			dig.addBeanPropertySetter("properties/sms_size", "smsSize");
			dig.addBeanPropertySetter("properties/sms_from", "smsFrom");
			dig.addBeanPropertySetter("properties/sms_from_activation", "smsFromActivation");
			dig.addBeanPropertySetter("properties/sms_subject_activation", "smsSubjectActivation");
			dig.addBeanPropertySetter("properties/sms_message_activation", "smsMessageActivation");
			
			dig.addBeanPropertySetter("properties/mail_url", "mailServeur");
			
			dig.addBeanPropertySetter("properties/ldapUrl", "ldapUrl");
			dig.addBeanPropertySetter("properties/loginLdap", "loginLdap");
			dig.addBeanPropertySetter("properties/passwordLdap", "passwordLdap");			
			dig.addBeanPropertySetter("properties/ldapGroups", "ldapGroups");
			dig.addBeanPropertySetter("properties/ldapPeople", "ldapPeople");
			dig.addBeanPropertySetter("properties/filtreInstituts", "filtreInstituts");
			dig.addBeanPropertySetter("properties/filtreFormations", "filtreFormations");

			dig.addBeanPropertySetter("properties/mobile_attribute", "mobileAttribute");
			dig.addBeanPropertySetter("properties/contact_mode_attribute", "contactModeAttribute");
			dig.addBeanPropertySetter("properties/mail_attribute", "mailAttribute");
			dig.addBeanPropertySetter("properties/display_name_attribute", "displayNameAttribute");
			
			dig.addBeanPropertySetter("properties/logFile", "logFile");
			
			prop = (ProprietesCanal)dig.parse(chemin);			
		}
		catch (Exception e) {
			//e.printStackTrace();
			log.error("constructeur: "+e);
			
			throw new ExceptionConfigurationCanal();
		}
	}
	
	
	
	
	/**
	 * Recupere une instance d'un objet de configuration du canal
	 * @return une instance d'un objet de configuration du canal
	 * @throws ExceptionConfigurationCanal
	 */
	public static ProprietesCanal getInstance() throws ExceptionConfigurationCanal {
		if (singleton==null)
			singleton = new ParseProprietesCanal();
		
		return singleton.prop;
	}
	
	
}
