/*
ESUP-portail is a french academic project developed under the GPL (General Public License) augmented according to the following :
A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.
The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .
A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .
The different kinds of licenses governing the products developed by the Apache foundation can be found here : http://www.apache.org/licenses .
It follows that you can as well as use download contents as well modify and redistribute them provided you respect the GPL terms.
Downloading and using such contents do not provide any guaranty.
Be sure that you have well understood the terms of the license before using the contents it covers.
The ESUP-portail distribution includes the following distributions :
    * UPortal : 
      software developed by JA-SIG (Java Architecture - Special Interest Group)
      You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html
    * CAS :
      SSO solution developed by Yale University
      You can find the project page here : http://www.yale.edu/tp/auth
    * Cocoon :
      XML framework distributed by the Apache foundation under Apache license;
      Please find the full text here : http://cocoon.apache.org/2.1/license.html
    * Mod_dav:
      A DAV module for Apache web server
      You can find the project page here : http://www.webdav.org/mod_dav
    * IMP :
      webmail from Horde application framework
      You can find the project page here : http://www.horde.org
    * . To be completed
*/
package org.esupportail.portal.channels.CSMS.serverSending;

import java.util.Date;
import java.util.Properties;
import java.util.Vector;

import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CSMS.Etudiant;
import org.esupportail.portal.channels.CSMS.exception.ExceptionEnvoiMail;

import com.sun.mail.smtp.SMTPAddressFailedException;
import com.sun.mail.smtp.SMTPMessage;

/**
 * Id: EnvoieSms.java,v 1.0 1 dc. 2004
 * Copyright (c) 2004 Esup Portail (www.esup-portail.org)
 * Classes: EnvoieSms
 * Original Author: Yohan Colmant
 * 
 */
public class EnvoieMail {

	/**
	 * Logger object
	 */
	protected static final Log log = LogFactory.getLog(EnvoieMail.class);

	/**
	 * Sujet du message
	 */
	private String sujet;
	
	/**
	 * Corps du message
	 */
	private String message;

	
	
	
	/**
	 * Url du serveur pour les mails
	 */
	private String mailServeur;
	
	
	/**
	 * Le login de l'expediteur
	 */
	private String mailExpediteur;
	
	
	
	
	/**
	 * Constructeur
	 * @param sujet le sujet du message
	 * @param message le corps du message
	 * @param mailServeur le serveur de mail
	 * @param mailExpediteur le mail de l'expediteur
	 * @param nomExpediteur le nom de l'expediteur
	 */
	public EnvoieMail(String sujet, String message, String mailServeur, String mailExpediteur, String nomExpediteur) {		
		this.sujet = sujet;
		this.message = message;
		this.mailServeur = mailServeur;		
		if (mailExpediteur!=null)
			this.mailExpediteur = mailExpediteur;
		else this.mailExpediteur = nomExpediteur.replaceAll(" ","");		
	}
	
	
	
	/**
	 * Envoie le mail
	 * @param destinataires les destinataires du message
	 * @throws ExceptionEnvoiMail
	 */
	public void sendMessage(Vector destinataires) throws ExceptionEnvoiMail {	
		
		try {
			
			// destinataires
			Vector dests = new Vector();
			
            for (int i=0; i<destinataires.size(); i++) {
            	Etudiant st = (Etudiant)destinataires.elementAt(i);
            	
            	String studentMail = st.getEmail();
            	if (studentMail!=null) {
            		try {
            			dests.addElement(new InternetAddress(studentMail));            			
            		}
            		catch (AddressException e) {
            			log.error("sendMessage: "+e);
            		} 
            	}
            	
            }
            
            // si aucun, on sort
            int nbDests = dests.size();
            if (nbDests==0)
            	return ;
			
            // on construit le tableau
            InternetAddress[] internetAddresses = new InternetAddress[nbDests];
            for (int i=0; i<nbDests; i++) {
            	internetAddresses[i] = (InternetAddress)dests.elementAt(i);
            }
            
			// on envoie
            Properties prop = System.getProperties();
            prop.put("mail.smtp.host", this.mailServeur);
            prop.put("mail.imap.connectiontimeout", "10000");
            
            Session session = Session.getDefaultInstance(prop,null);
            
            SMTPMessage message = new SMTPMessage(session);
            message.setSendPartial(true);
            message.setFrom(new InternetAddress(this.mailExpediteur));
            
            message.setRecipients(Message.RecipientType.TO,internetAddresses);
            
            message.setSubject(this.sujet);
            message.setText(this.message);
            message.setHeader("X-Mailer", "Java");
            message.setSentDate(new Date());
            
            session.setDebug(false);
            
            Transport.send(message);      
		} 
  
		catch (SMTPAddressFailedException e) {
			log.error("sendMessage: "+e);
		}
		catch (MessagingException e) {
			log.error("sendMessage: "+e);
			throw new ExceptionEnvoiMail();
		}
		
	}
	
	
	
}
