/*
ESUP-portail is a french academic project developed under the GPL (General Public License) augmented according to the following :
A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.
The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .
A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .
The different kinds of licenses governing the products developed by the Apache foundation can be found here : http://www.apache.org/licenses .
It follows that you can as well as use download contents as well modify and redistribute them provided you respect the GPL terms.
Downloading and using such contents do not provide any guaranty.
Be sure that you have well understood the terms of the license before using the contents it covers.
The ESUP-portail distribution includes the following distributions :
    * UPortal : 
      software developed by JA-SIG (Java Architecture - Special Interest Group)
      You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html
    * CAS :
      SSO solution developed by Yale University
      You can find the project page here : http://www.yale.edu/tp/auth
    * Cocoon :
      XML framework distributed by the Apache foundation under Apache license;
      Please find the full text here : http://cocoon.apache.org/2.1/license.html
    * Mod_dav:
      A DAV module for Apache web server
      You can find the project page here : http://www.webdav.org/mod_dav
    * IMP :
      webmail from Horde application framework
      You can find the project page here : http://www.horde.org
    * . To be completed
*/
package org.esupportail.portal.channels.CSMS.serverSending;


import java.io.FileInputStream;
import java.net.URL;
import java.rmi.RemoteException;
import java.security.KeyStore;

import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import javax.xml.rpc.ServiceException;

import org.apache.axis.AxisProperties;
import org.esupportail.portal.channels.CSMS.exception.ExceptionConfigurationCanal;
import org.esupportail.portal.channels.CSMS.properties.ParseProprietesCanal;

import com.francetelecom.rd.mdws.IMultiDiffusionWS;
import com.francetelecom.rd.mdws.IMultiDiffusionWSService;
import com.francetelecom.rd.mdws.IMultiDiffusionWSServiceLocator;
import com.francetelecom.rd.mdws.MultiDiffusionWSStub;
import com.francetelecom.rd.mdws.WSMessage;
import com.francetelecom.rd.mdws.WSSendReport;

/**
 * <p>Titre : PostWSConnection</p>
 * <p>Description : Permet de poster sur un serveur </p>
 * <p>Copyright : Copyright (c) 2006</p>
 * <p>Socit : Universit de Valenciennes et du Hainaut Cambrsis </p>
 * @author Yohan Colmant
 * @version 1.0
 */
public class PostWSConnection {
	
	
    /**
     * Le stub
     */
    private MultiDiffusionWSStub stub;
	
    
    /**
     * Constructeur
     * @throws ServiceException
     * @throws ExceptionConfigurationCanal
     */
    public PostWSConnection() throws ServiceException, ExceptionConfigurationCanal {
    	
    	// mise en place de la scurit
		AxisProperties.setProperty("org.apache.axis.components.net.SecureSocketFactory", "org.esupportail.portal.channels.CSMS.serverSending.SecureSocketFactoryImpl");

    	IMultiDiffusionWSService loc = new IMultiDiffusionWSServiceLocator();
    	IMultiDiffusionWS proxy = loc.getMultiDiffusionWS();

    	// Rcupration du stub client
    	stub = (MultiDiffusionWSStub) proxy;
    }
    
    
    
    
    /**
     * Pour envoyer la requete
     * @param custId le numero de client
     * @param strategy la stategie
     * @param from de qui vient le message
     * @param to a qui va le message
     * @param orgName le nom de l'organisme
     * @param subject le sujet du message
     * @param content le contenu du message
     * @param resumeContent le resume du message
     * @param sendProfiles les profils d'envoi
     * @return l'identifiant de message de retour
     * @throws RemoteException
     */
    public String send(String custId, String strategy, String from, String to, String orgName, String subject, String content, String resumeContent, String sendProfiles) throws RemoteException {

    	WSMessage message = new WSMessage(content, custId, from, orgName, resumeContent, sendProfiles, strategy, subject, to);
    	
    	WSSendReport report = stub.sendMessage(message);
    	
    	return report.getMsgId();
    }
    
}
