/*
 * Created on 12 oct. 06
 */
package org.esupportail.portal.channels.CSMS.serverSending;

import java.io.FileInputStream;
import java.net.Socket;
import java.security.KeyStore;
import java.util.Hashtable;

import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;

import org.apache.axis.components.net.BooleanHolder;
import org.apache.axis.components.net.SecureSocketFactory;
import org.esupportail.portal.channels.CSMS.properties.ParseProprietesCanal;

/**
 * Id: SecureSocketFactoryImpl.java,v 1.0 12 oct. 06
 * Copyright (c) 2005 Esup Portail (www.esup-portail.org)
 * Classes: SecureSocketFactoryImpl
 * Original Author: Yohan Colmant
 * 
 */
public class SecureSocketFactoryImpl implements SecureSocketFactory {
	
	public SecureSocketFactoryImpl(Hashtable ht) throws Exception {
	}
	
	public Socket create(String host, int port, StringBuffer hds, BooleanHolder bh) throws Exception {

		SSLSocket theSocket = null;
		try {
			
			String dossier = "properties/channels/org_esup/CSMS/SSL/";
	    	String path = this.getClass().getClassLoader().getResource("").getFile();
			String chemin = path+dossier;
			
			String keyStore = chemin+ParseProprietesCanal.getInstance().getSmsCert();
			String pass = ParseProprietesCanal.getInstance().getSmsStorePassword();
			String trustStore = chemin+ParseProprietesCanal.getInstance().getSmsTrustStore();
			
			KeyStore ks = KeyStore.getInstance("JKS");
			ks.load(new FileInputStream(keyStore), pass.toCharArray());
			
			KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
			kmf.init(ks, pass.toCharArray());
			 
			KeyStore ts = KeyStore.getInstance("JKS");
			ts.load(new FileInputStream(trustStore), "".toCharArray());
			
			TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
			tmf.init(ts);
			
			SSLContext sslContext = SSLContext.getInstance("SSL");
			sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
			
			
			
			
			SSLSocketFactory socketFactory = sslContext.getSocketFactory();
			theSocket = (SSLSocket) socketFactory.createSocket(host, 443);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return theSocket;
	}
}

