<?xml version='1.0' encoding='iso-8859-1' ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:param name="target.window">_blank</xsl:param>
<xsl:param name="baseActionURL">no parameter passed</xsl:param>
<xsl:param name="mediaPath">media/org/esupportail/portal/channels/CSignet</xsl:param>

<xsl:template name="BookmarkTree">
	<xsl:param name="TreeMode">View</xsl:param>
	
	<table width="100%" border="0" cellpadding="0" cellspacing="0">
		<xsl:attribute name="class"><xsl:if test="$TreeMode != 'View'">uportal-background-med</xsl:if></xsl:attribute>
		<xsl:if test="$TreeMode='AddFolder' or $TreeMode='AddBookmark'">
			<tr align="left" valign="top" class="uportal-background-light">
				<td align="left" valign="top" class="uportal-channel-text">
					<input type="radio" name="FolderRadioButton" value="RootLevel" checked="true" class="uportal-input-text"/>
				</td>
				<td width="100%" align="left" class="uportal-channel-text"><strong>Nouveau 
					<xsl:choose>
						<xsl:when test="substring-after($TreeMode,'Add')='Folder'">
						 Rpertoire
						</xsl:when>
						<xsl:when test="substring-after($TreeMode,'Add')='Bookmark'">
						 Signet
						</xsl:when>
					</xsl:choose>
					au niveau racine</strong></td>
			</tr>
			<tr class="uportal-background-med"><td colspan="2"><img src="{$mediaPath}/transparent.gif" border="0" width="1" height="1"/></td></tr>
		</xsl:if>
		
		<xsl:if test="$TreeMode='MoveBookmark' and count(/xbel/bookmark)=0">
		<tr align="left" valign="top">
			<td align="left" valign="top" class="uportal-channel-text" width="7">
			</td>
			<td align="left" valign="top">
				<img src="{$mediaPath}/transparent.gif" width="{(count(ancestor::*)-1) * 4 + (count(ancestor::*)-1) * 16}" height="16"/>
				<input type="radio" name="Position" value="RootLevel" class="uportal-input-text"/>Dplacer dans ce rpertoire
			</td>
		</tr>
		</xsl:if>

    <xsl:apply-templates select="/xbel/bookmark">
		<!-- <xsl:sort select="@id"/> -->
			<xsl:with-param name="TreeMode">
				<xsl:value-of select="$TreeMode"/>
			</xsl:with-param>
		</xsl:apply-templates>
		
		<xsl:apply-templates select="/xbel/folder">
		<!-- <xsl:sort select="@id"/> -->
			<xsl:with-param name="TreeMode">
				<xsl:value-of select="$TreeMode"/>
			</xsl:with-param>
		</xsl:apply-templates>
      
	</table>
</xsl:template>

<xsl:template match="folder">
	<xsl:param name="TreeMode">View</xsl:param>
	<tr align="left" valign="top">
		<xsl:attribute name="class">
			<xsl:choose>
				<xsl:when test="$TreeMode = 'View'">uportal-background-content</xsl:when>
				<xsl:when test="$TreeMode != 'DeleteBookmark'">uportal-background-light</xsl:when>
				<xsl:otherwise>uportal-background-med</xsl:otherwise>
			</xsl:choose>
		</xsl:attribute>
		<!-- Display a radio button or checkbox if in edit mode -->
		<td align="left" valign="top" class="uportal-channel-text" width="7">
			<xsl:choose>
				<!-- 3-FEB-2003-MBM: Added EditFolder/EditBookmark -->
				<xsl:when test="$TreeMode='AddFolder' or $TreeMode='AddBookmark' or $TreeMode='EditFolder'">
					<input type="radio" name="FolderRadioButton" value="{@id}" class="uportal-input-text"/>
				</xsl:when>
				<xsl:when test="$TreeMode='DeleteFolder'">
					<input type="checkbox" name="FolderCheckbox#{@id}" class="uportal-input-text"/>
				</xsl:when>
			</xsl:choose>
		</td>
		<td align="left" valign="top">
			<!-- Indent the folder -->
			<xsl:if test="$TreeMode='MoveFolder'">
				<img src="{$mediaPath}/transparent.gif" width="{((count(ancestor::*)-1) * 4 + (count(ancestor::*)-1) * 16)}" height="16"/>
				<input type="radio" name="Position" value="{concat(@id,'n')}" class="uportal-input-text"/>Dplacer ici<br/>
			</xsl:if>
			<img src="{$mediaPath}/transparent.gif" width="{(count(ancestor::*)-1) * 4 + (count(ancestor::*)-1) * 16}" height="16"/>
			<xsl:if test="$TreeMode ='MoveFolder'">
				<input type="radio" name="FolderToMove" value="{@id}" class="uportal-input-text"/>
			</xsl:if>
			<!-- Display an open or closed folder icon and the folder title -->
			<xsl:choose>
				<xsl:when test="@folded='yes'">
					<a href="{$baseActionURL}?command=unfold&amp;ID={@id}">
					<img src="{$mediaPath}/folded_yes.gif" border="0" alt="Ouvrir le rpertoire"/>
					<img src="{$mediaPath}/transparent.gif" border="0" width="4" height="16"/>
					<strong class="uportal-channel-text">
						<xsl:value-of select="title"/>
					</strong>
           </a>
				</xsl:when>
				<xsl:otherwise>
					<a href="{$baseActionURL}?command=fold&amp;ID={@id}">
					<img src="{$mediaPath}/folded_no.gif" border="0" alt="Fermer le rpertoire"/>
					<img src="{$mediaPath}/transparent.gif" border="0" width="4" height="16"/>
					<strong class="uportal-channel-text">
						<xsl:value-of select="title"/>
					</strong>
					</a>
				</xsl:otherwise>
			</xsl:choose>
				
			<xsl:if test="(($TreeMode='MoveBookmark' and not(bookmark)) or ($TreeMode='MoveFolder'  and not(folder))) ">
				<input type="radio" name="Position" value="{concat(@id,'f')}" class="uportal-input-text"/>Dplacer dans ce rpertoire
			</xsl:if>
			
			<xsl:if test="$TreeMode='MoveFolder'">
				<xsl:if test="position()=last()">
					<br/>
					<img src="{$mediaPath}/transparent.gif" width="{((count(ancestor::*)-1) * 4 + (count(ancestor::*)-1) * 16)}" height="16"/>
					<input type="radio" name="Position" value="{concat(@id,'e' )}" class="uportal-input-text"/> Dplacer ici
				</xsl:if>
			</xsl:if>
			<!--         <xsl:variable name="temp" select="{substring(@id,2,string-length(@id))}" /> -->
		</td>
	</tr>
	<xsl:if test="$TreeMode != 'View'">
		<tr class="uportal-background-med">
			<td colspan="2">
				<img src="{$mediaPath}/transparent.gif" border="0" width="1" height="1"/>
			</td>
		</tr>
	</xsl:if>
	
	<!-- Recurse through the subtrees if the folder is open -->
	<xsl:if test="@folded='no'">
		<xsl:apply-templates select="bookmark">
		<!-- <xsl:sort select="@id"/> -->
			<xsl:with-param name="TreeMode">
				<xsl:value-of select="$TreeMode"/>
			</xsl:with-param>
		</xsl:apply-templates>
		
		<xsl:apply-templates select="folder">
			<!--  <xsl:sort select="@id"/> -->
			<xsl:with-param name="TreeMode">
				<xsl:value-of select="$TreeMode"/>
			</xsl:with-param>
		</xsl:apply-templates>
	</xsl:if>
</xsl:template>
  
<xsl:template match="bookmark">
	<xsl:param name="TreeMode">View</xsl:param>
		<xsl:if test="$TreeMode!='MoveFolder'">
			<tr align="left" valign="top" >
				<xsl:attribute name="class">
					<xsl:choose>
						<xsl:when test="$TreeMode = 'View'">uportal-background-content</xsl:when>
						<xsl:when test="$TreeMode = 'DeleteBookmark'">uportal-background-light</xsl:when>
						<xsl:otherwise>uportal-background-med</xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
				<!-- Display a radio button or checkbox if in edit mode -->
					<td align="left" valign="top" class="uportal-channel-text">
						<xsl:choose>
							<!-- 3-FEB-2003-MBM: Added EditFolder/EditBookmark -->
							<xsl:when test="$TreeMode='EditBookmark'">
								<input type="radio" name="BookmarkRadioButton" value="{@id}" class="uportal-input-text"/>
							</xsl:when>
							<xsl:when test="$TreeMode='DeleteBookmark'">
								<input type="checkbox" name="BookmarkCheckbox#{@id}" class="uportal-input-text"/>
							</xsl:when>
						</xsl:choose>
					</td>
					<td align="left" valign="top" class="uportal-channel-text">
        <!-- Indent the bookmark -->
        <xsl:if test="$TreeMode='MoveBookmark'">
         <img src="{$mediaPath}/transparent.gif" width="{(count(ancestor::*)-1) * 4 + (count(ancestor::*)-1) * 16 }" height="16"/>
         <input type="radio" name="Position" value="{concat (@id,'n')}" class="uportal-input-text"/>
         Dplacer ici
         <br/>
        </xsl:if>
        <img src="{$mediaPath}/transparent.gif" width="{(count(ancestor::*)-1) * 4 + (count(ancestor::*)-1) * 16 }" height="16"/>
       <xsl:if test="$TreeMode='MoveBookmark'">
               
               <input type="radio" name="BookmarkToMove" value="{@id}" class="uportal-input-text"/>

       </xsl:if>
       
       
				<xsl:variable name="description" select="desc" />
        <a href="{@href}" target="{$target.window}"><img src="{$mediaPath}/bookmark.gif" alt="{$description}" border="0"/><img src="{$mediaPath}/transparent.gif" border="0" width="4" height="16"/>
          <xsl:value-of select="title"/>
        </a>

    <xsl:if test="$TreeMode='MoveBookmark'">
        <xsl:if test="position()=last()" >
        <br/>
        <img src="{$mediaPath}/transparent.gif" width="{(count(ancestor::*)-1) * 4 + (count(ancestor::*)-1) * 16 }" height="16"/>
        <input type="radio" name="Position" value="{concat (@id,'e')}" class="uportal-input-text"/>
        Dplacer ici
        </xsl:if>
     </xsl:if>
         </td>
      
          </tr>
      <xsl:if test="$TreeMode != 'View'"><tr class="uportal-background-med"><td colspan="2">
       <img src="{$mediaPath}/transparent.gif" border="0" width="1" height="1"/>
       </td></tr>

</xsl:if>
       </xsl:if></xsl:template>
</xsl:stylesheet>
<!-- Stylus Studio meta-information - (c)1998-2001 eXcelon Corp.
<metaInformation>
<scenarios/>
</metaInformation>
-->
