<?xml version='1.0' encoding='iso-8859-1' ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:import href="bookmark_tree_html.xsl"/>
  <xsl:param name="baseActionURL">default</xsl:param>
  <xsl:param name="imagesURL">media/org/esupportail/portal/channels/CSignet/</xsl:param>
  <!-- This parameter tells the stylesheet which nodes to put radio buttons next to -->
  <xsl:param name="MoveMode">MoveBookmark</xsl:param>
    <xsl:variable name="MoveTitle">
    <xsl:text>Move</xsl:text>
    <xsl:value-of select="substring-after($MoveMode,'Move')"/>
  </xsl:variable>

  <xsl:template match="/">
		<form action="{$baseActionURL}?command={$MoveMode}" method="post">
			<table border="0" cellpadding="6">
				<tr>
					<td class="uportal-channel-subtitle">Dplacer un 
						<xsl:choose>
							<xsl:when test="$MoveMode='MoveBookmark'">
								Signet
							</xsl:when>
							<xsl:when test="$MoveMode='MoveFolder'">
								Rpertoire
							</xsl:when>
						</xsl:choose>
					</td>
				</tr>
			</table>
			
			<xsl:call-template name="BookmarkTree">
				<xsl:with-param name="TreeMode"><xsl:value-of select="$MoveTitle"/></xsl:with-param>
			</xsl:call-template>
		
			<hr/>Slectionnez le
				<xsl:if test="$MoveTitle='MoveBookmark'">signet </xsl:if>
				<xsl:if test="$MoveTitle='MoveFolder'">rpertoire </xsl:if>
				que vous souhaitez dplacer et sa nouvelle position
			<hr/>
			<input type="submit" name="move" value="Dplacer" class="uportal-button"/>
			<input type="submit" name="cancel" value="Annuler" class="uportal-button"/>
		</form>
	</xsl:template>
</xsl:stylesheet>
<!-- Stylus Studio meta-information - (c)1998-2001 eXcelon Corp.
<metaInformation>
<scenarios/>
</metaInformation>
-->
