package org.esupportail.portal.channels.CSignet2.actions;


//import org.apache.log4j.Priority;


import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.plugins.Message;
import org.esupportail.portal.utils.channels.plugins.MessageBean;
import org.esupportail.portal.channels.CSignet2.beans.Folder;
import org.esupportail.portal.channels.CSignet2.data.DataControler;
import org.esupportail.portal.channels.CSignet2.data.DataException;
import org.esupportail.portal.channels.CSignet2.data.DataRetriever;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;


/**
 * Principal<br>
 * <br>
 * Cette action prend en charge l'affichage de l'arbre en mode Modification ainsi 
 * que toutes les actions accesibles par ce mode<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:celine.bissler@uhp-nancy.fr">Cline Bissler</a>
 * @version 1.1 
 */

public class Principal extends SignetAction {

	/**
	 * Constructeur
	 * @param mainChannel Channel principale
	 */
	public Principal(MainChannel mainChannel) {
		super(mainChannel);
		log.info("CSignet2 - Principal::Principal()");
		log.info("CSignet2 - SignetAction::init() normal on repasse par la");
        id_elements_copy=new Vector();
	}
	
	/**
	 * Recherche de l'arborescence de signets de l'utilisateur connect
	 * @param rd Le RuntimeData
	 * @return Boolean.TRUE si l'action s'est bien passe, Boolean.FALSE sinon
	 */
	public Boolean init(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		log.info("CSignet2 - Principal::init()");
		runtimeData = rd;
		paramAction();
		
		DataControler cd=new DataControler();
		root=new Folder();

	    try {
             root=cd.RecupererArbrePerso(login);
             xmlroot=root.toXMLComplet();
        } catch (DataException e) {
            log.error("CSignet2 - Principal::init() : Erreur d'acc\u00E8s \u00E0 la page "+e.getMessage());
            Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "default");		
        	return Boolean.FALSE;
        }
	    id_folder_courant=root.getId();
		return Boolean.TRUE;
	}
	/**
	 * Init visualisation
	 * @param rd Le RuntimeData
	 * @return Boolean.TRUE si l'action s'est bien passe, Boolean.FALSE sinon
	 * @throws PortalException
	 * @throws FrameWorkException
	 */
	public Boolean initVue(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		log.info("CSignet2 - Principal::initVue()");
		runtimeData = rd;
		paramAction();
		
		return Boolean.TRUE;
	}
	/**
	 * Init d'affichage aprs une modification
	 * @param rd Le RuntimeData
	 * @return Boolean.TRUE si l'action s'est bien passe, Boolean.FALSE sinon
	 * @throws PortalException
	 * @throws FrameWorkException
	 */
	public Boolean initRetour(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		log.info("CSignet2 - Principal::initRetour()");
		runtimeData = rd;
		paramAction();
		DataControler cd=new DataControler();
	   	root=new Folder();

	    try {
            root=cd.RecupererArbrePerso(login);
            xmlroot=root.toXMLComplet();
        } catch (DataException e) {
            log.error( "CSignet2 - Principal::init() : Erreur d'acc\u00E8s \u00E0 la page "+e.getMessage());
            Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "default");		
            return Boolean.FALSE;
        }
	    return Boolean.TRUE;
	}
	/**
	 * Init de dplacement d'un lment vers le haut ou vers le bas
	 * @param rd Le RuntimeData
	 * @return Boolean.TRUE si l'action s'est bien passe, Boolean.FALSE sinon
	 * @throws PortalException
	 * @throws FrameWorkException
	 */
	public Boolean initBouger(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		log.info("CSignet2 - Principal::initBouger()");
		runtimeData = rd;
		
		paramAction();
		
	    //verification des parmetres
	    if((runtimeData.getParameter("sens")==null)||(runtimeData.getParameter("id")==null)||(runtimeData.getParameter("ordre")==null)||(runtimeData.getParameter("parent")==null))
	    {
	        log.error( "CSignet2 - Principal::initBouger() : Erreur d'acc\u00E8s \u00E0 la page");
	        Message.message(mainChannel, runtimeData, new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "default");		
	        return Boolean.FALSE;
		}
	    int id=Integer.parseInt(runtimeData.getParameter("id"));
	    int parent=Integer.parseInt(runtimeData.getParameter("parent"));
	    int ordre=Integer.parseInt(runtimeData.getParameter("ordre"));
	    String sens=runtimeData.getParameter("sens");
	    DataControler dr = new DataControler();
	    
	    try {
	        if (sens.equals("monter"))
	            dr.monterElement(id,parent,ordre);
	        else
	            dr.descendreElement(id,parent,ordre);
        } catch (DataException e) {
            log.error("CSignet2 - Principal::initBouger() : Erreur dans le deplacement : "+e.getMessage());
    		Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "default");		
    		return Boolean.FALSE;
        }
		DataControler cd=new DataControler();
        try {
            root=cd.RecupererArbrePerso(login);
            xmlroot=root.toXMLComplet();
        } catch (DataException e) {
            log.error("CSignet2 - Principal::initBouger() : Erreur d'acc\u00E8s \u00E0 la page "+e.getMessage());
    		Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "default");		
    		return Boolean.FALSE;
        }
     
		return Boolean.TRUE;
	}
	/**
	 * Init permettant de coller l'element en copie dans le rpertoire courant
	 * @param rd Le RuntimeData
	 * @return Boolean.TRUE si l'action s'est bien passe, Boolean.FALSE sinon
	 * @throws PortalException
	 * @throws FrameWorkException
	 */
	public Boolean initCouper(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		log.info("CSignet2 - Principal::initCouper()");
		runtimeData = rd;
		if (runtimeData.getParameter("id_element_copy")!=null){
		    log.debug("CSignet2 - Principal::initCouper() parametre element copy "+runtimeData.getParameter("id_element_copy"));
			int id_element_copy=Integer.parseInt(runtimeData.getParameter("id_element_copy"));
			String title_element_copy=null;
			String type_element_copy=null;
			try {
                DataControler d=new DataControler();
                Hashtable t=d.getOrdreParent(id_element_copy);
                title_element_copy=(String)t.get("title");
                type_element_copy=(String)t.get("type");
            } catch (DataException e) {
                log.debug("CSignet2 - Principal::initCouper() : Erreur d'acc\u00E8s \u00E0 la page "+e.getMessage());
        		Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "default");			
            }
	   
		    if(id_element_copy==root.getId())
		    {
		        log.error( "CSignet2 - Principal::initCouper() : Impossible de d"+carac.getCode("")+"placer la racine ");
		        Message.message(mainChannel, runtimeData, new MessageBean("Impossible de d"+carac.getCode("")+"placer la racine "), "defaultModif");		
	    		return Boolean.FALSE;
	        }
		    else{
		        Hashtable tmp=new Hashtable();
		        tmp.put("id",new Integer(id_element_copy));
		        tmp.put("title",title_element_copy);
		        tmp.put("type",type_element_copy);
		        if(!id_elements_copy.contains(tmp))
		            id_elements_copy.add(tmp);
		        
		        log.debug("CSignet2 - Principal::initCouper() : On a mis "+id_element_copy+" avec "+title_element_copy+" vide? "+id_elements_copy.isEmpty());
        		
		    }
		}
		//runtimeData.put("id_elements_copy", id_elements_copy);
	    
		return Boolean.TRUE;
	}
	/**
	 * Init permettant de coller l'element en copie dans le rpertoire courant
	 * @param rd Le RuntimeData
	 * @return Boolean.TRUE si l'action s'est bien passe, Boolean.FALSE sinon
	 * @throws PortalException
	 * @throws FrameWorkException
	 */
	public Boolean initColler(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		log.info("CSignet2 - Principal::initColler()");
		runtimeData = rd;
		int id_element_copy;
		String title_element_copy;
		String type_element_copy;
		if (runtimeData.getParameter("id_element_copy")!=null)
		{
		    log.debug("CSignet2 - Principal::initCouper() parametre element copy "+runtimeData.getParameter("id_element_copy"));
			id_element_copy=Integer.parseInt(runtimeData.getParameter("id_element_copy"));
			title_element_copy=null;
			type_element_copy=null;
			try {
                DataControler d=new DataControler();
                Hashtable t=d.getOrdreParent(id_element_copy);
                title_element_copy=(String)t.get("title");
                type_element_copy=(String)t.get("type");
            } catch (DataException e) {
                log.debug("CSignet2 - Principal::initColler() : Erreur d'acc\u00E8s \u00E0 la page "+e.getMessage());
        		Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "default");			
            }
        }
		else
		{
            log.debug("CSignet2 - Principal::initCouper() : Erreur d'acc\u00E8s \u00E0 la page ");
    		Message.message(mainChannel, runtimeData, new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "default");	
    		return Boolean.FALSE;
        }
		
		    log.info("CSignet2 - Principal::initColler() on colle "+id_element_copy);
		    //DataControler dr = new DataControler();
		    if(id_element_copy==root.getId())
		    {
		        log.error( "CSignet2 - Principal::initColler() : Impossible de d"+carac.getCode("")+"placer la racine ");
		        Message.message(mainChannel, runtimeData, new MessageBean("Impossible de d"+carac.getCode("")+"placer la racine "), "defaultModif");		
	    		return Boolean.FALSE;
	        }
		    else if(id_element_copy==id_folder_courant)
		    {
		        log.error( "CSignet2 - Principal::initColler() : Impossible de d"+carac.getCode("")+"placer un "+carac.getCode("")+"l"+carac.getCode("")+"ment dans lui-m"+carac.getCode("")+"me ");
		        Message.message(mainChannel, runtimeData, new MessageBean("Impossible de d"+carac.getCode("")+"placer un "+carac.getCode("")+"l"+carac.getCode("")+"ment dans lui-m"+carac.getCode("")+"me "), "defaultModif");		
	    		return Boolean.FALSE;
	        }
		    else{
		        Hashtable tmp=new Hashtable();
		        tmp.put("id",new Integer(id_element_copy));
		        tmp.put("title",title_element_copy);
		        tmp.put("type",type_element_copy);
		        if(id_elements_copy.contains(tmp))
		        {
		            try{
		            DataControler d=new DataControler();
		            d.collerElement(id_element_copy,id_folder_courant);
		            id_elements_copy.remove(tmp);
			        } catch (DataException e) {
			            log.error("CSignet2 - Principal::initColler() : Erreur dans le deplacement "+e.getMessage());
			    		Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "default");		
			    		return Boolean.FALSE;
			        }
		        }
		        log.debug("CSignet2 - Principal::initCouper() : On a mis "+id_element_copy+" avec "+title_element_copy+" vide? "+id_elements_copy.isEmpty());
       	   
		}
		DataControler cd=new DataControler();
        try {
            log.error( "CSignet2 - Principal::initColler() : Impossible de recup arbe ");
           
            root=cd.RecupererArbrePerso(login);
            xmlroot=root.toXMLComplet();
            log.error( "CSignet2 - Principal::initColler() : Impossible de recup arbe FIN");
	        
        } catch (DataException e1) {
            log.error("CSignet2 - Principal::initColler() : Erreur d'acc\u00E8s \u00E0 la page "+e1.getMessage());
    		Message.message(mainChannel, runtimeData, new MessageBean(e1.getMessage()), "default");		
    		return Boolean.FALSE;
        }
		return Boolean.TRUE;
	}
	/**
	 * Init permettant de coller la liste des elements en copie dans le rpertoire courant
	 * @param rd Le RuntimeData
	 * @return Boolean.TRUE si l'action s'est bien passe, Boolean.FALSE sinon
	 * @throws PortalException
	 * @throws FrameWorkException
	 */
	public Boolean initCollerTout(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		log.info("CSignet2 - Principal::initColler()");
		runtimeData = rd;
		Enumeration en=id_elements_copy.elements();
		while (en.hasMoreElements())
		{
		    Hashtable tmp=(Hashtable)en.nextElement();
		    int id_element_copy=((Integer)tmp.get("id")).intValue();
			String title_element_copy=null;
			String type_element_copy=null;
			try {
                DataControler d=new DataControler();
                Hashtable t=d.getOrdreParent(id_element_copy);
                title_element_copy=(String)t.get("title");
                type_element_copy=(String)t.get("type");
            } catch (DataException e) {
                log.debug("CSignet2 - Principal::initCouper() : Erreur d'acc\u00E8s \u00E0 la page "+e.getMessage());
        		Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "default");			
            }
            if(id_element_copy==root.getId())
		    {
		        log.error( "CSignet2 - Principal::initColler() : Impossible de d"+carac.getCode("")+"placer la racine ");
		        Message.message(mainChannel, runtimeData, new MessageBean("Impossible de d"+carac.getCode("")+"placer la racine "), "defaultModif");		
	    		return Boolean.FALSE;
	        }
		    else if(id_element_copy==id_folder_courant)
		    {
		        log.error( "CSignet2 - Principal::initColler() : Impossible de d"+carac.getCode("")+"placer un "+carac.getCode("")+"l"+carac.getCode("")+"ment dans lui-m"+carac.getCode("")+"me ");
		        Message.message(mainChannel, runtimeData, new MessageBean("Impossible de d"+carac.getCode("")+"placer un "+carac.getCode("")+"l"+carac.getCode("")+"ment dans lui-m"+carac.getCode("")+"me "), "defaultModif");		
	    		return Boolean.FALSE;
	        }
		    else{
		        try {
		            DataControler d=new DataControler();
		            d.collerElement(id_element_copy,id_folder_courant);
		            
		        } catch (DataException e) {
		            log.error("CSignet2 - Principal::initColler() : Erreur dans le deplacement "+e.getMessage());
		    		Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "default");		
		    		return Boolean.FALSE;
		        }	
		    }
		}
		DataControler cd=new DataControler();
        try {
            log.error( "CSignet2 - Principal::initColler() : Impossible de recup arbe ");
            id_elements_copy.clear();
            root=cd.RecupererArbrePerso(login);
            xmlroot=root.toXMLComplet();
            log.error( "CSignet2 - Principal::initColler() : Impossible de recup arbe FIN");
	        
        } catch (DataException e) {
            log.error("CSignet2 - Principal::initColler() : Erreur d'acc\u00E8s \u00E0 la page "+e.getMessage());
    		Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "default");		
    		return Boolean.FALSE;
        }
		return Boolean.TRUE;
	}
	
	/**
	 * Init de suppression de l'lment en copie
	 * @param rd Le RuntimeData
	 * @return Boolean.TRUE si l'action s'est bien passe, Boolean.FALSE sinon
	 * @throws PortalException
	 * @throws FrameWorkException
	 */
	public Boolean initSupColler(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		log.info("CSignet2 - Principal::initSupColler()");
		runtimeData = rd;
		
		log.debug("CSignet2 - Principal::initSupColler() parametre element copy"+runtimeData.getParameter("id_element_copy"));
		int id_element_copy=Integer.parseInt(runtimeData.getParameter("id_element_copy"));
		String title_element_copy=null;
		String type_element_copy=null;
		try {
            DataControler d=new DataControler();
            Hashtable t=d.getOrdreParent(id_element_copy);
            title_element_copy=(String)t.get("title");
            type_element_copy=(String)t.get("type");
        } catch (DataException e) {
            log.debug("CSignet2 - Principal::initSupColler() : Erreur d'acc\u00E8s \u00E0 la page "+e.getMessage());
    		Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "default");			
        }
   
	    if(id_element_copy==root.getId())
	    {
	        log.error( "CSignet2 - Principal::initSupColler() : Impossible de d"+carac.getCode("")+"placer la racine ");
	        Message.message(mainChannel, runtimeData, new MessageBean("Impossible de d"+carac.getCode("")+"placer la racine "), "defaultModif");		
    		return Boolean.FALSE;
        }
	    else{
	        Hashtable tmp=new Hashtable();
	        tmp.put("id",new Integer(id_element_copy));
	        tmp.put("title",title_element_copy);
	        tmp.put("type",type_element_copy);
	        id_elements_copy.remove(tmp);
	        
	        DataControler cd=new DataControler();
	        try {
	            root=cd.RecupererArbrePerso(login);
	            xmlroot=root.toXMLComplet();
	        } catch (DataException e) {
	            log.error( "CSignet2 - Principal::initSupColler() : Erreur d'acc\u00E8s \u00E0 la page "+e.getMessage());
	    		Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "default");		
	    		return Boolean.FALSE;
	        }
	        
	    }
				
		return Boolean.TRUE;
	}
	
	/**
	 * Cre le XML correspondant
	 * @return Boolean.TRUE
	 */
	public Boolean setXML() {

		log.info("CSignet2 - Principal::setXML()");
		StringBuffer xml = new StringBuffer();
		Hashtable tmp= (Hashtable)root.toXMLString(id_folder_courant,0);
		xml=paramXML(xml);
		
		xml.append("<path>" );
		xml.append((StringBuffer)tmp.get("pile"));
		xml.append("</path>");
		
		xml.append((StringBuffer)tmp.get("xml"));
		
		this.xml = xml.toString();
		return Boolean.TRUE;
	}
}
