/*
 * Cree le 1 sept. 2004
 *
 * par cbissler
 * Centre de Ressources Informatiques 
 * Universit Henry Poincar 
 */
package org.esupportail.portal.channels.CSignet2.data;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CIntranet.utils.XMLUtils;
import org.esupportail.portal.channels.CSignet2.beans.BookMark;
import org.esupportail.portal.utils.database.Query;
import org.jasig.portal.RDBMServices;

/**
 * DataBookMark <br>
 * <br>
 * Recherche des donnes concernant les signets 
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:celine.bissler@uhp-nancy.fr">Cline Bissler</a>
 * @version 1.1 
 */
public class DataBookMark {
    protected static final Log log = LogFactory.getLog(DataControler.class);
    
    /**
     * Rcupration de la liste des bookmarks d'un repertoire parent
     * @param id Identifiant du rpertoire parent
     * @param query
     * @return Liste des BookMarks
     */    
    public Collection getBookMarks(int id, Query query)
    {
        BookMark b=null;
        String sql = "SELECT * FROM SIG_BOOKMARK WHERE ID_BM_PARENT = " + id + " AND TYPE_BM='book'";
        Collection c = new Vector();
        try {
            query.setSql(sql);
            query.select();
            ResultSet result = query.getRs();
            if (!result.next()) {
                log.info("CSignet2 - DataBookMark::getBookMark() : Le repertoire "+id+" est vide en bookMark ! ");
            } 
            else {
                do
                {
                    b=chargerBookMark(result);
                    c.add(b);
                }
                while (result.next());
            }
            
        } catch (SQLException e) {
            log.debug("CSignet2 - DataBookMark::getBookMark() Erreur SQL : " + e.getMessage());
            log.debug(
                    "CSignet2 - DataBookMark::getBookMark() Dans la requete : " + sql);
        }
        
        return c;
        
    }
    /**
     * Chargement d'un objet bookmark  partir 
     * du rsultat de la requete sur les bookmark
     * @param result
     * @return Le bean BookMark correspondant
     */
    private BookMark chargerBookMark(ResultSet result) {
        BookMark bres=null;
        try {
             bres=new BookMark();
             bres.setUrl(XMLUtils.xmlEscape(result.getString("URL_SIG")));
             if (result.getString("ID_GROUP_BM") == null)
                 bres.setB_modif(true);
             else
                 bres.setB_modif(false);
             if (result.getInt("BOOL_ROOT_F") == 1)
                 bres.setB_root(true);
             else
                 bres.setB_root(false);
            
             bres.setId(result.getInt("ID_BM"));
             bres.setParent(result.getInt("ID_BM_PARENT"));
             bres.setLogin(result.getString("LOGIN_BM"));
             bres.setId_group(result.getString("ID_GROUP_BM"));
             bres.setOrder(result.getInt("ORDRE_BM"));
             bres.setTitle(XMLUtils.xmlEscape(result.getString("LIB_BM")));
             bres.setDescription(XMLUtils.xmlEscape(result.getString("DESC_BM")));
            
         } catch (SQLException e) {
             log.debug("CSignet2 - DataBookMark::chargerBookMark() -> SQL : Erreur dans le chargement de l'objet BookMark "
                                     + e.getMessage());
         }
         return bres;
     }
   
    /**
     * Rcupre un bookmark
     * @param query
     * @param id Identifiant du BookMark
     * @return Le bean BookMark correspondant
     * @throws DataException
     */
    public BookMark getBookMark(Query query,int id)throws DataException{
        BookMark b=null;
        String sql = "SELECT * FROM SIG_BOOKMARK WHERE ID_BM = " + id ;
        
        try {
            query.setSql(sql);
            query.select();
            ResultSet result = query.getRs();
            if (!result.next()) {
                log.info("CSignet2 - DataBookMark::getBookMark() : Le bookmark "+id+" n'existe pas ");
                throw new DataException(
                        "Le bookmark "+id+" n'existe pas " );
            } 
            else if (1!=1)//result.getFetchSize()
            {
                log.info("CSignet2 - DataFolder::getBookMark() : Il y a plusieurs bookmark d'id : "+id+"!!! ");
                throw new DataException(
                        "Il y a plusieurs bookmark d'id : "+id+"!!! " );
            } 
            else {
                    b=chargerBookMark(result);           
            }
            
        } catch (SQLException e) {
            log.debug(
                    "CSignet2 - DataBookMark::getBookMark() Erreur SQL : " + e.getMessage());
            log.debug(
                    "CSignet2 - DataBookMark::getBookMark() Dans la requete : " + sql);
        }
        
        return b;
        
    }
    /**
     * Cration d'un nouveau BookMark
     * @param query
     * @param bm Le bean BookMark  crer
     * @throws DataException
     */
    public void createBookMark(Query query,BookMark bm)throws DataException{
        log.info( "CSignet2 - DataBookMark::CreateBookMark()");
        Vector message_err=new Vector();
        boolean b_err=false;
        /*TEST crash*/
       /* if (bm.getTitle().equals("Google"))
            throw new DataException("Test de commit et rollback OK pas le droit c google!");
		*/
        if (bm.getTitle().equals("")){
            b_err=true;
            message_err.add("le titre");
        }
        if (bm.getUrl().equals("")){
            b_err=true;
            message_err.add("l'URL");
        }
        if (b_err)
        {
            Iterator i=message_err.iterator();
            String s="";
            while (i.hasNext())
                s+=(String)i.next()+", ";
            s=s.substring(0,s.length()-2);
            throw new DataException("Veuillez saisir "+s+".");
        }
            
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO SIG_BOOKMARK (ID_BM, LOGIN_BM, ID_GROUP_BM, LIB_BM, ID_BM_PARENT, ORDRE_BM, URL_SIG, DESC_BM, BOOL_ROOT_F , TYPE_BM) VALUES(");
        sql.append("" + bm.getId() + ", ");
        sql.append("'" +bm.getLogin() + "', ");
        sql.append("'" +bm.getId_group() + "', ");
        sql.append("'" + RDBMServices.sqlEscape(bm.getTitle()) + "', ");
        sql.append("" + bm.getParent() +", ");
        sql.append("" + bm.getOrder() +", ");
        sql.append("'" + RDBMServices.sqlEscape(makeUrlSafe(bm.getUrl())) + "', ");
        sql.append("'" + RDBMServices.sqlEscape(bm.getDescription()) + "', ");
        sql.append("0,");
        sql.append("'book' )");
       

        try {
            query.setSql(sql.toString());
            query.insert();
            query.setSql("UPDATE SIG_LAST_INDEX SET IDENT="+ bm.getId() +" WHERE TABLE_ID='SIG_BOOKMARK'");
            query.update();
        }
        catch(SQLException e) {
            log.debug( "CSignet2 - DataBookMark::CreateBookMark() Erreur SQL: " + e);
            log.debug( "CSignet2 - DataBookMark::CreateBookMark() Dans la requete : " + sql);
            throw new DataException("Erreur lors de la cr\u00E9ation du Signet");
        }  
        
    }
    /**
     * Modification d'un BookMark
     * @param query
     * @param bm Le bean BookMark  modifier
     * @throws DataException
     */
    public void modifyBookMark(Query query,BookMark bm)throws DataException{
       log.info( "CSignet2 - DataBookMark::modifyBookMark()");
        Vector message_err=new Vector();
        boolean b_err=false;
       /* if (bm.getId()==16)
            throw new DataException("Test de commit et rollback OK crack bm!");
		*/
        if (bm.getTitle().equals("")){
            b_err=true;
            message_err.add("le titre");
        }
        if (bm.getUrl().equals("")){
            b_err=true;
            message_err.add("l'URL");
        }
        if (b_err)
        {
            Iterator i=message_err.iterator();
            String s="";
            while (i.hasNext())
                s+=(String)i.next()+", ";
            s=s.substring(0,s.length()-2);
            throw new DataException("Veuillez saisir "+s+".");
        }
        
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE SIG_BOOKMARK SET ");
        sql.append("LOGIN_BM ='" +bm.getLogin() + "', ");
        sql.append("ID_GROUP_BM='"+bm.getId_group()+"', ");
        sql.append("LIB_BM='" + RDBMServices.sqlEscape(bm.getTitle()) + "', ");
        sql.append("ID_BM_PARENT=" + bm.getParent() +", ");
        sql.append("ORDRE_BM=" + bm.getOrder() +", ");
        sql.append("URL_SIG='"+RDBMServices.sqlEscape(makeUrlSafe(bm.getUrl()))+"', ");
        sql.append("DESC_BM='" + RDBMServices.sqlEscape(bm.getDescription()) + "', ");
        sql.append("BOOL_ROOT_F=0,");
        sql.append("TYPE_BM='book' ");
        sql.append("WHERE ID_BM="+ bm.getId());
        try {
            query.setSql(sql.toString());
            query.update();
        }
        catch(SQLException e) {
            log.debug( "CSignet2 - DataBookMark::modifyBookMark()Erreur SQL : " + e);
            log.debug( "CSignet2 - DataBookMark::modifyBookMark()Dans la requete : " + sql);
            throw new DataException("Erreur lors de la modification du Signet");
        }          
    }
    /**
     * Suppression d'un BookMark
     * @param query
     * @param id Identifiant du bookmark  supprimer
     * @throws DataException
     */
    public void deleteBookMark(Query query,int id)throws DataException{
        log.info( "CSignet2 - DataBookMark::deleteBookMark()");
        String sql = "DELETE FROM SIG_BOOKMARK WHERE ID_BM = '" + id + "'";
		/*TEST crash*/
       /* if (id==16)
            throw new DataException("Test de commit et rollback OK crack bm!");
		*/
		try {
			query.setSql(sql);
			query.delete();
		}
		catch(SQLException e) {
		    log.debug( "CSignet2 - DataBookMark::deleteBookMark() Erreur SQL : " + e);
		    log.debug( "CSignet2 - DataBookMark::deleteBookMark() Dans la requete : " + sql);
			throw new DataException("Erreur lors de la suppression du signet");
		}
    }
    /**
     * Vrifie la validit de l'URL
     * @param url L'URL saisie
     * @return L'url valide
     */
    private static String makeUrlSafe (String url) {
		// Return if the url is correctly formed
		if (url.toLowerCase().startsWith("http://")) {
			return  (url);
		}
		// Make sure the URL is well formed
		if (url.toLowerCase().startsWith("http:/")) {
			url = url.substring(0, 6) + "/" + url.substring(7);
			return  (url);
		}
		// If it's a mail link then be sure mailto: is on the front
		if (url.indexOf('@') != -1) {
			if (!url.toLowerCase().startsWith("mailto:")) {
				url = "mailto:" + url;
			}
			return  (url);
		}
		// Make sure http:// is on the front
		url = "http://" + url;
		return  (url);
	}
    
    
}