/*
 * Cree le 24 sept. 2004
 *
 * par cbissler
 * Centre de Ressources Informatiques 
 * Universit Henri Poincar 
 */
package org.esupportail.portal.channels.CSignet2.data;


import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.*;

import org.esupportail.portal.channels.CIntranet.utils.XMLUtils;
import org.esupportail.portal.channels.CSignet2.beans.*;

import org.esupportail.portal.utils.database.Query;

import org.jasig.portal.RDBMServices;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
/**
 * DataFolder<br>
 * <br>
 * Recherche des donnes concernant les dossiers 
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:celine.bissler@uhp-nancy.fr">Cline Bissler</a>
 * @version 1.1 
 */
public class DataFolder {
    protected static final Log log = LogFactory.getLog(DataControler.class);
    
    /**
     * Rcuperation du root d'un utilisateur
     * @param login Login de l'utilisateur
     * @param query
     * @return Le bean Folder racine correspondant
     * @throws DataException
     */
    public Folder getRoot (String login,Query query)throws DataException, NoRootException 
    {
        Folder f=null;
        String sql = "SELECT * FROM SIG_BOOKMARK WHERE LOGIN_BM = '" + login
        + "' and BOOL_ROOT_F=1";
        
        try {
            query.setSql(sql);
            query.select();
            ResultSet result = query.getRs();
            if (!result.next()) {
                log.debug("CSignet2 - DataFolder::getRoot() : L'utilisateur "+login+" n'a pas de root ");
                throw new NoRootException();
            } 
            else if (1!=1)//result.getFetchSize()
            {
                log.debug("CSignet2 - DataFolder::getRoot() : L'utilisateur "+login+" a plusieurs repertoires root !!! ");
                throw new DataException(
                        "L'utilisateur "+login+" a plusieurs repertoires root !!!" );
            } 
            else {
                    f=chargerFolder(result);   
            }
            
        } catch (SQLException e) {
            log.debug(
                    "CSignet2 - DataFolder::getRoot() Erreur SQL : " + e.getMessage());
            log.debug(
                    "CSignet2 - DataFolder::getRoot() Dans la requete : " + sql);
        }
        
        return f;
    }
    
    /**
     * Rcupration de la liste des sous rpertoires d'un repertoire parent
     * @param id Identifiant du rpertoire parent
     * @param query
     * @return La liste des sous rpertoires
     */
    public Collection getFolders(int id, Query query)
    {
        Folder f=null;
        String sql = "SELECT * FROM SIG_BOOKMARK WHERE ID_BM_PARENT = " + id + " AND TYPE_BM='folder'";
        Collection c = new Vector();
        try {
            query.setSql(sql);
            query.select();
            ResultSet result = query.getRs();
            if (!result.next()) {
                log.debug("CSignet2 - DataFolder::getFolder() : Le repertoire "+id+" est vide en folder ! ");
            } 
            else {
                do
                {
                    f=chargerFolder(result);
                    c.add(f);
                }
                while (result.next());
            }
            
        } catch (SQLException e) {
            log.debug(
                    "CSignet2 - DataFolder::getFolder() Erreur SQL : " + e.getMessage());
            log.debug(
                    "CSignet2 - DataFolder::getFolder() Dans la requete : " + sql);
        }
        
        return c;
        
    }
    /**
     * Chargement d'un objet Folder  partir 
     * du rsultat de la requete sur les folder
     * @param result Le rsultat d'une requte
     * @return Le bean Folder correspondant
     */
    private Folder chargerFolder(ResultSet result) {
        Folder fres=null;
        try {
             fres=new Folder();
            
             if (result.getString("ID_GROUP_BM") == null)
                 fres.setB_modif(true);
             else
                 fres.setB_modif(false);
             if (result.getInt("BOOL_ROOT_F") == 1)
                 fres.setB_root(true);
             else
             {
                 fres.setB_root(false);
                 fres.setParent(result.getInt("ID_BM_PARENT"));
             }
            
             fres.setId(result.getInt("ID_BM"));
             
             fres.setLogin(result.getString("LOGIN_BM"));
             fres.setId_group(result.getString("ID_GROUP_BM"));
             fres.setOrder(result.getInt("ORDRE_BM"));
             fres.setTitle(XMLUtils.xmlEscape(result.getString("LIB_BM")));
             fres.setDescription(XMLUtils.xmlEscape(result.getString("DESC_BM")));
            
         } catch (SQLException e) {
             log.debug("CSignet2 - DataFolder::chargerFolder() -> SQL : Erreur dans le chargement de l'objet folder "
                                     + e.getMessage());
         }
         return fres;
     }
    /**
     * Rcupere le dossier
     * @param query
     * @param id Indetifiant du dossier
     * @return Le bean Folder correspondant
     * @throws DataException
     */
    public Folder getFolder(Query query,int id)throws DataException{
        Folder f=null;
        String sql = "SELECT * FROM SIG_BOOKMARK WHERE ID_BM = " + id ;
        
        try {
            query.setSql(sql);
            query.select();
            ResultSet result = query.getRs();
            if (!result.next()) {
                log.debug("CSignet2 - DataFolder::getFolder() : Le Folder "+id+" n'existe pas ");
                throw new DataException(
                        "Le bookmark "+id+" n'existe pas " );
            } 
            else if (1!=1)//result.getFetchSize()
            {
                log.debug("CSignet2 - DataFolder::getFolder) : Il y a plusieurs Folder d'id : "+id+"!!! ");
                throw new DataException(
                        "Il y a plusieurs Folder d'id : "+id+"!!! " );
            } 
            else {
        
                    f=chargerFolder(result);    
                
            }
            
        } catch (SQLException e) {
            log.debug(
                    "CSignet2 - DataBookMark::getFolder() Erreur SQL : " + e.getMessage());
            log.debug(
                    "CSignet2 - DataBookMark::getFolder() Dans la requete : " + sql);
        }
        
        return f;
        
    }
    /**
     * Cration d'un dossier
     * @param query
     * @param f Le bean Folder  crer
     * @throws DataException
     */
    public void CreateFolder(Query query,Folder f)throws DataException{
        log.info("CSignet2 - DataFolder::CreateFolder()");
        Vector message_err=new Vector();
        boolean b_err=false;
     
        if (f.getTitle().equals("")){
            b_err=true;
            message_err.add("le titre");
        }
        if (b_err)
        {
            Iterator i=message_err.iterator();
            String s="";
            while (i.hasNext())
                s+=(String)i.next()+", ";
            s=s.substring(0,s.length()-2);
            throw new DataException("Veuillez saisir "+s+".");
        }
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO SIG_BOOKMARK (ID_BM, LOGIN_BM, ID_GROUP_BM, LIB_BM, ID_BM_PARENT, ORDRE_BM, URL_SIG, DESC_BM, BOOL_ROOT_F , TYPE_BM) VALUES(");
        sql.append("" + f.getId() + ", ");
        sql.append("'" +f.getLogin() + "', ");
        sql.append("'" +f.getId_group() + "', ");
        sql.append("'" + RDBMServices.sqlEscape(f.getTitle()) + "', ");
        sql.append("" + f.getParent() +", ");
        sql.append("" + f.getOrder() +", ");
        sql.append("'aucun', ");
        sql.append("'" + RDBMServices.sqlEscape(f.getDescription()) + "', ");
        if(f.isB_root())
            sql.append("1,");
        else
            sql.append("0,");
        sql.append("'folder' )");
       
        try {
            query.setSql(sql.toString());
            query.insert();
            query.setSql("UPDATE SIG_LAST_INDEX SET IDENT="+ f.getId() +" WHERE TABLE_ID='SIG_BOOKMARK'");
            query.update();
        }
        catch(SQLException e) {
            log.debug( "CSignet2 - DataFolder::CreateFolder() Erreur SQL: " + e);
            log.debug( "CSignet2 - DataFolder::CreateFolder() Dans la requete : " + sql);
            throw new DataException("Erreur lors de la cr\u00E9ation du Dossier");
        }          
    }
    /**
     * Modification d'un dossier
     * @param query
     * @param f Le bean Folder  modifier
     * @throws DataException
     */
    public void modifyFolder(Query query,Folder f)throws DataException{
        log.info("CSignet2 - DataFolder::modifyFolder()");
        Vector message_err=new Vector();
        boolean b_err=false;
     
        if (f.getTitle().equals("")){
            b_err=true;
            message_err.add("le titre");
        }
        if (b_err)
        {
            Iterator i=message_err.iterator();
            String s="";
            while (i.hasNext())
                s+=(String)i.next()+", ";
            s=s.substring(0,s.length()-2);
            throw new DataException("Veuillez saisir "+s+".");
        }
        
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE SIG_BOOKMARK SET ");
        sql.append("LOGIN_BM ='" +f.getLogin() + "', ");
        sql.append("ID_GROUP_BM='"+f.getId_group()+"', ");
        sql.append("LIB_BM='" + RDBMServices.sqlEscape(f.getTitle()) + "', ");
        sql.append("ID_BM_PARENT=" + f.getParent() +", ");
        sql.append("ORDRE_BM=" + f.getOrder() +", ");
        sql.append("URL_SIG='aucun', ");
        sql.append("DESC_BM='" + RDBMServices.sqlEscape(f.getDescription()) + "', ");
        if(f.isB_root())
            sql.append("BOOL_ROOT_F=1,");
        else
            sql.append("BOOL_ROOT_F=0,");
        
        sql.append("TYPE_BM='folder' ");
        sql.append("WHERE ID_BM="+ f.getId());
        try { 
            log.debug( "CSignet2 - DataFolder::modifyFolder() modification base"+f.toXMLComplet());
            query.setSql(sql.toString());
            query.update();
        }
        catch(SQLException e) {
            log.debug( "CSignet2 - DataFolder::modifyFolder() Erreur SQL: " + e);
            log.debug( "CSignet2 - DataFolder::modifyFolder() Dans la requete : " + sql);
            throw new DataException("Erreur lors de la modification du Dossier");
        }          
    }
    /**
     * Suppression d'un dossier
     * @param query
     * @param id Identifiant du dossier  supprimer
     * @throws DataException
     */
    public void deleteFolder(Query query,int id)throws DataException{
        log.info("CSignet2 - DataFolder::deleteFolder()");
        String sql = "DELETE FROM SIG_BOOKMARK WHERE ID_BM = '" + id + "'";
		
		try {
			query.setSql(sql);
			query.delete();
		}
		catch(SQLException e) {
		    log.debug("CSignet2 - DataFolder::deleteFolder() Erreur SQL : " + e);
		    log.debug("CSignet2 - DataFolder::deleteFolder() Dans la requete : " + sql);
			throw new DataException("Erreur lors de la suppression du dossier");
		}
    }
}
