/*
 * Cree le 15 oct. 2004
 *
 * par cbissler
 * Centre de Ressources Informatiques 
 * Universit Henri Poincar 
 */
package org.esupportail.portal.channels.CSignet2.data;

import java.sql.ResultSet;
import java.sql.SQLException;

import java.util.Hashtable;

import org.esupportail.portal.utils.database.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * DataGeneral<br>
 * <br>
 * Recherche des donnes gnrale pour le canal des signets
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:celine.bissler@uhp-nancy.fr">Cline Bissler</a>
 * @version 1.1 
 */
public class DataGeneral {
    protected static final Log log = LogFactory.getLog(DataControler.class);
    
    /**
     * Recherche la cl de la prochaine entre 
     * dans la table des bookmark 
     * @param query
     * @return La cl de la prochaine entre
     */
    public int getLastId(Query query){
        log.info("CSignet2 - DataGeneral::getLastId()");
        int id=0;
        int tmp=0;
        String sql = "SELECT IDENT FROM SIG_LAST_INDEX WHERE TABLE_ID=\"SIG_BOOKMARK\"";      
        try {
            query.setSql(sql);
            query.select();
            ResultSet result = query.getRs();
            if (!result.next()) {
                log.debug("CSignet2 - DataGeneral::getLastId() : Il n'y a pas d'indentifiant pour cette table ! ");
            } 
            else
                id= result.getInt("IDENT");        
        } catch (SQLException e) {
            log.debug(
                    "CSignet2 - DataGeneral::getLastId() Erreur SQL : " + e.getMessage());
            log.debug(
                    "CSignet2 - DataGeneral::getLastId() Dans la requete : " + sql);
        }
        // la place suivante
        id=id+1;
        
        log.info("CSignet2 - DataGeneral::getLastId() : On inserera en cle : "+ id);
        return id;   
    }
    /**
     * Recherche l'ordre de la prochaine entre 
     * insre dans le rpertoire
     * @param query
     * @param id Identifiant de l'lment parent 
     * @return L'ordre de la prochaine entre
     */
    public int getLastOrder(Query query,int id)throws DataException{
        log.info("CSignet2 - DataGeneral::getLastOrder()");
        int order=0;
        int tmp=0;
        String sql = "SELECT ORDRE_BM FROM SIG_BOOKMARK WHERE ID_BM_PARENT = " + id;
      
        try {
            query.setSql(sql);
            query.select();
            ResultSet result = query.getRs();
            if (!result.next()) {
                log.debug("CSignet2 - DataGeneral::getLastOrder() : Il n'y a pas encore de bookMark ! ");
            } 
            else {
                do
                {
                   tmp= result.getInt("ORDRE_BM");
                   if (tmp>order)
                       order=tmp;
                }
                while (result.next());
            }
            
        } catch (SQLException e) {
            log.debug(
                    "CSignet2 - DataGeneral::getLastOrder() Erreur SQL : " + e.getMessage());
            log.debug(
                    "CSignet2 - DataGeneral::getLastOrder() Dans la requete : " + sql);
        }
        // la place suivante
        order=order+1;
        
        log.info("CSignet2 - DataGeneral::getLastOrder() : On inserera en ordre : "+ order);
        return order;   
    }
  /**
   * Permet de modifier l'ordre d'un lment dcalage des autres lments
   * @param query
   * @param id Identifiant de l'lment
   * @param ordre Le nouvel ordre de l'lment
   * @throws DataException
   */
    public void modifierOrdre (Query query,int id,int ordre)throws DataException{
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE SIG_BOOKMARK SET ");
        sql.append("ORDRE_BM=" + ordre+" ");
        sql.append("WHERE ID_BM="+ id);
        try {
            query.setSql(sql.toString());
            query.update();
        }
        catch(SQLException e) {
            log.debug( "CSignet2 - DataGeneral::modifierOrdre()Erreur SQL : " + e);
            log.debug( "CSignet2 - DataGeneral::modifierOrdre()Dans la requete : " + sql);
            throw new DataException("Erreur lors de la modification de l'ordre");
        }               
    }
    /**
     * Modifier le parent d'un lment et remettre / dcaller l'ordre des autres lments
     * @param query
     * @param id Identifiant de l'lment
     * @param parent Identifiant du parent de l'lment
     * @param ordre Ancien ordre de l'lment
     * @throws DataException
     */
    public void modifierParent (Query query,int id,int parent,int ordre)throws DataException{
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE SIG_BOOKMARK SET ");
        sql.append("ID_BM_PARENT=" + parent+", ");
        sql.append("ORDRE_BM=" + ordre+" ");
        sql.append("WHERE ID_BM="+ id);
        try {
            query.setSql(sql.toString());
            query.update();
        }
        catch(SQLException e) {
            log.debug( "CSignet2 - DataGeneral::modifierParent()Erreur SQL : " + e);
            log.debug( "CSignet2 - DataGeneral::modifyParent()Dans la requete : " + sql);
            throw new DataException("Erreur lors de la modification de parent");
        }               
    }
    /**
     * Rcupre l'ordre, le parent et le titre d'un lment
     * @param query
     * @param id Identifiant de l'lment
     * @return Hashtable contenant les cls ordre, parent, title
     * @throws DataException
     */
    public Hashtable getOrdreParent(Query query,int id)throws DataException{
        log.info("CSignet2 - DataGeneral::getOrdreParent()");
        int order=0;
        int parent=0;
        String title=null;
        String type=null;
        Hashtable t=new Hashtable();
        String sql = "SELECT ORDRE_BM, ID_BM_PARENT, LIB_BM,TYPE_BM FROM SIG_BOOKMARK WHERE ID_BM = " + id;
      
        try {
            query.setSql(sql);
            query.select();
            ResultSet result = query.getRs();
            if (!result.next()) {
                log.debug("CSignet2 - DataGeneral::getOrdreParent() : Il n'y a pas encore de bookMark ! ");
            } 
            else {
                   order= result.getInt("ORDRE_BM");
                   parent=result.getInt("ID_BM_PARENT");
                   title=result.getString("LIB_BM");
                   type=result.getString("TYPE_BM");
            }
            
        } catch (SQLException e) {
            log.debug(
                    "CSignet2 - DataGeneral::getOrdreParent() Erreur SQL : " + e.getMessage());
            log.debug(
                    "CSignet2 - DataGeneral::getOrdreParent() Dans la requete : " + sql);
        }
        
        t.put("ordre",new Integer(order));
        t.put("parent",new Integer(parent));
        t.put("title",title);
        t.put("type",type);
        log.debug("CSignet2 - DataGeneral::getOrdreParent() : On a l'ordre : "+ order+" parent "+parent);
        return(t);   
    }
    /**
     * Rpupre les lments situs aprs un lment dans l'ordre
     * @param query
     * @param parent Identifiant de l'lment parent 
     * @param ordreMin ordre  partir duquel on rcupre les lments
     * @param idOter L'lement concern  ne pas prendre en compte
     * @return Hashtable ayant pour cl les identifiant des lments, et pour valeur leur ordre
     * @throws DataException
     */
    public Hashtable getElementsApres(Query query,int parent,int ordreMin,int idOter)throws DataException{
        log.info("CSignet2 - DataGeneral::getElementApres()");
        int order;
        int id;
        Hashtable t=new Hashtable();
        String sql = "SELECT ORDRE_BM, ID_BM FROM SIG_BOOKMARK WHERE ORDRE_BM >="+ordreMin+" AND ID_BM != "+ idOter +" AND ID_BM_PARENT = " + parent;
      
        try {
            query.setSql(sql);
            query.select();
            ResultSet result = query.getRs();
            if (!result.next()) {
                log.debug("CSignet2 - DataGeneral::ElementApres() : Il n'y a pas encore de bookMark ! ");
            } 
            else {
                do{
                   order= result.getInt("ORDRE_BM");
                   id=result.getInt("ID_BM");
                   t.put(new Integer(id),new Integer(order));
                }while(result.next());
            }
            
        } catch (SQLException e) {
            log.debug(
                    "CSignet2 - DataGeneral::getElementApres() Erreur SQL : " + e.getMessage());
            log.debug(
                    "CSignet2 - DataGeneral::getElementApres() Dans la requete : " + sql);
        }
        return(t);   
    }
    /**
     * Rcupre l'identifiant de l'lment  partir de son ordre et de son parent
     * @param query
     * @param parent Identifiant de l'lment parent
     * @param ordre L'ordre de l'lment
     * @return l'identifiant de l'lment
     * @throws DataException
     */
    public int getElementApres(Query query,int parent,int ordre)throws DataException{
        log.info("CSignet2 - DataGeneral::getElementApres()");
        
        int id=0;
       
        String sql = "SELECT ORDRE_BM, ID_BM FROM SIG_BOOKMARK WHERE ORDRE_BM ="+ordre+" AND ID_BM_PARENT = " + parent;
      
        try {
            query.setSql(sql);
            query.select();
            ResultSet result = query.getRs();
            if (!result.next()) {
                log.debug("CSignet2 - DataGeneral::ElementApres() : Il n'y a pas encore de bookMark ! ");
            } 
            else {
                do{
                   id=result.getInt("ID_BM");
                }while(result.next());
            }
            
        } catch (SQLException e) {
            log.debug(
                    "CSignet2 - DataGeneral::getElementApres() Erreur SQL : " + e.getMessage());
            log.debug(
                    "CSignet2 - DataGeneral::getElementApres() Dans la requete : " + sql);
        }
        return(id);   
    }
}
