
/*
 * Cree le 26 oct. 2004
 *
 * TODO 
 * par cbissler
 * Centre de Ressources Informatiques 
 * Universit Henri Poincar 
 */
package org.esupportail.portal.channels.CSignet2.interpreter;


import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;


import org.esupportail.portal.channels.CSignet2.beans.BookMark;
import org.esupportail.portal.channels.CSignet2.beans.Folder;
import org.esupportail.portal.channels.CSignet2.data.DataControler;
import org.esupportail.portal.channels.CSignet2.utils.CaracteresSpeciaux;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.xml.sax.SAXException;
import org.apache.commons.digester.*;
/**
 * XBELInterpreter<br>
 * <br>
 * Classe charge de l'interpretation XBEL
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:celine.bissler@uhp-nancy.fr">Cline Bissler</a>
 * @version 1.1 
 */
public class XBELInterpreter implements Interpreter {
    protected static final Log log = LogFactory.getLog(DataControler.class);
    
    Digester digester=null;
    
    String login=null;
    private CaracteresSpeciaux carac;
    /**
     * Constructeur
     * @param input Le flux XML
     * @param login Le login de l'utilisateur
     */
    public XBELInterpreter(String login) {
        this.login=login;
        carac=new CaracteresSpeciaux();
        digester = new Digester();
        
        digester.setValidating(true);
       
        digester.addObjectCreate("*/folder", "org.esupportail.portal.channels.CSignet2.beans.Folder");
        digester.addBeanPropertySetter("*/folder/title","title");
        digester.addSetNext("*/folder", "addSubFolder");
        
        digester.addObjectCreate("*/bookmark", "org.esupportail.portal.channels.CSignet2.beans.BookMark");
        digester.addSetProperties("*/bookmark","href","url");
        digester.addBeanPropertySetter("*/bookmark/title","title");
        digester.addSetNext("*/bookmark", "addBookMark");
     }
   
    /**
     * Interprete le document xml et retourne l'arborescence : 
     * le Folder root 
     * @return Le Folder root de l'arborescence  ajouter
     */
    public Folder interpreter(InputStream input) throws MalFormeException,IOException,SAXException{
        Folder root= new Folder();
        root.setTitle("Chargement XBEL");
        Calendar d=Calendar.getInstance();
        root.setDescription("Chargement XBEL le : "+d.get(Calendar.DAY_OF_MONTH)+" - "+d.get(Calendar.MONTH)+" - "+d.get(Calendar.YEAR));
       
        log.debug("RECUP 1"+root.toXMLComplet());
        digester.push(root);
        log.debug("RECUP 2"+root.toXMLComplet());
        digester.parse(input);
        log.debug("RECUP 3"+root.toXMLComplet());
        interpreterFolder(root,0);
        log.debug("RECUP 4"+root.toXMLComplet());
        return root;
    }
    /**
     * Interprte un rpertoire 
     * @param el Element XML
     * @param ordre Ordre dans lequel il est trouv de dans lequel il apparatra dans l'arborescence
     * @return Le Folder correspondant
     */
    private void interpreterFolder(Folder el,int ordre) throws MalFormeException{
        log.debug("RECUP Interpreter Folder");
        Collection les_book=el.getBookMarks();
        Collection les_fold=el.getSubFolders();
        
        el.setB_modif(true);
        el.setLogin(login);
        el.setId_group("aucun");
        el.setB_root(false);
        el.setOrder(ordre);
        Date d=new Date();
    //    el.setDescription("Chargement XBEL le : "+d.toString());
        if ((el.getTitle()==null)||(el.getTitle().compareTo("")==0))
            throw new MalFormeException("Il n'y pas de titre de dossier ");
  
        Iterator i = les_fold.iterator();
        int o=1;
        boolean b_title=false;
        while (i.hasNext()){
            Folder e=(Folder)i.next();
            interpreterFolder(e,o);
            o++;      
        }  
        Iterator i2 = les_book.iterator();
        o=1;
      
        while (i2.hasNext()){
            BookMark e=(BookMark)i2.next();
            interpreterBookmark(e,o);
            o++;      
        }
        el.setTitle(carac.convertirAccentue(el.getTitle()));
        el.setTitle(carac.convertirCaracXML(el.getTitle()));
    }
    /**
     * Interprte un bookmark
     * @param el Element XML
     * @param ordre Ordre dans lequel il est trouv de dans lequel il apparatra dans l'arborescence
     * @return Le BookMark correspondant
     */
    private void interpreterBookmark(BookMark el,int ordre)throws MalFormeException{
        log.debug("RECUP Interpreter Book");
        el.setB_modif(true);
        el.setLogin(login);
        el.setId_group("aucun");
        el.setB_root(false);
        el.setOrder(ordre);
        Date d=new Date();
      //  el.setDescription("Chargement XBEL le : "+d.toString());
        if ((el.getTitle()==null)||(el.getTitle().compareTo("")==0))
            throw new MalFormeException("Il n'y pas de titre au Signet ");
        if ((el.getUrl()==null)||(el.getUrl().compareTo("")==0))
            throw new MalFormeException("Il n'y pas d'URL au Signet ");
        el.setTitle(carac.convertirAccentue(el.getTitle()));
        el.setTitle(carac.convertirCaracXML(el.getTitle()));
        el.setUrl(carac.convertirCaracXMLURL(el.getUrl()));
               
    }

}
