/*
 * Cree le 5 oct. 2004
 *
 * par cbissler
 * Centre de Ressources Informatiques 
 * Universit Henri Poincar 
 */
package org.esupportail.portal.channels.CSignet2.actions;


import org.esupportail.portal.channels.CSignet2.beans.Folder;
import org.esupportail.portal.channels.CSignet2.data.DataControler;
import org.esupportail.portal.channels.CSignet2.data.DataException;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.plugins.Message;
import org.esupportail.portal.utils.channels.plugins.MessageBean;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;


/**
 * CreateFolder<br>
 * <br>
 * Action de cration d'un dossier
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:celine.bissler@uhp-nancy.fr">Cline Bissler</a>
 * @version 1.1 
 */
public class CreateFolder extends SignetAction {

    /**
     * Constructeur
     * @param mainchannel Channel principale
     */
	public CreateFolder(MainChannel mainchannel){
	    super(mainchannel);
	}
	/**
	 * Init par dfaut qui lance le formulaire de cration
	 */
	public Boolean init(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		log.info("CSignet2 - CreateFolder::init()");
		runtimeData = rd;
		paramAction();
		return Boolean.TRUE;
	}
	/**
	 * Init qui cre le dossier
	 * @param rd Le RuntimeData
	 * @return Boolean.TRUE si l'action s'est bien passe, Boolean.FALSE sinon
	 * @throws PortalException
	 * @throws FrameWorkException
	 */
	public Boolean newFolderInit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		log.info("CSignet2 - CreateFolder::newFolderInit()");
		runtimeData = rd;
		paramAction();
		
		// Rcupration bouton
		String button = runtimeData.getParameter("butcreer");
		
		// Clic sur le bouton Annuler
		if(button == null) {
		    retourAccueil(runtimeData);
			return Boolean.FALSE;
		}
		
		// Rcupration paramtres
		String description = runtimeData.getParameter("description");
		String titre = runtimeData.getParameter("titre");
		
		if(titre == null) {
			log.error("CSignet2 - CreateFolder::newFolderInit() : Erreur d'acc\u00E8s \u00E0 la page");
			Message.message(mainChannel, runtimeData, new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "defaultModif");		
			return Boolean.FALSE;
		}
		
		// Rcupration IDataReadManager
		DataControler data = new DataControler();
		Folder f= new Folder();
		
		f.setB_modif(true);
		f.setLogin(login);
		f.setId_group("aucun");
		f.setParent(id_folder_courant);
		f.setB_root(false);
		f.setDescription(description);
		f.setTitle(titre);
		
		try {
	        data.createFolder(f);
	    } catch (DataException e) {
	        log.error("CSignet2 - createBookMark::newFolderInit()erreur de creation du folder");
	        Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "CreateFolder");
	        return Boolean.FALSE;
	    }
	    
	    retourAccueil(runtimeData);
		return Boolean.FALSE;
	}
	/**
	 * Cre le XML correspondant
	 */
	public Boolean setXML() {
		log.info("CSignet2 - CreateFolder::setXML()");
		StringBuffer xml = new StringBuffer();
		xml=paramXML(xml);
		
		this.xml = xml.toString();
		
		return Boolean.TRUE;
	}

}
