<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:import href="./BookMarkTemplate.xsl" />
<xsl:output method="html" indent="no" />

<xsl:param name="baseActionURL"></xsl:param>
<xsl:param name="prefForm"></xsl:param>
<xsl:param name="mediaPath"></xsl:param>

<xsl:template match="xml">
	
<form enctype="multipart/form-data" method="post" action="{$baseActionURL}">
	<input type="hidden" name="action" value="delFolder" />
	<xsl:apply-templates select="id_folder_courant" />
	<table border="0" width="100%" cellspacing="0" cellpadding="10">
		<tr class="uportal-background-light">
			<td class="uportal-channel-table-header">Suppression de Dossier</td>
		</tr>
	</table>
		
	<table border="0">
		<tr>
			<td class="uportal-text"><xsl:call-template name="icon.alert" /></td>
			<td class="uportal-text">Etes-vous sur de vouloir supprimer 
				<xsl:value-of select="./folder/@titre"/>
				<xsl:if test="(./folder/@nb_book != 0) or (./folder/@nb_fold != 0)">
					ainsi que le(s) 
					<xsl:value-of select="./folder/@nb_book"/> signet(s) et le(s) 
					<xsl:value-of select="./folder/@nb_fold"/>	sous-dossier(s) qu'il contient	
				</xsl:if>
				?
				</td>
		</tr>
	</table>
		<br></br>
	<table border="0" cellpadding="0" cellspacing="1">
				<tr>
					<td colspan="2">
						Liste des Signets<br></br>
					</td>
				</tr>
				<xsl:apply-templates select="folder"/>
			
	</table>
	<br/>
	<input type="submit" class="uportal-button" value="Oui" name="butsupprimer" /><input type="submit" class="uportal-button" value="Non" name="butannul" />
</form>
			
</xsl:template>

<xsl:template match="id_folder_courant">
 <input type="hidden" name="id_folder_courant" value="{./@id}" />
</xsl:template>
<xsl:template match="folder">
	<xsl:apply-templates select="folder"/>
	<xsl:apply-templates select="bookmark"/>
</xsl:template>

<!--Affichage bookmark-->
<xsl:template match="bookmark">
	<tr>
		<td>
			-
		</td>
		<td>
		<table border="0" cellspacing="1"><tr><td>
			<xsl:value-of select="./title" />
		</td>
		<td>:</td>
		<td>
			<xsl:value-of select="./@href" />
		</td></tr>
		</table>
		</td>
	</tr>			
</xsl:template>

</xsl:stylesheet>