/*
 * Cree le 28 sept. 2004
 *
 * par cbissler
 * Centre de Ressources Informatiques 
 * Universit Henri Poincar 
 */
package org.esupportail.portal.channels.CSignet2.actions;

import org.esupportail.portal.channels.CSignet2.beans.BookMark;
import org.esupportail.portal.channels.CSignet2.beans.Folder;
import org.esupportail.portal.channels.CSignet2.data.DataControler;
import org.esupportail.portal.channels.CSignet2.data.DataException;
import org.esupportail.portal.channels.CSignet2.data.DataRetriever;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;

import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;

import org.esupportail.portal.utils.channels.plugins.Message;
import org.esupportail.portal.utils.channels.plugins.MessageBean;

/**
 * createBookMark<br>
 * <br>
 * Action de cration d'un bookmark
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:celine.bissler@uhp-nancy.fr">Cline Bissler</a>
 * @version 1.1 
 */
public class CreateBookMark extends SignetAction{
    /**
     * Constructeur
     * @param mainchannel Channel principale
     */
    public CreateBookMark(MainChannel mainchannel){
        super(mainchannel);
    }
    /**
     * Init par dfaut qui lance le formulaire de cration
     */
     public Boolean init(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		log.info("CSignet2 - createBookMark::init()");
		dcopy();
		
		runtimeData = rd;
		paramAction();
		dcopy();
		root=new Folder();
		DataControler cd=new DataControler();
        try {
            root=cd.RecupererArbrePerso(login);
            xmlroot=root.toXMLComplet();
        } catch (DataException e) {
            log.error("CSignet2 - Principal::init() : Erreur d'acc\u00E8s \u00E0 la page "+e.getMessage());
    		Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "default");		
    		return Boolean.FALSE;
        }
		return Boolean.TRUE;
	}
    /**
     * Init qui cre le bookmark
     * @param rd Le RuntimeData
     * @return Boolean.TRUE si l'action s'est bien passe, Boolean.FALSE sinon
     * @throws PortalException
     * @throws FrameWorkException
     */
    public Boolean newBookMarkInit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		log.info("CSignet2 - createBookMark::newBookMarkInit()");
		runtimeData = rd;
		dcopy();
		paramAction();
		dcopy();
		// Rcupration bouton
		String button = runtimeData.getParameter("butcreer");
		
		// Clic sur le bouton Annuler
		if(button == null) {
		  retourAccueil(runtimeData);
		  return Boolean.FALSE;
		}
	
		// Rcupration paramtres
		String description = runtimeData.getParameter("description");
		int id_parent=0;
		id_parent = Integer.parseInt(runtimeData.getParameter("id_parent"));
		String titre = runtimeData.getParameter("titre");
		String url = runtimeData.getParameter("url");
		
		if(titre == null) {
			log.error( "CSignet2 - createBookMark::newBookMarkInit() : Erreur d'acc\u00E8s \u00E0 la page");
			Message.message(mainChannel, runtimeData, new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "defaultModif");		
			return Boolean.FALSE;
		}
		if(id_parent == 0) {
			log.error( "CSignet2 - createBookMark::newBookMarkInit() : Erreur d'acc\u00E8s \u00E0 la page");
			Message.message(mainChannel, runtimeData, new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "defaultModif");		
			return Boolean.FALSE;
		}
		if(url == null) {
			log.error( "CSignet2 - createBookMark::newBookMarkInit() : Erreur d'acc\u00E8s \u00E0 la page");
			Message.message(mainChannel, runtimeData, new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "defaultModif");		
			return Boolean.FALSE;
		}
	
		DataControler data = new DataControler();
		BookMark bm= new BookMark();
		
		bm.setB_modif(true);
		bm.setLogin(login);
		bm.setId_group("aucun");
		bm.setParent(id_parent);
		bm.setB_root(false);
		bm.setDescription(description);
		bm.setTitle(titre);
		bm.setUrl(url);
		try {
            data.createBookMark(bm);
        } catch (DataException e) {
            log.error("CSignet2 - createBookMark::newBookMarkInit()erreur de creation de bookmark");
            Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "CreateBookMark");
            return Boolean.FALSE;
        }
        retourAccueil(runtimeData);
		return Boolean.FALSE;
	}
    
    /**
     * Cre le XML correspondant
     */
    public Boolean setXML() {
		log.info("CSignet2 - createBookMark::setXML()");
		StringBuffer xml = new StringBuffer();
		xml=paramXML(xml);
		
		this.xml = xml.toString();
		
		return Boolean.TRUE;
	}

}
