/*
 * Cree le 6 sept. 2004
 *
 * par cbissler
 * Centre de Ressources Informatiques 
 * Universit Henri Poincar 
 */
package org.esupportail.portal.channels.CSignet2.beans;


import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

import org.esupportail.portal.channels.CSignet2.utils.CaracteresSpeciaux;


 
/**
 * Folder<br>
 * <br>
 * Classe metier qui reprsente un rpertoire
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:celine.bissler@uhp-nancy.fr">Cline Bissler</a>
 * @version 1.1 
 */
public class Folder{
    private int id = 0;
    private String title = null;
    private String description = null;
    private int parent = 0;
    private Collection subFolders= null;
    private Collection bookMarks= null;
    private int order = 0;
    private String id_group=null;
    private String login=null;
    private boolean b_root = false; 
    private boolean b_modif = false;
    protected CaracteresSpeciaux carac=new CaracteresSpeciaux();
    
    /**
     * @return Retourne le bookMarks.
     */
    public Collection getBookMarks() {
        return bookMarks;
    }
  
    /**
     * Ajoute un bookmark
     * @param b Les BookMark  ajouter
     */
    public void addBookMark(BookMark b) {
       this.bookMarks.add(b);
    }
    
    /**
     * @param bookMarks Le bookMarks  positionner.
     */
    public void setBookMarks(Collection bookMarks) {
        this.bookMarks = bookMarks;
    }
    
    /**
     * @return Retourne le subFolders.
     */
    public Collection getSubFolders() {
        return subFolders;
    }
    /**
     * @param subFolders Le subFolders  positionner.
     */
    public void setSubFolders(Collection subFolders) {
        this.subFolders = subFolders;
    }
    /**
     * Ajoute un folder
     * @param f Le folder  ajouter
     */
    public void addSubFolder(Folder f){
        subFolders.add(f);
    }
   
    
    /**
     * Constructeur
     */
    public Folder() {
        
        subFolders = new Vector();
        bookMarks = new Vector();
    }
    
   
    /**
     * @return Retourne le description.
     */
    public String getDescription() {
        return description;
    }
    /**
     * @param description Le description  positionner.
     */
    public void setDescription(String description) {
        this.description = description;
    }
    
    /**
     * @return Retourne le b_modif.
     */
    public boolean isB_modif() {
        return b_modif;
    }
    /**
     * @param b_modif Le b_modif  positionner.
     */
    public void setB_modif(boolean b_modif) {
        this.b_modif = b_modif;
    }
    /**
     * @return Retourne le b_root.
     */
    public boolean isB_root() {
        return b_root;
    }
    /**
     * @param b_root Le b_root  positionner.
     */
    public void setB_root(boolean b_root) {
        this.b_root = b_root;
    }
    /**
     * @return Retourne le id.
     */
    public int getId() {
        return id;
    }
    /**
     * @param id Le id  positionner.
     */
    public void setId(int id) {
        this.id = id;
    }

    /**
     * @return Retourne le order.
     */
    public int getOrder() {
        return order;
    }
    /**
     * @param order Le order  positionner.
     */
    public void setOrder(int order) {
        this.order = order;
    }
    /**
     * @return Retourne le parent.
     */
    public int getParent() {
        return parent;
    }
    /**
     * @param parent Le parent  positionner.
     */
    public void setParent(int parent) {
        this.parent = parent;
    }
    /**
     * @return Retourne le title.
     */
    public String getTitle() {
        return title;
    }
    /**
     * @param title Le title  positionner.
     */
    public void setTitle(String title) {
        this.title = title;
    }
    /**
     * @return Retourne le id_group.
     */
    public String getId_group() {
        return id_group;
    }
    /**
     * @param id_group Le id_group  positionner.
     */
    public void setId_group(String id_group) {
        this.id_group = id_group;
    }
    /**
     * @return Retourne le login.
     */
    public String getLogin() {
        return login;
    }
    /**
     * @param login Le login  positionner.
     */
    public void setLogin(String login) {
        this.login = login;
    }
    /**
	 * La reprsentation XML de ce rpertoire avec affichage 
	 * s'il s'agit du rpertoire courant (Mode modification):<br>
	 * - dpli sur le rpertoire courant<br>
	 * - pile des rpertoires visits jusqu'au rpertoire courant
	 * (pour afficher le chemin)<br>
	 * @param id_r Le id  rechercher.
	 * @param p La profondeur dans l'arbre.
	 * @return
	 */
	public Hashtable toXMLString(int id_r,int p) {
	    StringBuffer xml = new StringBuffer();
		StringBuffer pile = new StringBuffer();
		
		Hashtable t=new Hashtable();
		if (getId()==id_r){
		    
		    pile.append("<element_pile type=\"folder\" ");
		    pile.append("id=\"" + getId() + "\" ");
		    pile.append("title=\"" + carac.convertirCaracXML(getTitle()) + "\" />");
		    
		    xml.append("<element type=\"folder\" ");
		    xml.append("ouvert=\"vrai\" ");
		    xml.append("prof=\"" + p + "\" ");
		    xml.append("id=\"" + getId() + "\" order=\"" + getOrder() + "\"> ");
			xml.append("<title>"+carac.convertirCaracXML(getTitle())+"</title>");
			xml.append("<desc>"+carac.convertirCaracXML(getDescription())+"</desc>");
		    Iterator i = subFolders.iterator();
			while(i.hasNext()) {
			    Folder tmp = (Folder)i.next();
			    xml.append("<element type=\"folder\" ");
			    xml.append("prof=\"" + (p+1) + "\" ");
				xml.append("id=\"" + tmp.getId() + "\" order=\"" + tmp.getOrder() + "\"> ");
				xml.append("<title>"+carac.convertirCaracXML(tmp.getTitle())+"</title>");
				xml.append("<desc>"+carac.convertirCaracXML(tmp.getDescription())+"</desc></element>");
	        }
			Iterator i2 = bookMarks.iterator();
			while(i2.hasNext()) {
			    BookMark tmp = (BookMark)i2.next();
			    xml.append("<element type=\"book\" ");
			    xml.append("prof=\"" + (p+1) + "\" ");
			    xml.append("href=\"" + carac.convertirCaracXML(tmp.getUrl()) + "\" ");
				xml.append("id=\"" + tmp.getId() + "\" order=\"" + tmp.getOrder() + "\"> ");
				xml.append("<title>"+carac.convertirCaracXML(tmp.getTitle())+"</title>");
				xml.append("<desc>"+carac.convertirCaracXML(tmp.getDescription())+"</desc></element>");
	        }
		    xml.append("</element>");
		    t.put("xml",xml);
		    t.put("bool",new Boolean(true));
		    t.put("pile",pile);
		}
		else{
		    Iterator i = subFolders.iterator();
		    StringBuffer SBtemp=new StringBuffer();
		    StringBuffer SBtemppile=new StringBuffer();
		    boolean b=false;
			while(i.hasNext()) {
			    Folder tmp = (Folder)i.next();
			    t=tmp.toXMLString(id_r,p+1);
			    if(((Boolean)t.get("bool")).booleanValue()){
			        b=true;
			        SBtemp.append(t.get("xml"));
			        SBtemppile.append(t.get("pile"));
			    }
			    else{
			        SBtemp.append("<element type=\"folder\" ");
			    //    SBtemp.append("ouvert=\"vrai\" ");
			        SBtemp.append("prof=\"" + (p+1) + "\" ");
			        SBtemp.append("id=\"" + tmp.getId() + "\" order=\"" + tmp.getOrder() + "\"> ");
			        SBtemp.append("<title>"+carac.convertirCaracXML(tmp.getTitle())+"</title>");
			        SBtemp.append("<desc>"+carac.convertirCaracXML(tmp.getDescription())+"</desc>");   
			        SBtemp.append("</element>");
			    }
	        }
			/*si 1 est a vrai on ajoute chaque retour*/
			if(b){
			    pile.append("<element_pile type=\"folder\" ");
			    pile.append("id=\"" + getId() + "\" ");
			    pile.append("title=\"" + getTitle() + "\" />");
			    pile.append(SBtemppile);
			    
				xml.append("<element type=\"folder\" ");
				xml.append("ouvert=\"vrai\" ");
				xml.append("prof=\"" + p + "\" ");
				xml.append("id=\"" + getId() + "\" order=\"" + getOrder() + "\"> ");
				xml.append("<title>"+carac.convertirCaracXML(getTitle())+"</title>");
				xml.append("<desc>"+carac.convertirCaracXML(getDescription())+"</desc>");
				xml.append(SBtemp);
								
				Iterator i2 = bookMarks.iterator();
				while(i2.hasNext()) {
				    BookMark tmp2 = (BookMark)i2.next();
		            xml.append(tmp2.toXMLString(p+1));
		        }
				xml.append("</element>");
			}
			t.put("xml",xml);
			t.put("bool",new Boolean(b));
			t.put("pile",pile);
		}
		return t;
	}
	/**
	 * La reprsentation XML de ce rpertoire avec affichage 
	 * uniquement du contenu du rpertoire (Mode navigation) 
	 * et pile des rpertoires visits jusqu'au rpertoire courant
	 * (pour afficher le chemin)<br>
	 * @return
	 */
	public Hashtable toXMLSimple(int id_r) {
		StringBuffer xml = new StringBuffer();
		StringBuffer pile = new StringBuffer();
		
		Hashtable t=new Hashtable();
		if (getId()==id_r){
		    
		    pile.append("<element_pile type=\"folder\" ");
		    pile.append("id=\"" + getId() + "\" ");
		    pile.append("title=\"" + carac.convertirCaracXML(getTitle()) + "\" />");
		    
		    Iterator i = subFolders.iterator();
			while(i.hasNext()) {
			    Folder tmp = (Folder)i.next();
			    xml.append("<element type=\"folder\" ");
				xml.append("id=\"" + tmp.getId() + "\" order=\"" + tmp.getOrder() + "\"> ");
				xml.append("<title>"+carac.convertirCaracXML(tmp.getTitle())+"</title>");
				xml.append("<desc>"+carac.convertirCaracXML(tmp.getDescription())+"</desc></element>");
	        }
			Iterator i2 = bookMarks.iterator();
				
			while(i2.hasNext()) {
			    BookMark tmp = (BookMark)i2.next();
			    
			    xml.append("<element type=\"book\" ");
			    xml.append("href=\"" + carac.convertirCaracXML(tmp.getUrl()) + "\" ");
				xml.append("id=\"" + tmp.getId() + "\" order=\"" + tmp.getOrder() + "\"> ");
				xml.append("<title>"+carac.convertirCaracXML(tmp.getTitle())+"</title>");
				xml.append("<desc>"+carac.convertirCaracXML(tmp.getDescription())+"</desc></element>");
	        }
		    
		    t.put("xml",xml);
		    t.put("bool",new Boolean(true));
		    t.put("pile",pile);
		}
		else{
		    Iterator i = subFolders.iterator();
		    StringBuffer SBtemp=new StringBuffer();
		    StringBuffer SBtemppile=new StringBuffer();
		    boolean b=false;
			while(i.hasNext()) {
			    Folder tmp = (Folder)i.next();
			    t=tmp.toXMLSimple(id_r);
			    if(((Boolean)t.get("bool")).booleanValue()){
			        b=true;
			        SBtemp.append(t.get("xml"));
			        SBtemppile.append(t.get("pile"));
			    }
			    
	        }
			/*si 1 est a vrai on ajoute chaque retour*/
			if(b){
			    pile.append("<element_pile type=\"folder\" ");
			    pile.append("id=\"" + getId() + "\" ");
			    pile.append("title=\"" + carac.convertirCaracXML(getTitle()) + "\" />");
			    pile.append(SBtemppile);
			       											
			    xml.append(SBtemp);
				
			}
			t.put("xml",xml);
			t.put("bool",new Boolean(b));
			t.put("pile",pile);
		}
		return t;
	}
	/**
	 * Arbre complet dpli
	 * @return
	 */
	public String toXMLComplet() {
	    StringBuffer xml = new StringBuffer();
	    
		xml.append("<folder ");
		xml.append("id=\"" + getId() + "\" order=\"" + getOrder() + "\"> ");
		xml.append("<title>"+carac.convertirCaracXML(getTitle())+"</title>");
		if(getDescription()!=null)
		    xml.append("<desc>"+carac.convertirCaracXML(getDescription())+"</desc>");
		else
		    xml.append("<desc></desc>");
	   
		Iterator i = subFolders.iterator();
		while(i.hasNext()) {
		    Folder tmp = (Folder)i.next();
            xml.append(tmp.toXMLComplet());
        }
		Iterator i2 = bookMarks.iterator();
		while(i2.hasNext()) {
		    BookMark tmp = (BookMark)i2.next();
            xml.append(tmp.toXMLComplet());
        }
		
		xml.append("</folder>");
		
		return xml.toString();
	}
	/**
	 * La reprsentation XBEL de ce rpertoire
	 * @return
	 */
	public String toXBELString() {
	    StringBuffer xml = new StringBuffer();
	    if(!b_root){
	        xml.append("\n<folder ");
			xml.append("id=\"" + getId() + "\"> ");
			xml.append("\n<title>"+getTitle()+"</title>");
	    }
		Iterator i = subFolders.iterator();
		while(i.hasNext()) {
		    Folder tmp = (Folder)i.next();
            xml.append(tmp.toXBELString());
        }
		Iterator i2 = bookMarks.iterator();
		while(i2.hasNext()) {
		    BookMark tmp = (BookMark)i2.next();
            xml.append(tmp.toXBELString());
        }
		if(!b_root)
		    xml.append("\n</folder>");
		
		return xml.toString();
	}
	/**
	 * La reprsentation NS de ce rpertoire
	 * @return
	 */
	public String toNSString() {
	    StringBuffer xml = new StringBuffer();
	    if(!b_root){
	        xml.append("\n<DT><H3 FOLDED ID=\""+getId()+"\">"+getTitle()+"</H3>");//ADD_DATE=\"1094565910\"
	        xml.append("\n<DL><p>");
	    }
		Iterator i = subFolders.iterator();
		while(i.hasNext()) {
		    Folder tmp = (Folder)i.next();
            xml.append(tmp.toNSString());
        }
		Iterator i2 = bookMarks.iterator();
		while(i2.hasNext()) {
		    BookMark tmp = (BookMark)i2.next();
            xml.append(tmp.toNSString());
        }
		if(!b_root)
		    xml.append("\n</DL><p>");
		
		return xml.toString();
	}
	/**
	 * La reprsentation IE de ce rpertoire
	 * @return
	 */
	public String toIEString() {
	    StringBuffer xml = new StringBuffer();
	    long l=System.currentTimeMillis();
	  
	    if(!b_root){
	        xml.append("\n<DT><H3 FOLDED ADD_DATE=\""+l+"\">"+getTitle()+"</H3>");
	        xml.append("\n<DL><p>");
	    }
		
		Iterator i = subFolders.iterator();
		while(i.hasNext()) {
		    Folder tmp = (Folder)i.next();
            xml.append(tmp.toIEString());
        }
		Iterator i2 = bookMarks.iterator();
		while(i2.hasNext()) {
		    BookMark tmp = (BookMark)i2.next();
            xml.append(tmp.toIEString());
        }
		if(!b_root)
		    xml.append("\n</DL><p>");
		
		return xml.toString();
	}
	/**
	 * La reprsentation Opera de ce rpertoire
	 * @return
	 */
	public String toOperaString() {
	    StringBuffer xml = new StringBuffer();
	    if(!b_root){
	        xml.append("\n#FOLDER \n\tID="+getId()+"\n\tNAME="+getTitle());//ADD_DATE=\"1094565910\"
	        xml.append("\n");
	    }
		Iterator i = subFolders.iterator();
		while(i.hasNext()) {
		    Folder tmp = (Folder)i.next();
            xml.append(tmp.toOperaString());
        }
		Iterator i2 = bookMarks.iterator();
		while(i2.hasNext()) {
		    BookMark tmp = (BookMark)i2.next();
            xml.append(tmp.toOperaString());
        }
		if(!b_root)
		    xml.append("\n-\n");
				
		return xml.toString();
	}
 
}
