<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:import href="./BookMarkTemplate.xsl" />
<xsl:output method="html" indent="no" />

<xsl:param name="baseActionURL"></xsl:param>
<xsl:param name="prefForm"></xsl:param>
<xsl:param name="mediaPath"></xsl:param>

<xsl:template match="xml">
	
<form method="post" action="{$baseActionURL}">
	<input type="hidden" name="action" value="saveFile" />
	<xsl:apply-templates select="id_folder_courant" />
	<table border="0" width="100%" cellspacing="0" cellpadding="10">
		<tr class="uportal-background-light">
			<td class="uportal-channel-table-header">Chargement d&#39;un fichier</td>
		</tr>
	</table>
	<table border="0">
		<tr>
			<td>
				Vous allez charger l'arborescence suivante :
				<table border="0">
					<xsl:apply-templates select="./folder">
					<!--Appel Récursif-->
						<xsl:sort select="./@order" order="ascending" data-type="number"/>
					</xsl:apply-templates>
				</table>
			</td>
		</tr>
	</table>
		
	<br/>
	<input type="submit" class="uportal-button" value="Enregistrer" name="butsave" /><input type="submit" class="uportal-button" value="Annuler" name="butannul" />
</form>
			
</xsl:template>

<!--Affichage de l element folder recursif-->
<xsl:template match="folder">

	<tr>
		<td>&#160;</td>
		<td nowrap="true">
			<table width="100%" border="0" cellpadding="0" cellspacing="0">
				<tr>
					<td width="21">
						<xsl:call-template name="icon.folder.ouvert" />
					</td>
					<td class="uportal-label">
						<xsl:value-of select="./title" />
					</td>
					<td>&#160;</td>
				
				</tr>
				<xsl:apply-templates select="./folder">
			
				<xsl:sort select="./@order" order="ascending" data-type="number"/>
					</xsl:apply-templates>
				<xsl:apply-templates select="./bookmark"/>
			</table>	
		</td>
		<td>&#160;</td>
	</tr>
		
</xsl:template>
<!--Affichage de l element folder recursif-->
<xsl:template match="bookmark">
	<tr>
		<td>&#160;</td>
		<td nowrap="true">
			<table width="100%" border="0" cellpadding="0" cellspacing="0">
				<tr>
				<td width="21">
						<xsl:call-template name="icon.bookmark" />
					</td>
					<td class="uportal-label">
						<xsl:value-of select="./title" />
					</td>		
				</tr>
			</table>	
		</td>
		<td>&#160;</td>
	</tr>
					
</xsl:template>

</xsl:stylesheet>