<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:import href="./BookMarkTemplate.xsl" />
<xsl:output method="html" indent="no" />

   <xsl:param name="baseActionURL" />

   <xsl:param name="prefForm" />

   <xsl:param name="mediaPath" />

   <xsl:param name="id_folder_courant" />
<!--onmouseover="setPointer(this, 'over', 'uportal-background-highlight', 'uportal-background-content');" onmouseout="setPointer(this, 'out', 'uportal-background-highlight', 'uportal-background-content');"-->
<!--<xsl:param name="superuser" />
<xsl:param name="all" />-->
   <xsl:template match="xml">
<script language="javascript" src="{$mediaPath}functions.js" >
</script>

   <table border="1" width="100%" cellspacing="0" cellpadding="0">
      <tr>
         <td class="uportal-background-dark">
<!-- La barre d outils-->
		   <xsl:call-template name="barre.outil.vue" />
         </td>
      </tr>

<!-- Le chemin courant-->
      <tr class="uportal-background-light">
         <td class="uportal-text">
<!--class="uportal-label" nowrap="true"-->
            <xsl:apply-templates select="./path" />
         </td>
      </tr>

      <tr>
         <td>
<!-- L arbre perso-->
<!--<table border="0" width="100%" cellspacing="0" cellpadding="10">
    -->
            <xsl:call-template name="arbre.perso" />
         </td>
      </tr>
   </table>
   </xsl:template>
<!--Affichage de la racine perso et appelle récursif-->
<xsl:template name="arbre.perso">
<table width="100%" border="0" cellpadding="0" cellspacing="0">
	<tr>
		<td nowrap="true" width="70%">
			<table width="100%" border="0" cellpadding="0" cellspacing="0">
				<!--affichage du root-->
				<tr><td>
				<table width="100%" border="0" cellpadding="0" cellspacing="0">
				<tr>
					<td width="21">
						<xsl:call-template name="icon.adbook" />
						
					</td>
					<td class="uportal-label">
						<a href="{$baseActionURL}?action=defaultvue&amp;id_folder_courant={./element/@id}&amp;id_book_courant=0">
							<xsl:value-of select="./element/title" />
						</a>
					</td>
					</tr>
				</table>	
				</td></tr>
				<xsl:apply-templates select="./element/element">
					<!--Appel Récursif-->
					<xsl:sort select="./@order" order="ascending" data-type="number" />
				</xsl:apply-templates>
			</table>
		</td>
		<td width="30%">&#160;</td>
	</tr>	
</table>
</xsl:template>

<!--Affichage de l element folder recursif-->
<xsl:template match="element">
	<tr>
		<xsl:variable name='dec'><xsl:value-of select="./@prof * 21" /></xsl:variable>
		<td nowrap="true">
			<table width="100%" border="0" cellpadding="0" cellspacing="0">
				<tr onmouseover="setPointer(this, 'over', 'uportal-background-highlight', 'uportal-background-content');" onmouseout="setPointer(this, 'out', 'uportal-background-highlight', 'uportal-background-content');">
					<td width="{$dec}">&#160;
					</td>
					<td width="21">
						<xsl:if test="./@type='book'">
							<xsl:call-template name="icon.bookmark.vue" />
						</xsl:if>
						<xsl:if test="./@type='folder'">
							<xsl:choose><xsl:when test="./@ouvert='vrai'">
								<xsl:call-template name="icon.folder.ouvert.vue" />			
							</xsl:when>
							<xsl:otherwise>
								<xsl:call-template name="icon.folder.ferme.vue" />
							</xsl:otherwise></xsl:choose>
						</xsl:if>
					</td>
					
						<xsl:if test="./@type='folder'">
							<td class="uportal-label" nowrap="true">
									<a href="{$baseActionURL}?action=defaultvue&amp;id_folder_courant={./@id}&amp;id_book_courant=0#[{./@id}]">
											<xsl:value-of select="./title" />
										</a><A NAME="[{./@id}]{/xml/id_channel/@val}"/>
							<!--</td>
									<td nowrap="true" class="uportal-label">--><xsl:choose>
										<xsl:when test="./desc=''">
											&#160;
										</xsl:when>	
										<xsl:otherwise>
											:&#160;<xsl:value-of select="./desc" />
										</xsl:otherwise>
										</xsl:choose>
									</td>
								
						</xsl:if>
						<xsl:if test="./@type='book'">
							<td class="uportal-label" nowrap="true">
									<a href="{./@href}" target="_blank">
											<xsl:value-of select="./title" />
									</a>
										<A NAME="[{./@id}]{/xml/id_channel/@val}"/>
									<!--</td>
									<td nowrap="true" class="uportal-label">-->
										<xsl:choose>
										<xsl:when test="./desc=''">
											&#160;
										</xsl:when>	
										<xsl:otherwise>
											:&#160;<xsl:value-of select="./desc" />
										</xsl:otherwise>
										</xsl:choose>
								</td>
						
					</xsl:if>	
							
				<!--<xsl:if test="count(./element)!=0">
					<td>&#160;</td>
				</xsl:if>-->
			</tr>	
		</table>
	</td>
	<!--<td width="100%">&#160;</td>-->
</tr>	
<xsl:apply-templates select="./element">
	<!--Appel Récursif-->
	<xsl:sort select="./@order" order="ascending" data-type="number"/>
</xsl:apply-templates>		
</xsl:template>


<!-- Affichage du chemin-->
   <xsl:template match="path">
      <xsl:for-each select="./element_pile">
         <a href="{$baseActionURL}?action=defaultvue&amp;id_folder_courant={./@id}&amp;id_book_courant=0">
            <xsl:value-of select="./@title" />
         </a>

         <xsl:if test="position()!=last()">&gt;</xsl:if>
      </xsl:for-each>

      <xsl:apply-templates select="/xml/id_book_courant" />
   </xsl:template>

<!--Affichage du bookmark courant s'il est selectione-->
   <xsl:template match="id_book_courant">&gt; 
   <a href="{$baseActionURL}?action=defaultvue&amp;id={./@id}&amp;id_folder_courant={/xml/id_folder_courant/@id}&amp;id_book_courant={./@id}&amp;title_book_courant={./@title}">
      <xsl:value-of select="./@title" />
   </a>
   </xsl:template>

   <xsl:template match="ligne">
      <br>
      </br>

      <xsl:value-of select="." />
   </xsl:template>
</xsl:stylesheet>