/*
 * Cree le 2 dc. 2004
 *
 * TODO 
 * par cbissler
 * Centre de Ressources Informatiques 
 * Universit Henri Poincar 
 */
package org.esupportail.portal.channels.CSignet2.actions;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;


import org.esupportail.portal.channels.CSignet2.beans.Folder;
import org.esupportail.portal.channels.CSignet2.data.DataControler;
import org.esupportail.portal.channels.CSignet2.data.DataException;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.plugins.Message;
import org.esupportail.portal.utils.channels.plugins.MessageBean;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.IMimeResponse;
import org.jasig.portal.PortalException;

/**
 * Download<br>
 * <br>
 * Action de tlchargement d'un extract des bookmarks
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:celine.bissler@uhp-nancy.fr">Cline Bissler</a>
 * @version 1.1 
 */
public class Download extends SignetAction implements IMimeResponse {
    StringBuffer output=null;
    String name=null;
    /**
     * Constructeur
     * @param mainchannel
     */
    public Download(MainChannel mainchannel){
        super(mainchannel);
        
    }
    /**
     * Action du Download
     * @param rd Le RuntimeData
     * @return Boolean.TRUE si l'action s'est bien passe, Boolean.FALSE sinon
     * @throws PortalException
     * @throws FrameWorkException
     */
    public Boolean initDownLoad(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        log.info("CSignet2 - Download::initDownLoad()");
        runtimeData = rd;
		paramAction();
		output=new StringBuffer();
        name=new String();
		DataControler cd=new DataControler();
		root=new Folder();

	    try {
             root=cd.RecupererArbrePerso(login);
             
        } catch (DataException e) {
            log.error("CSignet2 - Principal::init() : Erreur d'acc\u00E8s \u00E0 la page "+e.getMessage());
            Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "default");		
        	return Boolean.FALSE;
        }
		// Rcupration bouton
		String button = runtimeData.getParameter("butcreer");
	    if(button == null) {
		    retourAccueil(runtimeData);
			return Boolean.FALSE;
		}
		String type = runtimeData.getParameter("type");
	
		if(type == null) {
		    log.error("CSignet2 - Upload::initView() : Erreur d'acc\u00E8s \u00E0 la page");
			Message.message(mainChannel, runtimeData, new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "defaultModif");		
			return Boolean.FALSE;
		}
		
		if (type.equals("IE")){
		    output.append("<!DOCTYPE NETSCAPE-Bookmark-file-1>");
		    output.append("\n<!-- Fichier genere automatiquement par Esup_Portail. -->");
		    output.append("\n<TITLE>Bookmarks</TITLE>");
		    output.append("\n<H1>Bookmarks</H1>");
		    output.append("\n<DL><p>");
		    output.append((root.toIEString()).replaceAll("&amp;","&"));
		    name = "Signets_portail.htm";
		    output.append("\n</DL><p>");
		}
		else if(type.equals("NS")){
		    output.append("<!DOCTYPE NETSCAPE-Bookmark-file-1>");
		    output.append("\n<!-- Fichier genere automatiquement par Esup_Portail. -->");
		    output.append("\n<META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html; charset=UTF-8\">");
		    output.append("\n<TITLE>Bookmarks</TITLE>");
		    output.append("\n<H1>Bookmarks</H1>");
		    output.append("\n<DL><p>");
		    output.append(root.toNSString());
		    name = "Signets_portail.html";
		    output.append("\n</DL><p>");
		}
		else if(type.equals("OP")){
		    output.append("\nOpera Hotlist version 2.0");
		    output.append("\nOptions: encoding = utf8, version=3");
		    output.append(root.toOperaString());
		    name = "Signets_portail.adr";
		}
		else if(type.equals("XBEL")){
		    output.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
		    output.append(" <!DOCTYPE xbel PUBLIC \"+//IDN python.org//DTD XML Bookmark Exchange Language 1.0//EN//XML\" \"http://www.python.org/topics/xml/dtds/xbel-1.0.dtd\">");
		    output.append(" <xbel version=\"1.0\" added=\"2004-11-16T04:15:28-05:00\">");
		    output.append("<info><metadata owner=\"Esup_Portail\" generated_by=\"Esup_Portail\" /></info>");
		    output.append(root.toXBELString());
		    output.append(" </xbel>");
		    name = "Signets_portail.xbel";
		}
	
	return Boolean.FALSE;
    }
    
    /**
     * Affecte le contenu 
     */
    public void downloadData(OutputStream out) throws IOException {
        log.info("CSignet2 - Upload::downloadData()");
        out.write(output.toString().getBytes());
    }
   /**
    * Positionne le Content-type
    */
    public String getContentType() {
        log.info("CSignet2 - Upload::getContentType()");
        return "application/octetstream";
    }
    /**
     * Positionne le Header
     */
    public Map getHeaders() {
        log.info("CSignet2 - Upload::getHeaders()");
        HashMap map = new HashMap();
		map.put("Content-disposition", "attachment; filename=" + getName());
		return map;
    }
    /**
     * Mthode non utilise qui renvoie le input stream
     */
    public InputStream getInputStream() throws IOException {
        return null;
    }
    
    /**
     * Positionne le nom
     */
    public String getName() {
        log.info("CSignet2 - Upload::getName()");
        return name;
    }
    /**
     * Logue les erreurs de download
     */
    public void reportDownloadError(Exception e) {
        log.fatal("CSignet2 - Download::reportDownloadError() : " + e);
    }


}
