/*
 * Cree le 6 sept. 2004
 *
 * par cbissler
 * Centre de Ressources Informatiques 
 * Universit Henry Poincar 
 */
package org.esupportail.portal.channels.CSignet2.beans;

import org.esupportail.portal.channels.CSignet2.utils.CaracteresSpeciaux;



/**
 * BookMark<br> 
 * <br>
 * Classe mtier qui reprsente un signet
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:celine.bissler@uhp-nancy.fr">Cline Bissler</a>
 * @version 1.1 
 */

public class BookMark extends Folder{

    private String url = null;
    /**
     * Constructeur
     */
    public BookMark() {
        super();
       
    }
   
    /**
     * @return Retourne le url.
     */
    public String getUrl() {
        return url;
    }
    /**
     * @param url Le url  positionner.
     */
    public void setUrl(String url) {
        this.url = url;
    }
 
    /** 
     * La reprsentation XML de ce signet avec affichage 
	 * s'il s'agit du rpertoire courant (Mode modification):<br>
	 * - dpli sur le rpertoire courant<br>
	 * - pile des rpertoires visits jusqu'au rpertoire courant
	 * (pour afficher le chemin)<br>
	 * @param p La profondeur dans l'arbre.
     * @see org.esupportail.portal.channels.CSignet2.beans.Folder#toXMLString()
     */
    public String toXMLString(int p) {
       StringBuffer xml = new StringBuffer();
        xml.append("<element type=\"book\" ");
        xml.append("prof=\"" + p + "\" ");
        xml.append("href=\"" + carac.convertirCaracXML(getUrl()) + "\" ");
		xml.append("id=\"" + getId() + "\" order=\"" + getOrder() + "\"> ");
		xml.append("<title>"+carac.convertirCaracXML(getTitle())+"</title>");
		xml.append("<desc>"+carac.convertirCaracXML(getDescription())+"</desc>");
		xml.append("</element>");
        return xml.toString();
    }
    /** 
     * La reprsentation XML de ce signet avec affichage 
	 * uniquement du contenu du rpertoire (Mode navigation) 
	 * et pile des rpertoires visits jusqu'au rpertoire courant
	 * (pour afficher le chemin)<br>
     * @see org.esupportail.portal.channels.CSignet2.beans.Folder#toXMLString()
     */
    public String toXMLSimple() {
        StringBuffer xml = new StringBuffer();
        xml.append("<element type=\"book\" ");
        xml.append("href=\"" + carac.convertirCaracXML(getUrl()) + "\" ");
		xml.append("id=\"" + getId() + "\" order=\"" + getOrder() + "\"> ");
		xml.append("<title>"+carac.convertirCaracXML(getTitle())+"</title>");
		xml.append("<desc>"+carac.convertirCaracXML(getDescription())+"</desc>");
		xml.append("</element>");
        return xml.toString();
    }
    /** 
     * Arbre complet dpli
     * @see org.esupportail.portal.channels.CSignet2.beans.Folder#toXMLString()
     */
    public String toXMLComplet() {
        StringBuffer xml = new StringBuffer();
        xml.append("<bookmark ");
		xml.append("href=\"" + carac.convertirCaracXML(getUrl()) + "\" ");
		xml.append("id=\"" + getId() + "\" order=\"" + getOrder() + "\"> ");
		xml.append("<title>"+carac.convertirCaracXML(getTitle())+"</title>");
		if(getDescription()!=null)
		    xml.append("<desc>"+carac.convertirCaracXML(getDescription())+"</desc>");
		else
		    xml.append("<desc></desc>");
		xml.append("</bookmark>");
        return xml.toString();
    }
    /** 
     * La reprsentation XBEL de ce bookmark
     * @see org.esupportail.portal.channels.CSignet2.beans.Folder#toXMLString()
     */
    public String toXBELString() {
	    StringBuffer xml = new StringBuffer();
        xml.append("\n<bookmark ");
		xml.append("href=\"" + getUrl() + "\" ");
		xml.append("id=\"" + getId() + "\"> ");
		xml.append("<title>"+getTitle()+"</title>");
		xml.append("</bookmark>");
        return xml.toString();
    }
    /** 
     * La reprsentation IE de ce bookmark
     * @see org.esupportail.portal.channels.CSignet2.beans.Folder#toXMLString()
     */
    public String toIEString() {
	    StringBuffer xml = new StringBuffer();
	    long l=System.currentTimeMillis() ;
	    
        xml.append("\n<DT><A ");
		xml.append("HREF=\"" + getUrl() + "\" ADD_DATE=\""+l+"\" LAST_VISIT=\""+l+"\" LAST_MODIFIED=\""+l+"\">");
		xml.append(getTitle()+"</A>");
        return xml.toString();
    }
    /** 
     * La reprsentation NS de ce bookmark
     * @see org.esupportail.portal.channels.CSignet2.beans.Folder#toXMLString()
     */
    public String toNSString() {
        StringBuffer xml = new StringBuffer();
        xml.append("\n<DT><A ");
		xml.append("HREF=\"" + getUrl() + "\" ID=\""+getId()+"\">");
		xml.append(getTitle()+"</A>");
        return xml.toString();
    }
    /** 
     * La reprsentation Opera de ce bookmark
     * @see org.esupportail.portal.channels.CSignet2.beans.Folder#toXMLString()
     */
    public String toOperaString() {
	    StringBuffer xml = new StringBuffer();
        xml.append("\n#URL ");
		
		xml.append("\n\tID=" + getId());
		xml.append("\n\tNAME=" + getTitle());
		xml.append("\n\tURL="+getUrl());
		xml.append("\n");
        return xml.toString();
    }
}
