/*
 * Cree le 12 oct. 2004
 *
 * par cbissler
 * Centre de Ressources Informatiques 
 * Universit Henri Poincar 
 */
package org.esupportail.portal.channels.CSignet2.actions;

import java.util.Enumeration;
import java.util.Hashtable;

import org.esupportail.portal.channels.CSignet2.beans.BookMark;
import org.esupportail.portal.channels.CSignet2.data.DataControler;
import org.esupportail.portal.channels.CSignet2.data.DataException;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.plugins.Message;
import org.esupportail.portal.utils.channels.plugins.MessageBean;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;

/**
 * DeleteBookMark<br>
 * <br>
 * Action de suppression d'un bookmark
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:celine.bissler@uhp-nancy.fr">Cline Bissler</a>
 * @version 1.1 
 */
public class DeleteBookMark extends SignetAction{
   
    BookMark book=null;
    int id_book;
    /**
     * Constructeur
     * @param mainchannel Channel principale
     */
    public DeleteBookMark(MainChannel mainchannel){
        super(mainchannel);
    }
    /**
     * Init par dfaut qui lance la demande de confirmation de suppression
     */
    public Boolean init(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		if (log.isDebugEnabled()) log.debug("CSignet2 - DeleteBookMark::init()");
		runtimeData = rd;
		
		paramAction();
		
		id_book= Integer.parseInt(runtimeData.getParameter("id_book"));
		
		DataControler data = new DataControler();
    	
    	try {
            book=data.getBookMark(id_book);
    	} catch (DataException e) {
            log.error( "CSignet2 - DeleteBookMark::init() : Erreur d'acc\u00E8s au bookmark \u00E0 supprimer");
    		Message.message(mainChannel, runtimeData, new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "default");		
    		return Boolean.FALSE;
        }
		
		return Boolean.TRUE;
	}
    /**
     * Init qui supprime le bookmark
     * @param rd Le RuntimeData
     * @return Boolean.TRUE si l'action s'est bien passe, Boolean.FALSE sinon
     * @throws PortalException
     * @throws FrameWorkException
     */
    public Boolean delBookMarkInit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		if (log.isDebugEnabled()) log.debug("CSignet2 - DeleteBookMark::delBookMarkInit()");
		runtimeData = rd;
		
		paramAction();

		// Rcupration bouton
		String button = runtimeData.getParameter("butsupprimer");
		
		// Clic sur le bouton Annuler
		if(button == null) {
		    retourAccueil(runtimeData);
			return Boolean.FALSE;
		}
		DataControler data = new DataControler();
		try {
            data.deleteBookMark(book);
        } catch (DataException e) {
            log.error("CSignet2 - DeleteBookMark::delBookMarkInit()Erreur dans la suppression de bookmark : "+e.getMessage());
            Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "default");
            return Boolean.FALSE;
        }
        Hashtable tmp=new Hashtable();
        tmp.put("id",new Integer(book.getId()));
        tmp.put("title",book.getTitle());
        tmp.put("type","book");
        //id_elements_copy.remove(tmp);
        runtimeData.put("oter_copy",tmp);
        retourAccueil(runtimeData);
		
		return Boolean.FALSE;
	}
    /**
     * Cre le XML correspondant
     */
    public Boolean setXML() {
		if (log.isDebugEnabled()) log.debug("CSignet2 - DeleteBookMark::setXML()");
		StringBuffer xml = new StringBuffer();
		
		xml=paramXML(xml);
		
		xml.append("<bookmark id=\""+book.getId()+"\" " );
    	xml.append("titre=\""+book.getTitle()+"\" ");
    	xml.append("desc=\""+book.getDescription()+"\" ");
    	xml.append("url=\""+book.getUrl()+"\"/>");
    	
		this.xml = xml.toString();
		
		return Boolean.TRUE;
	}
}