/*
 * Cree le 12 oct. 2004
 *
 * par cbissler
 * Centre de Ressources Informatiques 
 * Universit Henri Poincar 
 */
package org.esupportail.portal.channels.CSignet2.actions;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

import org.esupportail.portal.channels.CSignet2.beans.Folder;
import org.esupportail.portal.channels.CSignet2.data.DataControler;
import org.esupportail.portal.channels.CSignet2.data.DataException;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.plugins.Message;
import org.esupportail.portal.utils.channels.plugins.MessageBean;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;


/**
 * DeleteFolder<br>
 * <br>
 * Action de suppression d'un dossier
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:celine.bissler@uhp-nancy.fr">Cline Bissler</a>
 * @version 1.1 
 */
public class DeleteFolder extends SignetAction {
    
    Folder folder=null;
    int id_fold;
    /**
     * Constructeur
     * @param mainchannel Channel principale
     */
    public DeleteFolder(MainChannel mainchannel){
        super(mainchannel);
    }
    /**
     * Init par dfaut qui lance la demande de confirmation de suppression
     */
    public Boolean init(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
    	if (log.isDebugEnabled()) log.debug("CSignet2 - DeleteFolder::init()");
    	runtimeData = rd;
    	
    	paramAction();
    	
		id_fold= Integer.parseInt(runtimeData.getParameter("id_fold"));
				
    	DataControler data = new DataControler();
    	
    	try {
            folder=data.getFolder(id_fold);
            
        } catch (DataException e) {
            log.error( "CSignet2 - DeleteFolder::Init() : Erreur d'acc\u00E8s au folder \u00E0 supprimer");
    		Message.message(mainChannel, runtimeData, new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "default");		
    		return Boolean.FALSE;
        }
    	    	
    	return Boolean.TRUE;
    }
    /**
     * Init de suppression d'un folder
     * @param rd Le RuntimeData
     * @return Boolean.TRUE si l'action s'est bien passe, Boolean.FALSE sinon
     * @throws PortalException
     * @throws FrameWorkException
     */
    public Boolean delFolderInit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
    	if (log.isDebugEnabled()) log.debug("CSignet2 - DeleteFolder::delFolderInit()");
    	runtimeData = rd;
    	paramAction();
    	
    	// Rcupration bouton
    	String button = runtimeData.getParameter("butsupprimer");
    	
    	// Clic sur le bouton Annuler
    	if(button == null) {
    	    retourAccueil(runtimeData);
    		return Boolean.FALSE;
    	}
    	
    	// Rcupration IDataReadManager
    	DataControler data = new DataControler();
    	Vector v=new Vector();
    	try {
    	   v=data.supprimerArbre(folder);
        } catch (DataException e) {
            log.error("CSignet2 - DeleteFolder::delFolderInit()Erreur dans la suppression du dossier : "+e.getMessage());
            Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "DeleteFolder");
            return Boolean.FALSE;
        }
       
        /*Hashtable tmp=new Hashtable();
        tmp.put("id",new Integer(folder.getId()));
        tmp.put("title",folder.getTitle());
        tmp.put("type","folder");*/
        //id_elements_copy.remove(tmp);
        if (log.isDebugEnabled()) log.debug("CSignet2 - DeleteFolder::delFolderInit()TAILLE est "+v.size());
        
        
        runtimeData.put("oter_copy_v",v);
        retourAccueil(runtimeData);
    	
    	return Boolean.FALSE;
    }
    /**
     * Cre le XML correspondant
     */
    public Boolean setXML() {
    	if (log.isDebugEnabled()) log.debug("CSignet2 - DeleteFolder::setXML()");
    	StringBuffer xml = new StringBuffer();

    	xml=paramXML(xml);
    	
    	xml.append("<folder id=\""+folder.getId()+"\" " );
    	xml.append("titre=\""+folder.getTitle()+"\" ");
    	xml.append("nb_book=\""+folder.getBookMarks().size()+"\" ");
    	xml.append("nb_fold=\""+folder.getSubFolders().size()+"\" ");
    	xml.append("desc=\""+folder.getDescription()+"\"/>");
    	xml.append(folder.toXMLComplet());
    	
    	this.xml = xml.toString();
    
    	return Boolean.TRUE;
    }

    }
