/*
 * Cree le 11 oct. 2004
 *
 * par cbissler
 * Centre de Ressources Informatiques 
 * Universit Henri Poincar 
 */
package org.esupportail.portal.channels.CSignet2.actions;

import org.esupportail.portal.channels.CSignet2.beans.BookMark;
import org.esupportail.portal.channels.CSignet2.data.DataControler;
import org.esupportail.portal.channels.CSignet2.data.DataException;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;

import org.esupportail.portal.utils.channels.plugins.Message;
import org.esupportail.portal.utils.channels.plugins.MessageBean;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;


/**
 * ModifyBookMark<br>
 * <br>
 * Action de modification d'un bookmark
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:celine.bissler@uhp-nancy.fr">Cline Bissler</a>
 * @version 1.1 
 */
public class ModifyBookMark extends SignetAction{
    
    BookMark book=null;
    int id_book;
    /**
     * Constructeur
     * @param mainchannel Channel principale
     */
    public ModifyBookMark(MainChannel mainchannel){
        super(mainchannel);
    }
    /**
     * Init par dfaut qui lance le formulaire de modification
     */
    public Boolean init(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		if (log.isDebugEnabled()) log.debug("CSignet2 - ModifyBookMark::init()");
		runtimeData = rd;
		
		paramAction();
		id_book= Integer.parseInt(runtimeData.getParameter("id_book"));
		
		DataControler data = new DataControler();
    	
    	try {
            book=data.getBookMark(id_book);
        } catch (DataException e) {
            log.error("CSignet2 - ModifyBookMark::Init() : Erreur d'acc\u00E8s \u00E0 la page");
    		Message.message(mainChannel, runtimeData, new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "default");		
    		return Boolean.FALSE;
        }
		
		return Boolean.TRUE;
	}
    /**
     * Init de modification d'un bookmark
     * @param rd Le RuntimeData
     * @return Boolean.TRUE si l'action s'est bien passe, Boolean.FALSE sinon
     * @throws PortalException
     * @throws FrameWorkException
     */
    public Boolean modBookMarkInit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		if (log.isDebugEnabled()) log.debug("CSignet2 - ModifyBookMark::modBookMarkInit()");
		runtimeData = rd;
		paramAction();
		
		// Rcupration bouton
		String button = runtimeData.getParameter("butmodifier");
		
		// Clic sur le bouton Annuler
		if(button == null) {
		    retourAccueil(runtimeData);
			return Boolean.FALSE;
		}
		
		// Rcupration paramtres
		String description = runtimeData.getParameter("description");
		String titre = runtimeData.getParameter("titre");
		String url = runtimeData.getParameter("url");
		// Tentative d'accs sans paramtres
		if(titre == null) {
			log.error("CSignet2 - ModifyBookMark::modBookMarkInit() : Erreur d'acc\u00E8s \u00E0 la page");
			Message.message(mainChannel, runtimeData, new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "default");		
			return Boolean.FALSE;
		}
		if(url == null) {
			log.error( "CSignet2 - ModifyBookMark::modBookMarkInit() : Erreur d'acc\u00E8s \u00E0 la page");
			Message.message(mainChannel, runtimeData, new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "default");		
			return Boolean.FALSE;
		}
				
		// Rcupration IDataReadManager
		DataControler data = new DataControler();
		
		book.setDescription(description);
		book.setTitle(titre);
		book.setUrl(url);
		try {
            data.modifyBookMark(book);
        } catch (DataException e) {
            log.error("CSignet2 - ModifyBookMark::modBookMarkInit()Erreur dans la modification du bookmark : "+e.getMessage());
            Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "ModifyBookMark");
            return Boolean.FALSE;
        }
        retourAccueil(runtimeData);
		
		return Boolean.FALSE;
	}
    /**
     * Cre le XML correspondant
     */
    public Boolean setXML() {
		if (log.isDebugEnabled()) log.debug("CSignet2 - ModifyBookMark::setXML()");
		StringBuffer xml = new StringBuffer();
		
		xml=paramXML(xml);
		
		xml.append("<bookmark id=\""+book.getId()+"\" " );
    	xml.append("titre=\""+book.getTitle()+"\" ");
    	xml.append("desc=\""+book.getDescription()+"\" ");
    	xml.append("url=\""+book.getUrl()+"\"/>");
    	
		this.xml = xml.toString();
		
		return Boolean.TRUE;
	}

}
