package org.esupportail.portal.channels.CSignet2.actions;



import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.plugins.Message;
import org.esupportail.portal.utils.channels.plugins.MessageBean;
import org.esupportail.portal.channels.CSignet2.beans.Folder;
import org.esupportail.portal.channels.CSignet2.data.DataControler;
import org.esupportail.portal.channels.CSignet2.data.DataException;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;

import java.util.Hashtable;

/**
 * PrincipalVue<br>
 * <br>
 * Cette action prend en charge l'affichage de l'arbre en mode Navigation ainsi 
 * que toutes les actions accesibles par ce mode<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:celine.bissler@uhp-nancy.fr">Cline Bissler</a>
 * @version 1.1 
 */

public class PrincipalVue extends SignetAction {

	/**
	 * Constructeur
	 * @param mainChannel Channel principale
	 */
	public PrincipalVue(MainChannel mainChannel) {
		super(mainChannel);
	}
		
	/**
	 * Recherche de l'arborescence de signets de l'utilisateur connect
	 * @param rd Le RuntimeData
	 * @return Boolean.TRUE si l'action s'est bien passe, Boolean.FALSE sinon
	 */
	public Boolean init(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		if (log.isDebugEnabled()) log.debug("CSignet2 - PrincipalVue::init()");
		runtimeData = rd;
		log.debug("CSignet2 - PrincipalVue::init()1");
		paramAction();
		log.debug("CSignet2 - PrincipalVue::init()2");
		DataControler cd=new DataControler();
		log.debug("CSignet2 - PrincipalVue::init()3");
		root=new Folder();
		log.debug("CSignet2 - PrincipalVue::init()4");
	        try {
                root=cd.RecupererArbrePerso(login);
                log.debug("CSignet2 - PrincipalVue::init(5)");
                xmlroot=root.toXMLComplet();
            } catch (DataException e) {
                log.error("CSignet2 - PrincipalVue::init() : Erreur d'acc\u00E8s \u00E0 la page "+e.getMessage());
        		Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "default");		
        		return Boolean.FALSE;
            }
	    id_folder_courant=root.getId();
		return Boolean.TRUE;
	}
	
	/**
	 * Init visualisation
	 * @param rd Le RuntimeData
	 * @return Boolean.TRUE si l'action s'est bien passe, Boolean.FALSE sinon
	 * @throws PortalException
	 * @throws FrameWorkException
	 */
	public Boolean initVue(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		if (log.isDebugEnabled()) log.debug("CSignet2 - PrincipalVue::initvue()");
		runtimeData = rd;
		paramAction();
		
		return Boolean.TRUE;
	}
	
	/**
	 * Cre le XML correspondant
	 * @return Boolean.TRUE
	 */
	public Boolean setXML() {

		if (log.isDebugEnabled()) log.debug("CSignet2 - PrincipalVue::setXML()");
		StringBuffer xml = new StringBuffer();
		Hashtable tmp= (Hashtable)root.toXMLString(id_folder_courant,0);
		xml=paramXML(xml);
		
		xml.append("<path>" );
		xml.append((StringBuffer)tmp.get("pile"));
		xml.append("</path>");
		
		xml.append((StringBuffer)tmp.get("xml"));
		this.xml = xml.toString();
		
		return Boolean.TRUE;
	}
}
