/*
 * Cree le 18 oct. 2004
 *
 * par cbissler
 * Centre de Ressources Informatiques 
 * Universit Henri Poincar 
 */
package org.esupportail.portal.channels.CSignet2.actions;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;


import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CSignet2.beans.Folder;
import org.esupportail.portal.channels.CSignet2.config.Config;
import org.esupportail.portal.channels.CSignet2.data.DataControler;
import org.esupportail.portal.channels.CSignet2.data.DataException;
import org.esupportail.portal.channels.CSignet2.utils.CaracteresSpeciaux;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.SubChannel;
import org.esupportail.portal.utils.channels.plugins.Message;
import org.esupportail.portal.utils.channels.plugins.MessageBean;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;
import org.jasig.portal.security.IPerson;

/**
 * SignetAction<br>
 * <br>
 * Accde aux parametres communs  toute les actions
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:celine.bissler@uhp-nancy.fr">Cline Bissler</a>
 * @version 1.1 
 */
public class SignetAction extends SubChannel{
    String login=null;
    String id_channel=null;
    int id_folder_courant=0;
    int id_book_courant=0;
    String title_book_courant=null;
    Vector id_elements_copy=null;
    //String title_element_copy=null;
    String mode="view";
    Folder root=null;
    String xmlroot=null;
    String useicon=null;
    CaracteresSpeciaux carac=null;
    protected static final Log log = LogFactory.getLog(SignetAction.class);
    
    /**
     * Constructeur
     * @param mainchannel Channel principale
     */
    public SignetAction(MainChannel mainchannel){
        super(mainchannel);
        carac=new CaracteresSpeciaux();
        useicon=Config.getInstance().getUseicon();
        
        
    }
    /**
     * Init par dfaut
     */
    public Boolean init(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
    	if (log.isDebugEnabled()) log.debug("CSignet2 - SignetAction::init()");
    	runtimeData = rd;   	
    	return Boolean.TRUE;
    }
    /**
     * Cre le XML par dfaut
     */
    public Boolean setXML() {
    	if (log.isDebugEnabled()) log.debug("CSignet2 - SignetAction::setXML()");
    	return Boolean.TRUE;
    }
    /**
     * Rcupre les paramtres
     * @throws PortalException
     */
    public void paramAction() throws PortalException{
        if (log.isDebugEnabled()) log.debug("CSignet2 - SignetAction::paramAction()");
        login = mainChannel.getStaticData().getPerson().getAttribute(IPerson.USERNAME).toString();
			
		id_channel= mainChannel.getStaticData().getChannelSubscribeId();
		if (log.isDebugEnabled()) log.debug("CSignet2 - SignetAction::paramAction() IdentifSUB"+id_channel);
			  
		if (runtimeData.getParameter("id_folder_courant")!=null){
		    if (log.isDebugEnabled()) log.debug("CSignet2 - SignetAction::paramAction() parametre folder courant"+runtimeData.getParameter("id_folder_courant"));
			id_folder_courant= Integer.parseInt(runtimeData.getParameter("id_folder_courant"));
		}
		if (runtimeData.getParameter("id_book_courant")!=null){
		    if (log.isDebugEnabled()) log.debug("CSignet2 - SignetAction::paramAction() parametre book courant"+runtimeData.getParameter("id_book_courant"));
			id_book_courant= Integer.parseInt(runtimeData.getParameter("id_book_courant"));
		}
		if (runtimeData.getParameter("title_book_courant")!=null){
		    if (log.isDebugEnabled()) log.debug("CSignet2 - SignetAction::paramAction() parametre title book courant"+runtimeData.getParameter("title_book_courant"));
			title_book_courant= runtimeData.getParameter("title_book_courant");
		}
		if (runtimeData.get("id_elements_copy")!=null){
		    if (log.isDebugEnabled()) log.debug("CSignet2 - SignetAction::paramAction() parametre element copy");
			id_elements_copy=(Vector)runtimeData.get("id_elements_copy");
		}	
		if (runtimeData.get("oter_copy")!=null){
		    if (log.isDebugEnabled()) log.debug("CSignet2 - SignetAction::paramAction() parametre element a oter");
			id_elements_copy.remove((Hashtable)runtimeData.get("oter_copy"));
		}	
		if (runtimeData.get("oter_copy_v")!=null){
		    if (log.isDebugEnabled()) log.debug("CSignet2 - SignetAction::paramAction() parametre element a oter");
		    Vector vi=(Vector)runtimeData.get("oter_copy_v");
		    if (log.isDebugEnabled()) log.debug("CSignet2 - SignetAction::paramAction() parametre taille ici"+vi.size());
			   
		    Iterator enu=vi.iterator(); 
		    while(enu.hasNext()){
		        //if (log.isDebugEnabled()) log.debug("CSignet2 - SignetAction::paramAction() on ote de la copie "+enu.next().getClass().toString());
		        Hashtable t=(Hashtable)enu.next();
		        if (log.isDebugEnabled()) log.debug("CSignet2 - SignetAction::paramAction() on ote de la copie "+(String)t.get("title"));
		        id_elements_copy.remove(t);
		    }
		}
		
    }
    /**
     * Ajoute les valeurs des paramtres en XML
     * @param xml
     * @return
     */
    public StringBuffer paramXML(StringBuffer xml){
        if (log.isDebugEnabled()) log.debug("CSignet2 - SignetAction::paramXML()");
        xml.append("<useicon val=\"" );
		xml.append(useicon);
		xml.append("\"/>");
		xml.append("<id_channel val=\"" );
		xml.append(id_channel);
		xml.append("\"/>");
		xml.append("<id_folder_courant id=\"" );
		xml.append(id_folder_courant);
		xml.append("\"/>");
		if ((id_elements_copy!=null)&&(!id_elements_copy.isEmpty())){
		     xml.append("<id_elements_copy>");
		    Enumeration en=id_elements_copy.elements();
			while (en.hasMoreElements())
			{
			    Hashtable tmp=(Hashtable)en.nextElement();
			    
			    int id_element_copy=((Integer)tmp.get("id")).intValue();
			    String type_element_copy=(String)tmp.get("type");
			    String title_element_copy=(String)tmp.get("title");
			    xml.append("<id_element_copy ");
			    xml.append("id=\""+id_element_copy+"\" ");
			    xml.append("title=\""+carac.convertirCaracXML(title_element_copy)+"\" ");
			    xml.append("type=\""+type_element_copy+"\"");
			    xml.append("/>");
			    if (log.isDebugEnabled()) log.debug("CSignet2 - SignetAction::paramXML() boucle"+id_element_copy+" "+title_element_copy);
				   
			}
			xml.append("</id_elements_copy>");
		}
		if (id_book_courant!=0){
			xml.append("<id_book_courant " );
			xml.append("id=\""+id_book_courant+"\" ");
			xml.append("title=\""+carac.convertirCaracXML(title_book_courant)+"\"");
			xml.append("/>");
		}
		xml.append("<arbre_perso>");
		xml.append(xmlroot);
		xml.append("</arbre_perso>");
		return xml;
    }
    /**
     * Positionne les paramtres pour un retour  l'accueil
     * @throws PortalException
     */
    public void retourAccueil(ChannelRuntimeData runtimeData)throws PortalException{
        if (log.isDebugEnabled()) log.debug("CSignet2 - SignetAction::retourAccueil()f courant"+id_folder_courant);
        runtimeData.setParameter("id_folder_courant", new Integer(id_folder_courant).toString());
        if (id_book_courant!=0){
	        runtimeData.setParameter("id_book_courant", new Integer(id_book_courant).toString());
	        runtimeData.setParameter("title_book_courant", new Integer(title_book_courant).toString());
        }
        if (id_elements_copy!=null)
            runtimeData.put("id_elements_copy", id_elements_copy);
	    
        mainChannel.redirect(runtimeData, "defaultRetour");  
    }
    /**
     * Positionne les paramtres pour un retour  l'accueil
     * @throws PortalException
     */
    public void retourModif(ChannelRuntimeData runtimeData)throws PortalException{
        if (log.isDebugEnabled()) log.debug("CSignet2 - SignetAction::retourModif()f courant"+id_folder_courant);
        runtimeData.setParameter("id_folder_courant", new Integer(id_folder_courant).toString());
        if (id_book_courant!=0){
	        runtimeData.setParameter("id_book_courant", new Integer(id_book_courant).toString());
	        runtimeData.setParameter("title_book_courant", new Integer(title_book_courant).toString());
        }
        if (id_elements_copy!=null)
            runtimeData.put("id_elements_copy", id_elements_copy);
	    
        mainChannel.redirect(runtimeData, "defaultModif");  
    }
    public void dcopy(){
        if (id_elements_copy!=null){
            if (log.isDebugEnabled()) log.debug("CSignet2 - createBookMark::init() y a t il element oui");
	    if (!id_elements_copy.isEmpty())
	        if (log.isDebugEnabled()) log.debug("CSignet2 - createBookMark::init() y en a "+id_elements_copy.size());
	    else
	        if (log.isDebugEnabled()) log.debug("CSignet2 - createBookMark::init() mais c vide ");
	}
	else
	    if (log.isDebugEnabled()) log.debug("CSignet2 - createBookMark::init() y a t il element non");
	
    }
}
