/*
 * Cree le 1 sept. 2004
 * 
 * par cbissler
 * Centre de Ressources Informatiques 
 * Universit Henri Poincar 
 */
package org.esupportail.portal.channels.CSignet2.data;

import java.sql.Connection;
import java.util.*;

import org.esupportail.portal.channels.CSignet2.beans.*;
import org.esupportail.portal.channels.CSignet2.config.Config;
import org.esupportail.portal.utils.database.Query;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * DataControler<br>
 * <br>
 * controleur de donnes rediriges vers les donnes
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:celine.bissler@uhp-nancy.fr">Cline Bissler</a>
 * @version 1.1 
 */
public class DataControler {
	    
    	protected static final Log log = LogFactory.getLog(DataControler.class);
    
	    private boolean session = false;
	    private Query query = null;
	    
	    /**
	     * Constructeur
	     */
	    public DataControler() {
	    }

	    /**
	     * Dmarre une session
	     */
	    private void sessionStart() {
	    	if (log.isDebugEnabled()) log.debug("DataControler::sessionStart()");
	    	
	    	this.session = true;
	        query = Config.getInstance().getConnexionDefault();
	        
	        query.setTransactionIsolation(Connection.TRANSACTION_SERIALIZABLE);
	        query.setAutoCommit(false);
	    }

	    /**
	     * Clt une session
	     */
	    private void sessionStop() {
	    	if (log.isDebugEnabled()) log.debug("DataControler::sessionStop()");
	        query.close();
	        query = null;
	        session = false;
	        log.info("CA STOP");
	    }

	    /**
	     * Valide les oprations de la session
	     */
	    public void commit() {
	    	if (log.isDebugEnabled()) log.debug("DataControler::commit()");
	        if(session) {
	            query.commit();
	            sessionStop();
	        }
	    }
	    
	    /**
	     * Annule les oprations de la session
	     */
	    public void rollback() {
	    	if (log.isDebugEnabled()) log.debug("DataControler::rollback()");
	        if(session) {
	            query.rollback();
	            sessionStop();
	        }
	    }

	    /**
	     * Dmarre une opration
	     */
	    private void open() {
	    	if (log.isDebugEnabled()) log.debug("DataControler::open()");
	    	log.info("CA OUVRE");
	        if(!session) {
	            query = Config.getInstance().getConnexionDefault();
	        }
	    }
	    
	       

		/**
		 * Rcupration du root de l'utilisateur
		 * @param login Le login de l'utilisateur
		 * @return le bean Folder correspondant
		 */
		private Folder getRoot(String login) throws NoRootException,DataException{
		   
			if (log.isDebugEnabled()) log.debug("CSignet2 - DataControler::getRoot()");
		    DataFolder data = new DataFolder();
		    Folder f=null;
		   
		    
                try {
                    f=data.getRoot(login, query);
                 
                } catch (DataException e) {
                    if (log.isDebugEnabled()) log.debug("CSignet2 - DataControler::getRoot(): ERREUR "+e.getMessage());
                    throw new DataException();
                } catch (NoRootException e) {
                   
                    throw new NoRootException();
                }
            
		    return f;
		}
		
		/**
		 * Rcuperation de la liste des sous repertoires d'un repertoire parent
		 * @param f Le bean Folder parent
		 * @return La liste des sous-rpertoires
		 */
		private Collection getFolders(Folder f)
		{
			if (log.isDebugEnabled()) log.debug("CSignet2 - DataControler::getFolders()");
		    DataFolder data = new DataFolder();
		    Collection c=null;
		   
		    c=data.getFolders(f.getId(), query);
          
            return c;
		}
		/**
		 * Rcuperation de la liste des bookMark d'un repertoire parent
		 * @param f Le bean Folder parent
		 * @return La liste des beans BookMark correspondants
		 */
		private Collection getBookMarks(Folder f)
		{
		    
			if (log.isDebugEnabled()) log.debug("CSignet2 - DataControler::getBookMarks()");
		    DataBookMark data = new DataBookMark();
		    Collection c=null;
		   
		    c=data.getBookMarks(f.getId(), query);
          
		    return c;
		}
		/**
		 * Cration d'un bookmark
		 * @param bm le bookmark sans indentifiant et sans ordre
		 */
		public void createBookMark(BookMark bm)throws DataException
		{
			if (log.isDebugEnabled()) log.debug("DataControler::createBookMark()");
		    sessionStart();
		    DataGeneral datag = new DataGeneral();
		    bm.setId(datag.getLastId(query));
		    bm.setOrder(datag.getLastOrder(query,bm.getParent()));
		    DataBookMark data = new DataBookMark();	    
		    try {
                data.createBookMark(query,bm);
                commit();
            } catch (DataException e) {
                if (log.isDebugEnabled()) log.debug("CSignet2 - DataControler::createBookMark(): ERREUR "+e.getMessage());
                rollback();
                throw new DataException(e.getMessage());
            }
            catch(Exception exp) {
                rollback();
    	        log.fatal("CSignet2 - DataControler::createBookMark()" + exp);
    	        throw new DataException(exp.getMessage());
    	    }
           
		}
		
		/**
		 * Cration d'un dossier
		 * @param f Le bean Folder  crer sans identifiant et sans ordre
		 * @return
		 */
		public void createFolder(Folder f)throws DataException{
			if (log.isDebugEnabled()) log.debug("CSignet2 - DataControler::createFolder()");
		    sessionStart();
		    DataGeneral data = new DataGeneral();
		    f.setId(data.getLastId(query));
		    f.setOrder(data.getLastOrder(query,f.getParent()));
		    DataFolder dataf = new DataFolder();
		    try {
                dataf.CreateFolder(query,f);
                commit();
            } catch (DataException e) {
                if (log.isDebugEnabled()) log.debug("CSignet2 - DataControler::createFolder(): ERREUR "+e.getMessage());
                rollback();
                throw new DataException(e.getMessage());
            }
            catch(Exception exp) {
                rollback();
    	        log.fatal("CSignet2 - DataControler::createFolder()" + exp);
    	        throw new DataException(exp.getMessage());
    	    }
            
		}
	
		/**
		 * Modifie un BookMark
		 * @param bm Le bean BookMark  modifier
		 * @throws DataException
		 */
		public void modifyBookMark(BookMark bm)throws DataException{
			if (log.isDebugEnabled()) log.debug("CSignet2 - DataControler::modifyBookMark()");
		    sessionStart();
		    DataBookMark data = new DataBookMark();
		    try {
                data.modifyBookMark(query,bm);
                commit();
            } catch (DataException e) {
                if (log.isDebugEnabled()) log.debug( "CSignet2 - DataControler::modifyBookMark(): ERREUR "+e.getMessage());
                rollback();
                throw new DataException(e.getMessage());
            }
            catch(Exception exp) {
                rollback();
    	        log.fatal("CSignet2 - DataControler::modifyBookMark()" + exp);
    	        throw new DataException(exp.getMessage());
    	    }
            
		}
		/**
		 * Modifie un dossier
		 * @param f Le bean Folder  modifier
		 * @throws DataException
		 */
		public void modifyFolder(Folder f)throws DataException{
		    if (log.isDebugEnabled()) log.debug("CSignet2 - DataControler::modifyFolder()");
		    sessionStart();
		    DataFolder data = new DataFolder();
		    try {
                data.modifyFolder(query,f);
                commit();
            } catch (DataException e) {
                if (log.isDebugEnabled()) log.debug("CSignet2 - DataControler::modifyFolder(): ERREUR "+e.getMessage());
                rollback();
                throw new DataException(e.getMessage());
            }
            catch(Exception exp) {
                rollback();
    	        log.fatal("CSignet2 - DataControler::modifyFolder()" + exp);
    	        throw new DataException(exp.getMessage());
    	    }
       
		}
		/**
		 * Supprime un BookMark
		 * @param book Bean du bookmark  supprimer
		 * @throws DataException
		 */
		public void deleteBookMark(BookMark book)throws DataException{
		    if (log.isDebugEnabled()) log.debug("CSignet2 - DataControler::deleteBookMark()");
		    sessionStart();
		    DataBookMark data = new DataBookMark();
		    try {
                data.deleteBookMark(query,book.getId());
                
                Hashtable t=getElementsApres(book.getParent(),book.getOrder(),book.getId());
                Enumeration e=t.keys();
                //on decalle l'ordre des elements suivants
                while (e.hasMoreElements()){
                    
                    Integer i=(Integer)e.nextElement();
                    Integer o=(Integer)t.get(i);
                    modifierOrdre(i.intValue(),o.intValue()-1); 
                }
                commit();
            } catch (DataException e) {
                if (log.isDebugEnabled()) log.debug("CSignet2 - DataControler::deleteBookMark(): ERREUR "+e.getMessage());
                rollback();
                throw new DataException(e.getMessage());
            }
            catch(Exception exp) {
                rollback();
    	        log.fatal("CSignet2 - DataControler::deleteBookMark()" + exp);
    	        throw new DataException(exp.getMessage());
    	    }
           
		}
		
		/**
		 * Rcupere le bookmark
		 * @param id L'identifiant du bookmark
		 * @return La bean du BookMark correpondant
		 * @throws DataException
		 */
		public BookMark getBookMark(int id) throws DataException {
		    if (log.isDebugEnabled()) log.debug("CSignet2 - DataControler::getBookMark()");
		    sessionStart();
		    BookMark b=null;
		    DataBookMark data = new DataBookMark();
		    try {
                b=data.getBookMark(query,id);
                sessionStop();
            } catch (DataException e) {
                if (log.isDebugEnabled()) log.debug("CSignet2 - DataControler::getBookMark(): ERREUR "+e.getMessage());
                sessionStop();
                throw new DataException(e.getMessage());
            }
            catch(Exception exp) {
                sessionStop();
    	        log.fatal("CSignet2 - DataControler::getBookMark()" + exp);
    	        throw new DataException(exp.getMessage());
    	    }
            
		    return b;   
        } 
		/**
		 * Recupere le folder
		 * @param id L'identifiant du folder
		 * @return Le bean du Folder correspondant
		 * @throws DataException
		 */
		public Folder getFolder(int id) throws DataException {
		    if (log.isDebugEnabled()) log.debug("CSignet2 - DataControler::getFolder()");
		    sessionStart();
		    Folder f=null;
		    DataFolder data = new DataFolder();
		    try {
                f=data.getFolder(query,id);
                ajouterSousArbre(f);
                sessionStop();
            } catch (DataException e) {
                if (log.isDebugEnabled()) log.debug("CSignet2 - DataControler::getFolder(): ERREUR "+e.getMessage());
                sessionStop();
                throw new DataException(e.getMessage());
            }
            catch(Exception exp) {
                sessionStop();
    	        log.fatal("CSignet2 - DataControler::getFolder()" + exp);
    	        throw new DataException(exp.getMessage());
    	    }
            
		    return f;   
        } 
		/**
		 * Modifie l'ordre d'un lment 
		 * @param id Identifiant de l'lment  dplacer
		 * @param ordre Ordre initial de l'lment
		 * @throws DataException
		 */
		 private void modifierOrdre (int id,int ordre)throws DataException{
		     if (log.isDebugEnabled()) log.debug("CSignet2 - DataControler::modifierOrdre()");
		     DataGeneral data=new DataGeneral();
		     try {
	                data.modifierOrdre(query,id,ordre);
	                
	            } catch (DataException e) {
	                if (log.isDebugEnabled()) log.debug("CSignet2 - DataControler::modifierOrdre(): ERREUR "+e.getMessage());
	               
	                throw new DataException(e.getMessage());
	            }          
		    }
		 /**
		  * Rcupre l'ordre le parent et le titre d'un lment 
		  * @param id Identifiant de l'lment
		  * @return Hashtable contenant les cls ordre, parent, title
		  * @throws DataException
		  */
		 public Hashtable getOrdreParent(int id)throws DataException{
		     if (log.isDebugEnabled()) log.debug("CSignet2 - DataControler::getOrdreParent()");
		        Hashtable t=new Hashtable();
		        sessionStart();
			     DataGeneral data=new DataGeneral();
			     try {
		                t=data.getOrdreParent(query,id);
		                sessionStop();
		            } catch (DataException e) {
		                sessionStop();
		                if (log.isDebugEnabled()) log.debug("CSignet2 - DataControler::getOrdreParent(): ERREUR "+e.getMessage());
		                throw new DataException(e.getMessage());
		            }
		            catch(Exception exp) {
		                sessionStop();
		    	        log.fatal("CSignet2 - DataControler::getOrdreParent()" + exp);
		    	        throw new DataException(exp.getMessage());
		    	    }
		            
			     return(t);   
		    }
		 /**
		  * Rpupre les lments situs aprs un lment dans l'ordre
		  * @param parent Identifiant de l'lment parent
		  * @param ordreMin Ordre  partir duquel on rcupre les lments
		  * @param idOter L'lement concern  ne pas prendre en compte
		  * @return Hashtable ayant pour cl les identifiant des lments, et pour valeur leur ordre
		  * @throws DataException
		  */
		  private Hashtable getElementsApres(int parent,int ordreMin,int idOter)throws DataException{
		      if (log.isDebugEnabled()) log.debug("CSignet2 - DataControler::getElementsApres()");
			     
		        Hashtable t=new Hashtable();
		        
			     DataGeneral data=new DataGeneral();
			     try {
		                t=data.getElementsApres(query,parent,ordreMin,idOter);
		            } catch (DataException e) {
		                if (log.isDebugEnabled()) log.debug("CSignet2 - DataControler::getElementApres(): ERREUR "+e.getMessage());
		                
		                throw new DataException(e.getMessage());
		            }
		       
		        return(t);   
		    }
		  /**
		   * Rcupre l'identifiant de l'lment  partir de son ordre et de son parent
		   * @param parent Identifiant de l'lment parent
		   * @param ordre L'ordre de l'lment
		   * @return l'identifiant de l'lment
		   * @throws DataException
		   */
		   private int getElementApres(int parent,int ordre)throws DataException{
		       if (log.isDebugEnabled()) log.debug("CSignet2 - DataControler::getElementApres()");
				  
		        int t=0;
		       
			     DataGeneral data=new DataGeneral();
			     try {
		                t=data.getElementApres(query,parent,ordre);
		            } catch (DataException e) {
		                if (log.isDebugEnabled()) log.debug("CSignet2 - DataControler::getElementApres(): ERREUR "+e.getMessage());
		                
		                throw new DataException(e.getMessage());
		            }
		        
		        return(t);   
		    }
		   /**
		   * Modifier le parent d'un lment et remettre / dcaller l'ordre des autres lments
		   * @param id Identifiant de l'lment
		   * @param parent Identifiant du parent de l'lment
    	   * @throws DataException
		   */
		    private void modifierParent (int id,int parent)throws DataException{
		        if (log.isDebugEnabled()) log.debug("CSignet2 - DataControler::modifierParent()");
				  
			     DataGeneral data=new DataGeneral();
			     try {
			           
			         	int o=data.getLastOrder(query,parent);
			               
		                data.modifierParent(query,id,parent,o);
		            
			     } catch (DataException e) {
		                if (log.isDebugEnabled()) log.debug("CSignet2 - DataControler::modifierParent(): ERREUR "+e.getMessage());
		               
		                throw new DataException(e.getMessage());
		            }
		                  
			}
		    
		    /**
		     * Colle un lment dossier ou signets dans le parent
		     * @param id_element_copy L'lment coll
		     * @param id_nouv_parent Le nouveau parent
		     * @throws DataException
		     */
		    public void collerElement(int id_element_copy, int id_nouv_parent)throws DataException{
		        if (log.isDebugEnabled()) log.debug("CSignet2 - DataControler::collerElement()");
		        sessionStart();
		        try {
		            DataGeneral data=new DataGeneral();
				     
		            Hashtable o_p=data.getOrdreParent(query,id_element_copy);
                    int ordre=((Integer)o_p.get("ordre")).intValue();
                    int parent=((Integer)o_p.get("parent")).intValue();
                    modifierParent(id_element_copy,id_nouv_parent);
    
                    Hashtable t=getElementsApres(parent,ordre,id_element_copy);
                    Enumeration e=t.keys();
                    //on decalle l'ordre des elements suivants
                    while (e.hasMoreElements()){
                     
                        Integer i=(Integer)e.nextElement();
                        Integer o=(Integer)t.get(i);
                        modifierOrdre(i.intValue(),o.intValue()-1); 
                    }
                    commit();
                } catch (DataException e) {
                    if (log.isDebugEnabled()) log.debug("CSignet2 - DataControler::collerElement(): ERREUR "+e.getMessage());
                    rollback();
	                throw new DataException(e.getMessage());
                }
                catch(Exception exp) {
	    	        rollback();
	    	        log.fatal("CSignet2 - DataControler::collerElement()" + exp);
	    	        throw new DataException(exp.getMessage());
	    	    }
		    }
		    /**
		     * Permet de monter un lment
		     * @param id Identifiant de l'lment
		     * @param parent Identifiant du parent de l'lment
		     * @param ordre_elt Ordre initial de l'lment
		     * @throws DataException
		     */
		    public void monterElement(int id, int parent,int ordre_elt)throws DataException{
		        if (log.isDebugEnabled()) log.debug("CSignet2 - DataControler::monterElement()");
		        sessionStart();
		        Hashtable ordre_parent=null;
		        int decall=0;
		        try {
		            /*on recupere l'elt situ apres pour les decaller*/
		            decall=getElementApres(parent,ordre_elt-1);
		           
		            /*on change l'ordre de l'elt*/
		            modifierOrdre(id,ordre_elt-1);
		            modifierOrdre(decall,ordre_elt);
		            commit();
		           
		        } catch (DataException e) {
		            if (log.isDebugEnabled()) log.debug("CSignet2 - DataControler::monterElement(): ERREUR "+e.getMessage());
                    
		            rollback();
		            throw new DataException(e.getMessage());
		        }
		        catch(Exception exp) {
	    	        rollback();
	    	        log.fatal("CSignet2 - DataControler::monterElement()" + exp);
	    	        throw new DataException(exp.getMessage());
	    	    }
		    }
		    /**
		     * Permet de descendre un lment
		     * @param id Identifiant de l'lment
		     * @param parent Identifiant du parent de l'lment
		     * @param ordre_elt Ordre initial de l'lment
		     * @throws DataException
		     */
		    public void descendreElement(int id, int parent,int ordre_elt)throws DataException{
		        if (log.isDebugEnabled()) log.debug("CSignet2 - DataControler::descendreElement()");
		        sessionStart();
		        Hashtable ordre_parent=null;
		        int decall=0;
		        
		        try {
		            /*on recupere l'elt situ apres pour les decaller*/
		            decall=getElementApres(parent,ordre_elt+1);
		            /*on change l'ordre de l'elt*/
		            modifierOrdre(id,ordre_elt+1);
		            modifierOrdre(decall,ordre_elt);
		            commit(); 
		           
		        } catch (DataException e) {
		            if (log.isDebugEnabled()) log.debug("CSignet2 - DataControler::descendreElement(): ERREUR "+e.getMessage());
                    rollback();
		            throw new DataException(e.getMessage());
		        }
		        catch(Exception exp) {
	    	        rollback();
	    	        log.fatal("CSignet2 - DataControler::descendreElement()" + exp);
	    	        throw new DataException(exp.getMessage());
	    	    }
		    }
		    /**
		     * Permet de supprimer un dossier et ses sous lments
		     * @param folder Le bean folder  supprimer
		     * @throws DataException
		     */
		    public Vector supprimerArbre(Folder folder)throws DataException{
		        if (log.isDebugEnabled()) log.debug("CSignet2 - DataControler::supprimerArbre()");
		        sessionStart();
		        Hashtable ht=new Hashtable();
		        Vector v=new Vector();
		        //appel rcursif
	    	    try {
                    ht=supprimerSousArbre(folder,v);
                    DataFolder data = new DataFolder();
	    		    data.deleteFolder(query,folder.getId());
	    		    v=(Vector)ht.get("vector");
	    		    Hashtable tmp=new Hashtable();
	    	        tmp.put("id",new Integer(folder.getId()));
	    	        tmp.put("title",folder.getTitle());
	    	        tmp.put("type","folder");
                    v.add(tmp);
                    Hashtable t=getElementsApres(folder.getParent(),folder.getOrder(),folder.getId());
                    Enumeration e=t.keys();
                    //on decalle l'ordre des elements suivants
                    while (e.hasMoreElements()){
                        
                        Integer i=(Integer)e.nextElement();
                        Integer o=(Integer)t.get(i);
                        modifierOrdre(i.intValue(),o.intValue()-1); 
                    }
                    commit();
                } catch (DataException e) {
                    if (log.isDebugEnabled()) log.debug("CSignet2 - DataControler::supprimerArbre(): ERREUR "+e.getMessage());
                    rollback();
		            throw new DataException(e.getMessage());
                }
                catch(Exception exp) {
	    	        rollback();
	    	        log.fatal("CSignet2 - DataControler::supprimerArbre()" + exp);
	    	        throw new DataException(exp.getMessage());
	    	    }
                return v;
		    }
		    /**
		     * Fonction rcursive de parcour d'arbre de suppression
		     * @param f Le bean Folder courant
		     * @return Le Folder sans sa sous arborescence
		     */
		    private Hashtable supprimerSousArbre(Folder f,Vector v) throws DataException{
		        if (log.isDebugEnabled()) log.debug("CSignet2 - DataControler::supprimerSousArbre()");
		        if (log.isDebugEnabled()) log.debug("CSignet2 - DataControler::supprimerSousArbre() : DEBUT le sous-arbre : "+f.getTitle()+" contient : "+f.getSubFolders().size()+" sous rep"+f.getBookMarks().size()+" book");
		       
		        Iterator i=f.getSubFolders().iterator();
		        		         
		        while (i.hasNext()){
		            Folder tmp;
		            try {
		                Hashtable t=supprimerSousArbre((Folder) i.next(),v);
		                tmp=(Folder)t.get("folder");
		                v=(Vector)t.get("vector");
		                DataFolder data = new DataFolder();
		    		    data.deleteFolder(query,tmp.getId());
		    		    Hashtable sup=new Hashtable();
		    		    sup.put("id",new Integer(tmp.getId()));
		    		    sup.put("title",tmp.getTitle());
		    		    sup.put("type","folder");
		    		    v.add(sup);
		                
		            } catch (DataException e) {
		                if (log.isDebugEnabled()) log.debug("CSignet2 - DataControler::supprimerSousArbre() : crash rep dans un rep de : "+f.getTitle()+" contient : "+f.getSubFolders().size()+" sous rep"+f.getBookMarks().size()+" book");
		                if (log.isDebugEnabled()) log.debug("CSignet2 - DataControler::supprimerSousArbre(): ERREUR "+e.getMessage());
	                    throw new DataException(e.getMessage());
		            }
		        }
		       
		        if (log.isDebugEnabled()) log.debug("CSignet2 - DataControler::supprimerSousArbre() : sup books de : "+f.getTitle());
			    
		        Iterator i2=f.getBookMarks().iterator();
		        while (i2.hasNext()){
		            BookMark tmp2;
		            tmp2=(BookMark) i2.next();
		            if (log.isDebugEnabled()) log.debug("CSignet2 - DataControler::supprimerSousArbre() : sup du book : "+tmp2.getTitle());
				    
		            try {
		                DataBookMark data = new DataBookMark();
		    		    data.deleteBookMark(query,tmp2.getId());
		    		    Hashtable sup=new Hashtable();
		    		    sup.put("id",new Integer(tmp2.getId()));
		    		    sup.put("title",tmp2.getTitle());
		    		    sup.put("type","book");
		    		    v.add(sup);
		       
		            } catch (DataException e) {
		                if (log.isDebugEnabled()) log.debug("CSignet2 - DataControler::supprimerSousArbre() : crash book dans un rep de : "+f.getTitle()+" contient : "+f.getSubFolders().size()+" sous rep"+f.getBookMarks().size()+" book");
		                if (log.isDebugEnabled()) log.debug("CSignet2 - DataControler::supprimerSousArbre(): ERREUR "+e.getMessage());
	                    throw new DataException(e.getMessage());
		            }
		        }
		        if (log.isDebugEnabled()) log.debug("CSignet2 - DataControler::supprimerSousArbre() : le sous-arbre est supprim ");
		        Hashtable res=new Hashtable();
		        res.put("folder",f);
    		    res.put("vector",v);
		        return res;
		    }
		    
		    /**
		     * Rcupration de l'arbe d'un utilisateur
		     * @param login Le login de l'utilisateur
		     * @return
		     */
		    public Folder RecupererArbrePerso(String login)throws DataException{
		        if (log.isDebugEnabled()) log.debug("CSignet2 - DataControler::RecupererArbrePerso()");
		        sessionStart();
		        Folder root=new Folder();
		        
		        Collection childs=new Vector();
		       
		        
		        try {
		            root=getRoot(login);
		            root=ajouterSousArbre(root);
		            sessionStop();
		        } catch (NoRootException e) {
		            /*on cree un root perso*/
		              
		            try {
		                if (log.isDebugEnabled()) log.debug("CSignet2 - DataControler::RecupererArbrePerso() : on cr le root ");
			            root.setTitle("Mes signets");
			            root.setDescription("Ensemble des signets de "+login);
			            root.setB_root(true);
			            root.setLogin(login);
			            DataGeneral data = new DataGeneral();
			            root.setId(data.getLastId(query));
			            root.setOrder(data.getLastOrder(query,root.getParent()));
					    DataFolder dataf = new DataFolder();
					    dataf.CreateFolder(query,root);
		                commit();
		            } catch (DataException e1) {
		                rollback();
		                if (log.isDebugEnabled()) log.debug("CSignet2 - DataControler::RecupererArbrePerso(): ERREUR "+e.getMessage());
	                    throw new DataException( "Erreur lors de la creation d'un dossier personnel : "+e1.getMessage());
		            }
		            catch(Exception exp) {
		    	        rollback();
		    	        log.fatal("CSignet2 - DataControler::RecupererArbrePerso()" + exp);
		    	        throw new DataException(exp.getMessage());
		    	    }
		            
		        }
		        
		        return root;
		    }
		    
		    
		    
		    /**
		     * Fonction rcursive de parcour d'arbre des signets
		     * @param f Le bean Folder courant
		     * @return Le Folder avec sa sous arborescence
		     */
		    private Folder ajouterSousArbre(Folder f){
		        if (log.isDebugEnabled()) log.debug("CSignet2 - DataControler::ajouterSousArbre()");
		        Collection cBook=getBookMarks(f);
		        Collection cFold=getFolders(f);
		        Iterator i=cFold.iterator();
		        while (i.hasNext()){
		            Folder tmp;
		            tmp=ajouterSousArbre((Folder) i.next());
		            f.addSubFolder(tmp);
		        }
		        f.setBookMarks(cBook);
		        
		        return f;
		    }
		    
		    
		    /**
		     * Enregistre un arbre complet lors du chargement de fichiers de bookmark
		     * @param folder Le bean Folder racine
		     * @throws DataException
		     */	    
		    public void enregisterArbre(Folder folder)throws DataException{
		    if (log.isDebugEnabled()) log.debug("CSignet2 - DataControler::enregisterArbre()");
		            
	        sessionStart();
	        if (log.isDebugEnabled()) log.debug("SUPP debut session");
	        
	        //appel rcursif
    	    try {
    	        DataGeneral data = new DataGeneral();
    		    folder.setId(data.getLastId(query));
    		    folder.setOrder(data.getLastOrder(query,folder.getParent()));
    		    DataFolder dataf = new DataFolder();
    		    dataf.CreateFolder(query,folder);
    	       
    		    if (log.isDebugEnabled()) log.debug("CSignet2 - on ENREGISTRE");
	            Iterator i = folder.getSubFolders().iterator();
	            while (i.hasNext()){
	                 enregistrerFolder((Folder)i.next(),folder.getId());
	            }
	            
	            Iterator i2 = folder.getBookMarks().iterator();
	            while (i2.hasNext()){
	                enregistrerBookmark((BookMark)i2.next(),folder.getId());    
	            }
                commit();
            } catch (DataException e) {
                if (log.isDebugEnabled()) log.debug("CSignet2 - DataControler::enregisterArbre(): ERREUR "+e.getMessage());
                rollback();
	            throw new DataException(e.getMessage());
            }
            catch(Exception exp) {
    	        rollback();
    	        log.fatal("CSignet2 - DataControler::enregisterArbre()" + exp);
    	        throw new DataException(exp.getMessage());
    	    }
	    }
		    /**
		     * Enregistrement d'un rpertoire lu et pars
		     * @param f Le bean Folder courant
		     * @param parent L'identifiant du parent
		     * @throws DataException
		     */
		    private void enregistrerFolder(Folder f,int parent) throws DataException{
		        if (log.isDebugEnabled()) log.debug("CSignet2 - DataControler::enregistrerFolder()");
		            f.setParent(parent);
		           
		            try {
		                DataGeneral data = new DataGeneral();
		    		    f.setId(data.getLastId(query));
		    		  
		    		    DataFolder dataf = new DataFolder();
		    		    dataf.CreateFolder(query,f);
                        Iterator i = f.getSubFolders().iterator();
                        while (i.hasNext()){
                             enregistrerFolder((Folder)i.next(),f.getId());
                        }
                    } catch (DataException e) {
                        if (log.isDebugEnabled()) log.debug("CSignet2 - DataControler::enregistrerFolder(): ERREUR "+e.getMessage());
                        throw new DataException(e.getMessage());
                    }
		            
		            try {
                        Iterator i2 = f.getBookMarks().iterator();
                        while (i2.hasNext()){
                            enregistrerBookmark((BookMark)i2.next(),f.getId());    
                        }
                      
                    } catch (DataException e1) {
                        if (log.isDebugEnabled()) log.debug("CSignet2 - DataControler::enregistrerFolder(): ERREUR "+e1.getMessage());
                        throw new DataException(e1.getMessage());
                    }
		        
		    }
		    /**
		     * Enregistrement d'un signet lu et pars
		     * @param b Le bean BookMark  enregistrer
		     * @param parent L'identifiant du parent
		     * @throws DataException
		     */
		    private void enregistrerBookmark(BookMark b,int parent)throws DataException{
		        if (log.isDebugEnabled()) log.debug("CSignet2 - DataControler::enregistrerBookmark()");
		        b.setParent(parent);
		       
		        try {
		            DataGeneral datag = new DataGeneral();
				    b.setId(datag.getLastId(query));
				    DataBookMark data = new DataBookMark();	    
				    data.createBookMark(query,b);
                } catch (DataException e) {
                    if (log.isDebugEnabled()) log.debug("CSignet2 - DataControler::enregistrerBookmark(): ERREUR "+e.getMessage());
                    throw new DataException(e.getMessage());
                }
                
		    }
		    protected void finalize() throws Throwable {
		        super.finalize();
		        if(query != null) {
		            log.error("DataControler::finalize() : Des connexions n'ont pas \u00E9t\u00E9 ferm\u00E9es");
		            query.close();
		        }
		       
		    }

}
