/**
 * Copyright  2004 ESUP-portail consortium
 * Authors : Doriane.Dusart@univ-valenciennes.fr
 * This program is free software; you can redistribute 
 * it and/or modify it under the terms of the GNU 
 * General Public License as published by the Free 
 * Software Foundation augmented according to the
 * possibility of using it with programs developped under 
 * the Apache licence published by the Apache Software Foundation.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 *  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 *  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY 
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE 
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 * See the license terms site for more details : 
 * http://www.esup-portail.org/license.html
 */
package org.esupportail.portal.channels.CSignetCerimes;

import java.io.StringWriter;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CSignetCerimes.Digester.PropertiesManager;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.ChannelRuntimeProperties;
import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.IChannel;
import org.jasig.portal.PortalEvent;
import org.jasig.portal.PortalException;
import org.jasig.portal.utils.XSLT;
import org.xml.sax.ContentHandler;




/**
 * Description :<br/>
 * 
 * @version $Id : CSignetsBu.java, V1.0, 23 nov. 2004<br/>
 * Copyright (c) 2004 Esup Portail (www.esup-portail.org)<br/>
 * Classe(s) : CSignetsBu.java<br/>
 */
public class CSignetCerimes implements IChannel {
	/*
	 * Proprit pour les logs
	 */
	private static final Log log = LogFactory.getLog(CSignetCerimes.class);
	/*
	 * Proprit pour le portail
	 */
	 ChannelStaticData staticData = null ;
	 ChannelRuntimeData runtimeData = null ;
	 private static final String sslLocation = "CSignetCerimes.ssl" ;
	 
	 /*
	  * Proprit pour les configurations
	  */
	 private final String _configurationFile = "/properties/channels/org_esup/CSignetCerimes/CSignetCerimes.xml" ;	
	 private SoapConnection _connexion;
	  
	/* (non-Javadoc)
	 * @see org.jasig.portal.IChannel#setStaticData(org.jasig.portal.ChannelStaticData)
	 */
	public void setStaticData(ChannelStaticData sd) throws PortalException {
		// TODO Auto-generated method stub
		this.staticData = sd ;
		
		PropertiesManager _prop = PropertiesManager.getInstance(_configurationFile);
		String soapUrl = _prop.getSoapUrl();
		
		this._connexion = SoapConnection.getInstance(soapUrl);
		
	}

	/* (non-Javadoc)
	 * @see org.jasig.portal.IChannel#setRuntimeData(org.jasig.portal.ChannelRuntimeData)
	 */
	public void setRuntimeData(ChannelRuntimeData rd) throws PortalException {
		// TODO Auto-generated method stub
		 this.runtimeData = rd ;      
	}

	/* (non-Javadoc)
	 * @see org.jasig.portal.IChannel#receiveEvent(org.jasig.portal.PortalEvent)
	 */
	public void receiveEvent(PortalEvent arg0) {
		// TODO Auto-generated method stub
		
	}

	/* (non-Javadoc)
	 * @see org.jasig.portal.IChannel#getRuntimeProperties()
	 */
	public ChannelRuntimeProperties getRuntimeProperties() {
		// TODO Auto-generated method stub
		return new ChannelRuntimeProperties() ;
	}

	/* (non-Javadoc)
	 * @see org.jasig.portal.IChannel#renderXML(org.xml.sax.ContentHandler)
	 */
	public void renderXML(ContentHandler out) throws PortalException {
		// TODO Auto-generated method stub
		String titre = runtimeData.getParameter("titre"); 
		String action =  runtimeData.getParameter("action"); 
		
		XSLT xslt = null ;
		
		StringWriter w = new StringWriter() ;
	    w.write( "<?xml version='1.0'?>\n" );
	    
	    if((action==null)||(!action.equals("recherche"))){
           	w.write( "<content/>\n" );
        	xslt = new XSLT( this );
        	xslt.setStylesheetParameter("baseActionURL",runtimeData.getBaseActionURL());
        	xslt.setXML( w.toString() );
        	xslt.setXSL( sslLocation , "first" , runtimeData.getBrowserInfo() ) ;
        	xslt.setTarget( out ) ;
        	xslt.transform() ;

       }
        else{
        	w.write( "<content>\n" );
        	if(this._connexion!=null){
               	String retour = "";
                retour = this._connexion.getSignet(titre);	    
	         	if(retour==null){
	         		w.write("<erreur>RETOUR_NULL</erreur>");
	         	}
	         	else{
	        		log.debug(retour);
	         		String [] ListeSignets = retour.split("<br />");
	         		
	         		for(int i=0; i<ListeSignets.length-1;i++){
	         			String[] result = ListeSignets[i].split("http://");
	         			w.write("<signet>");
	         			w.write("<nom>"+result[0]+"</nom>");
	         			w.write("<url>"+result[1].replaceAll("&","&amp;")+"</url>");
	    				w.write("</signet>");
	    			}
	         	}
        	}
        	else w.write("<erreur>CONNEXION_NULL</erreur>");
	        w.write( "</content>" );
	        xslt = new XSLT( this );
	        xslt.setStylesheetParameter("baseActionURL",runtimeData.getBaseActionURL());
	        xslt.setXML( w.toString() );
	        xslt.setXSL( sslLocation , "main" , runtimeData.getBrowserInfo() ) ;
	        xslt.setTarget( out ) ;
	        xslt.transform() ;
         }
	}
		
}
