/**
 * Copyright  2004 ESUP-portail consortium
 * Authors : Doriane.Dusart@univ-valenciennes.fr
 * This program is free software; you can redistribute 
 * it and/or modify it under the terms of the GNU 
 * General Public License as published by the Free 
 * Software Foundation augmented according to the
 * possibility of using it with programs developped under 
 * the Apache licence published by the Apache Software Foundation.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 *  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 *  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY 
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE 
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 * See the license terms site for more details : 
 * http://www.esup-portail.org/license.html
 */
package org.esupportail.portal.channels.CSignetCerimes.Digester;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


/**
 * Description :<br/>
 * 
 * @version $Id : PropertiesManager.java, V1.0, 11 avr. 2005<br/>
 * Copyright (c) 2004 Esup Portail (www.esup-portail.org)<br/>
 * Classe(s) : PropertiesManager.java<br/>
 */
public class PropertiesManager {
	/*
	 * Proprit pour les logs
	 */
	private static final Log log = LogFactory.getLog(PropertiesManager.class);
	private String soapUrl;
	private static PropertiesManager singleton = null ;
	
	/**
	 * @param properties_file_name
	 */
	public PropertiesManager(String properties_file_name) {
		SignetCerimesServices signetcerimes = null ;
      	SignetCerimesUtils conf = null ;
        signetcerimes = SignetCerimesServices.getInstance( properties_file_name ) ;
        conf = signetcerimes.getInfos() ;
        this.soapUrl = conf.getSoapUrl() ;
        log.debug("PropertiesManager properties_file_name = "+properties_file_name);
        log.debug("PropertiesManager soapUrl = "+this.soapUrl);
	}
	/**
	 * Permet de grer l'instance de la classe.
	 * @return Une instance de cette classe
	 */
       public static PropertiesManager getInstance( String fichier ) {
        if( singleton == null ) {
            singleton = new PropertiesManager( fichier ) ;
         }
         return singleton ;
      }
	/**
	 * @return Returns the soapUrl.
	 */
	public String getSoapUrl() {
		return soapUrl;
	}
	/**
	 * @param soapUrl The soapUrl to set.
	 */
	public void setSoapUrl(String soapUrl) {
		this.soapUrl = soapUrl;
	}			
}
