/**
 * Copyright  2004 ESUP-portail consortium
 * Authors : Doriane.Dusart@univ-valenciennes.fr
 * This program is free software; you can redistribute 
 * it and/or modify it under the terms of the GNU 
 * General Public License as published by the Free 
 * Software Foundation augmented according to the
 * possibility of using it with programs developped under 
 * the Apache licence published by the Apache Software Foundation.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 *  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 *  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY 
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE 
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 * See the license terms site for more details : 
 * http://www.esup-portail.org/license.html
 */
package org.esupportail.portal.channels.CSignetCerimes.Digester;

import org.apache.commons.digester.Digester ;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


/**
 * Description :<br/>
 * 
 * @version $Id : SignetCerimesServices.java, V1.0, 11 avr. 2005<br/>
 * Copyright (c) 2004 Esup Portail (www.esup-portail.org)<br/>
 * Classe(s) : SignetCerimesServices.java<br/>
 */
public class SignetCerimesServices {
	/*
	 * Proprit pour les logs
	 */
	private static final Log log = LogFactory.getLog(SignetCerimesServices.class);
	private static SignetCerimesServices singleton = null ;
	private SignetCerimesUtils confs ;
	    
	/** 
	 * Constructeur priv de la classe pour instanciation de celle-ci.
	 * @param fichier Le fichier de configuration du canal RechecheBu.
	 */
	private SignetCerimesServices( String fichier ) {
	   confs = getSignetCerimesConf( fichier ) ;
	   log.debug("SignetCerimesServices fichier = "+fichier);
	}
	/**
	 * Permet de grer l'instance de la classe.
	 * @return Une instance de cette classe
	 */
       public static SignetCerimesServices getInstance( String fichier ) {
        if( singleton == null ) {
            singleton = new SignetCerimesServices( fichier ) ;
        }
         return singleton ;
      }
       /**
      	 * Cette mthode permet de dclarer un Digester correspondant  la structure<br/>
      	 * du fichier de configuration du canal.
      	 * @param fichier Le fichier de configuration du canal RechercheBuServices.
      	 * @return Un bean contenant les informations du fichier de configuration.
      	 */
             private SignetCerimesUtils getSignetCerimesConf( String fichier ) {
               SignetCerimesUtils infos = null ;
               Digester dig = null ;
               String path = null ;
            
               try
               {
                  dig = new Digester() ;
                  dig.setValidating( false ) ;
                  dig.addObjectCreate( "CSignetCerimes" , "org.esupportail.portal.channels.CSignetCerimes.Digester.SignetCerimesUtils" ) ;
               	
              	
                  dig.addBeanPropertySetter( "CSignetCerimes/soapUrl" , "soapUrl" ) ;
                 
                  path = this.getClass().getResource( fichier ).getFile() ;
                  path =  path.replaceAll( " " , "%20" ) ;
                  infos = (SignetCerimesUtils) dig.parse( path ) ;
                  log.debug("CSignetCerimes : path : " + path ) ;
                  return infos ;
               }
                   catch( java.io.IOException ioe ) {
                   	log.error("CSignetCerimes : ioexception : " + ioe ) ;
                     return infos ;
                  }
                   catch( org.xml.sax.SAXException se ) {
                   	log.error("CSignetCerimes : saxexception : " + se ) ;
                     return infos ;
                  }
                   catch( Exception e ) {
                   	log.error("CSignetCerimes : " +e ) ;                  
                     return infos ;
                  }
            }
            
         	/**
         	 * Cette mthode permet de rcupurer les informations contenues<br/>
         	 * dans le fichier de configuration du canal.
         	 * @return Les informations formates sur forme d'un bean.
         	 */
             public SignetCerimesUtils getInfos() {
             	log.debug(confs);
               return confs ;
            }         
   }
