/**
 * Copyright  2004 ESUP-portail consortium
 * Authors : Doriane.Dusart@univ-valenciennes.fr
 * This program is free software; you can redistribute 
 * it and/or modify it under the terms of the GNU 
 * General Public License as published by the Free 
 * Software Foundation augmented according to the
 * possibility of using it with programs developped under 
 * the Apache licence published by the Apache Software Foundation.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 *  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 *  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY 
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE 
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 * See the license terms site for more details : 
 * http://www.esup-portail.org/license.html
 */
package org.esupportail.portal.channels.CSignetCerimes;

import java.net.URL;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import fr.education.cerimes.client.Signetswsdl;
import fr.education.cerimes.client.SignetswsdlLocator;
import fr.education.cerimes.client.SignetswsdlPortType;

/**
 * Description :<br/>
 * 
 * @version $Id : SoapConnection.java, V1.0, 11 avr. 2005<br/>
 * Copyright (c) 2004 Esup Portail (www.esup-portail.org)<br/>
 * Classe(s) : SoapConnection<br/>
 */
public class SoapConnection {
	private static final Log log = LogFactory.getLog(SoapConnection.class);	
	private static SoapConnection singleton = null;
	/*
	  * Proprit pour le service web
	  */
	 SignetswsdlPortType _service;
	 
	public SoapConnection(String soapurl){
		_service = getConnection(soapurl);
	}
	/**
	 * Permet de grer l'instance de la classe.
	 * @return Une instance de cette classe
	 */
   public static SoapConnection getInstance(String soapurl) {
        if( singleton == null ) {
            singleton = new SoapConnection(soapurl) ;
         }
         return singleton ;
   }
   
   private SignetswsdlPortType getConnection(String soapurl){
   	try{
		Signetswsdl locator = new SignetswsdlLocator();
		SignetswsdlPortType service = locator.getsignetswsdlPort(new URL(soapurl));		
		return service;
	}
	catch(Exception e){
		log.error("CSignetCerimes : erreur lors de la localisation du service: "+e);
		return null;
	}
   }
   /**
    * Resultat de l'interrogation du service
    * @param discipline
    * @return
    */
   public String getSignet(String discipline){
   	try{
   		return this._service.signets(discipline);
   	}
   	catch(java.rmi.RemoteException re){
		log.error("CSignetCerimes : erreur lors de l'interrogation du service pour la discipline: "+discipline +". Retour erreur = "+ re);
		return null;
	}
   }
}
