/*
ESUP-portail is a french academic project developed under the GPL (General Public License) augmented according to the following :
A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.
The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .
A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .
The different kinds of licenses governing the products developed by the Apache foundation can be found here : http://www.apache.org/licenses .
It follows that you can as well as use download contents as well modify and redistribute them provided you respect the GPL terms.
Downloading and using such contents do not provide any guaranty.
Be sure that you have well understood the terms of the license before using the contents it covers.
The ESUP-portail distribution includes the following distributions :
    * UPortal : 
      software developed by JA-SIG (Java Architecture - Special Interest Group)
      You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html
    * CAS :
      SSO solution developed by Yale University
      You can find the project page here : http://www.yale.edu/tp/auth
    * Cocoon :
      XML framework distributed by the Apache foundation under Apache license;
      Please find the full text here : http://cocoon.apache.org/2.1/license.html
    * Mod_dav:
      A DAV module for Apache web server
      You can find the project page here : http://www.webdav.org/mod_dav
    * IMP :
      webmail from Horde application framework
      You can find the project page here : http://www.horde.org
    * . To be completed
*/
package org.esupportail.portal.channels.CStockage.channelAction.injac;


/**
 * Id: InjacConstants.java,v 1.0<br/>
 * Copyright (c) 2004 Esup Portail (www.esup-portail.org)<br/>
 * Classes: InjacConstants<br/>
 * Original Author: s.Gaudin<br/>
 * this class regroup all constants of an injac action in the channel<br/>
 */


public class InjacConstants {
	
	
	/**
	 * Mod which create inteface to set the new space name
	 */
	public static final String SET_NAME_FOR_CREATE_SPACE_MODE = "set_name_for_create_space_mode";

	/**
	 * Mod which create a space
	 */
	public static final String CREATE_SPACE_MODE = "create_space_mode";
	
	
	
	
	
	/**
	 * Admin a space in injac
	 */
	public static final String ADMIN_SPACE_MODE = "admin_space_mode";
	
	
	/**
	 * Valid the servant channel results
	 */
	public static final String VALID_SERVANT_RESULTS = "valid_servant_results";
	
	
	
	
	
	
	
	/**
	 * Metadata on an injac document
	 */
	public static final String SET_METADATA_ON_DOCUMENT_MODE = "set_metadata_on_document_mode";
	
	
	
	
	
	/**
	 * Confirm if we submit a document
	 */
	public static final String CONFIRM_SUBMIT_MODE = "confirm_submit_mode";
	
	/**
	 * Submit a document
	 */
	public static final String SUBMIT_MODE = "submit_mode";
	
		
	
	

	
	/**
	 * Confirm if we publish a document
	 */
	public static final String CONFIRM_PUBLISH_MODE = "confirm_publish_mode";
	
	/**
	 * Publish a document
	 */
	public static final String PUBLISH_MODE = "publish_mode";
	
	
	
	

	
	/**
	 * Confirm if we unpublish a document
	 */
	public static final String CONFIRM_UNPUBLISH_MODE = "confirm_unpublish_mode";
	
	/**
	 * Unpublish a document
	 */
	public static final String UNPUBLISH_MODE = "unpublish_mode";
	
	
	

	
	/**
	 * Confirm if we reject a document
	 */
	public static final String CONFIRM_REJECT_MODE = "confirm_reject_mode";
	
	/**
	 * Reject a document
	 */
	public static final String REJECT_MODE = "reject_mode";
	
}
