/*
ESUP-portail is a french academic project developed under the GPL (General Public License) augmented according to the following :
A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.
The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .
A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .
The different kinds of licenses governing the products developed by the Apache foundation can be found here : http://www.apache.org/licenses .
It follows that you can as well as use download contents as well modify and redistribute them provided you respect the GPL terms.
Downloading and using such contents do not provide any guaranty.
Be sure that you have well understood the terms of the license before using the contents it covers.
The ESUP-portail distribution includes the following distributions :
    * UPortal :
      software developed by JA-SIG (Java Architecture - Special Interest Group)
      You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html
    * CAS :
      SSO solution developed by Yale University
      You can find the project page here : http://www.yale.edu/tp/auth
    * Cocoon :
      XML framework distributed by the Apache foundation under Apache license;
      Please find the full text here : http://cocoon.apache.org/2.1/license.html
    * Mod_dav:
      A DAV module for Apache web server
      You can find the project page here : http://www.webdav.org/mod_dav
    * IMP :
      webmail from Horde application framework
      You can find the project page here : http://www.horde.org
    * . To be completed
*/

package org.esupportail.portal.channels.CStockage.channelAction.injac.config;



import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;

import org.apache.commons.digester.Digester;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CStockage.exception.PropertiesException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;


/**
 * Id: InjacConfig.java,v 1.0<br/>
 * Copyright (c) 2004 Esup Portail (www.esup-portail.org)<br/>
 * Classes: InjacConfig<br/>
 * Original Author: Yohan Colmant<br/>
 * This class parse the injac.xml config file to return all parameters<br/>
 */
public class InjacConfig { 
	

	/**
	 * Logger object
	 */
	protected static final Log log = LogFactory.getLog(InjacConfig.class);
	
	
	public static InjacConfig singleton = null;
	
	/*spaces*/
	private String url;
	private ArrayList metadataProfiles = new ArrayList();
	private ArrayList renderingTypes = new ArrayList();


	/*path of the config file*/
	private String configFilePath ="/properties/channels/org_esup/CStockage/injac/injac.xml";
	
	
	
	/**
	 * Used as a singleton for the injac config
	 * @return a singleton for the injac config
	 * @throws PropertiesException
	 */
	public static InjacConfig getInstance() throws PropertiesException {
		if (singleton==null)
			singleton = new InjacConfig();
		return singleton;
	}
	
	
	
	/**
	 * Constructor
	 */
	public InjacConfig() throws PropertiesException {

		Digester digester = new Digester();
		digester.setValidating(false);
		digester.push(this);
						
		
		
		/*
		 * The profiles
		 */
		digester.addObjectCreate("INJAC/METADATA_PROFILES/METADATA_PROFILE","org.esupportail.portal.channels.CStockage.channelAction.injac.config.MetadataFileProfile");		
		
		digester.addSetProperties( "INJAC/METADATA_PROFILES/METADATA_PROFILE","fileName","fileName");		
		digester.addSetProperties("INJAC/METADATA_PROFILES/METADATA_PROFILE","label", "label");		
		
		digester.addSetNext("INJAC/METADATA_PROFILES/METADATA_PROFILE", "setMetadataProfiles");
		
		
		
		digester.addObjectCreate("INJAC/RENDERINGS/RENDERING","org.esupportail.portal.channels.CStockage.channelAction.injac.config.RenderingType");		
		
		digester.addSetProperties( "INJAC/RENDERINGS/RENDERING","url","url");		
		digester.addSetProperties("INJAC/RENDERINGS/RENDERING","label", "label");		
		
		digester.addSetNext("INJAC/RENDERINGS/RENDERING", "setRenderingTypes");
		
		
		URL url = InjacConfig.class.getResource(configFilePath);		
		
		if (url != null) {

			InputSource inSource = new InputSource(url.toExternalForm());

			try {
				//parse config file
				digester.parse(inSource);							
			}
			catch (IOException e) {				
				log.error("InjacConfig :: Unable to open config file" + configFilePath	+" "+ e.toString());
				throw new PropertiesException();
			}
			catch (SAXException e) {				
				log.error("InjacConfig :: " + e.toString());
				throw new PropertiesException();
			}
		}
		else { 
			log.error("InjacConfig :: "	+ configFilePath + " does not exist.\n");
			throw new PropertiesException();
		}
	}
	
	
	/**
	 * return the metadataProfiles list
	 * @return the metadataProfiles list
	 */
	public ArrayList getMetadataProfiles() throws PropertiesException {		
		if (metadataProfiles.size()==0) {
			log.error("getMetadataProfiles :: there is no metadata profile");
			throw new PropertiesException();
		}
		
		for (int i=0; i<metadataProfiles.size(); i++) {
			MetadataFileProfile metadataProfile = (MetadataFileProfile)metadataProfiles.get(i);
			String fileName = metadataProfile.getFileName();		
			String path = "/properties/channels/org_esup/CStockage/injac/metadata/";
			String filePath = path+fileName;			
			URL url = InjacConfig.class.getResource(filePath);
			if (url == null) {
				metadataProfiles.remove(i);
				i--;				
			}
		}
		
		if (metadataProfiles.size()==0) {
			log.error("getMetadataProfiles :: the is no valid metadata profile");
			throw new PropertiesException();
		}
		
		return metadataProfiles;
	}

	/**
	 * add a new metadataProfile to the list
	 * @param metadataProfile the metadataProfile to add
	 */
	public void setMetadataProfiles(MetadataFileProfile metadataProfile) {
		metadataProfiles.add(metadataProfile);
	}
	
	
	
	

	/**
	 * return the renderingTypes list
	 * @return the renderingTypes list
	 */
	public ArrayList getRenderingTypes() throws PropertiesException {		
		if (renderingTypes.size()==0) {
			log.error("getRenderingTypes :: there is no valid rendering type");
			throw new PropertiesException();
		}
		
		else return renderingTypes;		
	}

	/**
	 * add a new renderingType to the list
	 * @param renderingType the renderingType to add
	 */
	public void setRenderingTypes(RenderingType renderingType) {
		renderingTypes.add(renderingType);
	}
	
	
}
