/*
ESUP-portail is a french academic project developed under the GPL (General Public License) augmented according to the following :
A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.
The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .
A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .
The different kinds of licenses governing the products developed by the Apache foundation can be found here : http://www.apache.org/licenses .
It follows that you can as well as use download contents as well modify and redistribute them provided you respect the GPL terms.
Downloading and using such contents do not provide any guaranty.
Be sure that you have well understood the terms of the license before using the contents it covers.
The ESUP-portail distribution includes the following distributions :
    * UPortal :
      software developed by JA-SIG (Java Architecture - Special Interest Group)
      You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html
    * CAS :
      SSO solution developed by Yale University
      You can find the project page here : http://www.yale.edu/tp/auth
    * Cocoon :
      XML framework distributed by the Apache foundation under Apache license;
      Please find the full text here : http://cocoon.apache.org/2.1/license.html
    * Mod_dav:
      A DAV module for Apache web server
      You can find the project page here : http://www.webdav.org/mod_dav
    * IMP :
      webmail from Horde application framework
      You can find the project page here : http://www.horde.org
    * . To be completed
*/

package org.esupportail.portal.channels.CStockage.channelAction.injac.metadata.parse;


import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;

import org.apache.commons.digester.Digester;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CStockage.exception.ApplicationException;
import org.xml.sax.SAXException;



/**
 * Id: ParseRequiredMetaData.java,v 1.0<br/>
 * Copyright (c) 2004 Esup Portail (www.esup-portail.org)<br/>
 * Classes: ParseRequiredMetaData<br/>
 * Original Author: Yohan Colmant<br/>
 * This class parse the metadata containing all metadata the user have to set<br/>
 */
public class ParseRequiredMetaData { 
	

	/**
	 * Logger object
	 */
	protected static final Log log = LogFactory.getLog(ParseRequiredMetaData.class);
	
	
	
	
	/**
	 * The key of this metadata list
	 */
	private String key;
	
	
	
	/**
	 * All metadata for edition and publication
	 */
	private ArrayList metadataList = new ArrayList();
	
	
	
	
	/**
	 * Constructor
	 * @param stringToParse the xml we have to parse contained in this String
	 * @throws ApplicationException
	 */
	public ParseRequiredMetaData(String stringToParse) throws ApplicationException {

		Digester digester = new Digester();
		digester.setValidating(false);
		digester.push(this);
		
		digester.setNamespaceAware(true);
		
		/*
		 * The server
		 */
		digester.addCallMethod("metas", "setKey", 1);
		digester.addCallParam("metas", 0, "key");		
		
		/*
		 * The spaces
		 */
		digester.addObjectCreate("metas/meta","org.esupportail.portal.channels.CStockage.channelAction.injac.metadata.parse.RequiredMetaData");		
		
		digester.addSetProperties( "metas/meta","name","name");		
		digester.addSetProperties( "metas/meta","label","label");
		digester.addSetProperties( "metas/meta","input","input");
		digester.addSetProperties( "metas/meta","type","type");
		digester.addSetProperties( "metas/meta","choiceList","choicelist");
		digester.addSetProperties( "metas/meta","required","requiredData");
		digester.addSetProperties( "metas/meta","level","level");
		digester.addSetProperties( "metas/meta","defaultValue","value");
		digester.addSetProperties( "metas/meta","comment","comment");
		digester.addSetProperties( "metas/meta","format","format");
		
		digester.addSetNext("metas/meta", "setMetadataList");
		
		
		try {
			//parse config file
			digester.parse(new StringReader(stringToParse));							
		}
		catch (IOException e) {			
			log.error("ParseRequiredMetaData :: "+ e.toString());
			throw new ApplicationException();
		}
		catch (SAXException e) {				
			log.error("ParseRequiredMetaData :: " + e.toString());
			throw new ApplicationException();
		}
				
	}
	
	
	/**
	 * return the metadataList for edition
	 * @return the metadataList for edition
	 */
	public ArrayList getMetadataListEdition() {		
		
		for (int i=0; i<metadataList.size(); i++) {
			RequiredMetaData md = (RequiredMetaData)metadataList.get(i);
			if (md.getLevel().equals(RequiredMetaData.LEVEL_PUBLICATION)) {				
				md.setModifiable(false);				
			}
		}
		
		return metadataList;
	}
	
	/**
	 * return the metadataList for publication
	 * @return the metadataList for publication
	 */
	public ArrayList getMetadataListPublication() {		
		
		for (int i=0; i<metadataList.size(); i++) {
			RequiredMetaData md = (RequiredMetaData)metadataList.get(i);
			if (md.getLevel().equals(RequiredMetaData.LEVEL_EDITION)) {			
				md.setModifiable(false);				
			}
		}
		
		return metadataList;
	}

	
	/**
	 * return the metadataList for edition and publication
	 * @return the metadataList for edition and publication
	 */
	public ArrayList getMetadataListEditionAndPublication() {		
		return metadataList;
	}

	


	/**
	 * add a new MD to the list
	 * @param metadata the space to add
	 */
	public void setMetadataList(RequiredMetaData metadata) {
		metadataList.add(metadata);
	}
		
	
	/**
	 * @return Returns the url.
	 */
	public String getKey() {		
		return key;
	}
	
	/**
	 * @param key The key to set.
	 */
	public void setKey(String key) {
		this.key = key; 
	}
	
	
	
	
}
