/*
ESUP-portail is a french academic project developed under the GPL (General Public License) augmented according to the following :
A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.
The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .
A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .
The different kinds of licenses governing the products developed by the Apache foundation can be found here : http://www.apache.org/licenses .
It follows that you can as well as use download contents as well modify and redistribute them provided you respect the GPL terms.
Downloading and using such contents do not provide any guaranty.
Be sure that you have well understood the terms of the license before using the contents it covers.
The ESUP-portail distribution includes the following distributions :
    * UPortal :
      software developed by JA-SIG (Java Architecture - Special Interest Group)
      You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html
    * CAS :
      SSO solution developed by Yale University
      You can find the project page here : http://www.yale.edu/tp/auth
    * Cocoon :
      XML framework distributed by the Apache foundation under Apache license;
      Please find the full text here : http://cocoon.apache.org/2.1/license.html
    * Mod_dav:
      A DAV module for Apache web server
      You can find the project page here : http://www.webdav.org/mod_dav
    * IMP :
      webmail from Horde application framework
      You can find the project page here : http://www.horde.org
    * . To be completed
*/

package org.esupportail.portal.channels.CStockage.exception;

/**
 * Id: ChannelException.java,v 1.0 13 mai 2004<br/>
 * Copyright (c) 2004 Esup Portail (www.esup-portail.org)<br/>
 * Classes: ChannelException<br/>
 * Original Author: Yohan Colmant<br/>
 * An abstract exception<br/>
 */
public class ChannelException extends Exception {
	
	/**
	 * The error code associated to this exception
	 */
	private int errorCode; 
	
	/**
	 * The HTTP error code
	 */
	private int httpErrorCode;	
	
	
	/**
	 * Constructor
	 */
	public ChannelException() {
		super();
		this.errorCode = -1;
		this.httpErrorCode = -1;
	}
	
	/**
	 * Constructor
	 * @param errorCode the errorCode associate to this exception
	 */
	public ChannelException(int errorCode) {
		super();
		this.errorCode = errorCode;
		this.httpErrorCode = -1;
	}
	
	/**
	 * Constructor
	 * @param errorCode the errorCode associate to this exception
	 * @param httpErrorCode the errorCode associate to this exception
	 */
	public ChannelException(int errorCode, int httpErrorCode) {
		super();
		this.errorCode = errorCode;
		this.httpErrorCode = httpErrorCode;
	}
	
	/**
	 * Return the error code associated to this exception
	 * @return the error code
	 */
	public int getErrorCode() {
		return errorCode;
	}
	
	/**
	 * Return the http error code return by the webdav
	 * @return the http error code
	 */
	public int getHttpErrorCode() {
		return httpErrorCode;
	}
	
	/**
	 * Return a string form of this exception
	 */
	public String toString() {
		return this.getClass().getName()+" application error code: "+errorCode+", http error code"+httpErrorCode;
	}
	
}
