/*
ESUP-portail is a french academic project developed under the GPL (General Public License) augmented according to the following :
A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.
The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .
A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .
The different kinds of licenses governing the products developed by the Apache foundation can be found here : http://www.apache.org/licenses .
It follows that you can as well as use download contents as well modify and redistribute them provided you respect the GPL terms.
Downloading and using such contents do not provide any guaranty.
Be sure that you have well understood the terms of the license before using the contents it covers.
The ESUP-portail distribution includes the following distributions :
    * UPortal :
      software developed by JA-SIG (Java Architecture - Special Interest Group)
      You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html
    * CAS :
      SSO solution developed by Yale University
      You can find the project page here : http://www.yale.edu/tp/auth
    * Cocoon :
      XML framework distributed by the Apache foundation under Apache license;
      Please find the full text here : http://cocoon.apache.org/2.1/license.html
    * Mod_dav:
      A DAV module for Apache web server
      You can find the project page here : http://www.webdav.org/mod_dav
    * IMP :
      webmail from Horde application framework
      You can find the project page here : http://www.horde.org
    * . To be completed
*/
  
package org.esupportail.portal.channels.CStockage.provider;


import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


/**
 * Id: ResourceControl.java,v 1.0<br/>
 * Copyright (c) 2004 Esup Portail (www.esup-portail.org)<br/>
 * Classes: ResourceControl<br/>
 * Original Author: Sbastien Gougeon<br/>
 * Class used as a util tool<br/>
 */
public class ResourceControl { 
 	

	/**
	 * Logger object
	 */
	protected static final Log log = LogFactory.getLog(ResourceControl.class);
	
	

	/**
	 * Check if the resource name is well formed
	 * <br/>accept all string that begining by _ a-z A-Z 0-9 
	 * <br/>deny string that begining by .
	 * <br/>after all characters a-z A-Z 0-9  . _ - are accept, others are denied
	 * @param name name of the file/directory to verify
	 * @return true if file/directory is well formed else false
	 */
	public static boolean isWellFormed(String name){

		//accept all string that begining by _ a-z A-Z 0-9 
		//deny string that begining by .
		//after all characters a-z A-Z 0-9 . _ -  are accept, others are denied
		
		//if (true)return true;
		
		// ici on accepte les accents aussi --> ne marche pas pour le moment avec Slide
		String caractereAlpha = "[ \\(\\)\\-\\'\\!\\w&#_]";
		String regexp = "^"+caractereAlpha+"++[\\."+caractereAlpha+"]*";
		
		//String regexp = "^[\\w]++[\\w\\.\\-\\_]*";
		
        Pattern modele = Pattern.compile(regexp);
        Matcher correspondance = modele.matcher(name);
        if(name != null && !name.equals("") && correspondance.matches()) {

    		// log
    		if (log.isDebugEnabled()){
    			log.debug("isWellFormed"+" :: "+name+" is well formed");
    		}
    		
        	return true;
        }
        else {

    		// log
    		if (log.isDebugEnabled()){
    			log.debug("isWellFormed"+" :: "+name+" is not well formed");
    		}
    		
            return false;
        }
		
	}
	
	
	
	
}