<?xml version='1.0' encoding='ISO-8859-1' ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:import href="_navigation.xsl" /> 
<xsl:import href="_error.xsl" /> 
<xsl:import href="_information.xsl" /> 
<xsl:import href="_content.xsl" /> 
<xsl:import href="_action.xsl" /> 
<xsl:import href="_password.xsl" />

<xsl:output method="html" encoding="iso-8859-1"/>


<xsl:param name="baseActionURL"/>
<xsl:param name="downloadURL"/>

<xsl:template match="/">




<form name="goIntoDirectory" action="{$baseActionURL}" method="post">
	<input type="hidden" name="targetDirectory"/>
</form>


<form name="downloadFile" action="{$downloadURL}" method="post">
	<input type="hidden" name="downloadFile"/>
</form>






<form name="formulaireWebDav" action="{$baseActionURL}" method="post">

<input type="hidden" name="modeDav"/>



<table border="1" cellspacing="0" cellpadding="0" width="100%" align="center">
	
	<!--****************-->
	<!-- Navigation bar -->
	<!--****************-->		
	<xsl:if test="/ROOT/NAVIGATION/DIR/@label!=''">
		<tr>
			<td>
			<xsl:call-template name="_navigation" />
			</td>
		</tr>
	</xsl:if>
	
	
	
	<!--************-->
	<!-- Action bar -->
	<!--************-->		
	<xsl:if test="/ROOT/ACTIONS!=''">
		<tr>
			<td>
				<xsl:call-template name="_action"/>
			</td>
		</tr>
	</xsl:if>
	
	<!--***********-->
	<!-- Error bar -->
	<!--***********-->		
	<xsl:if test="/ROOT/ERRORS/ERROR/@channelCode!=''">
     <tr> 
          <td align="center" valign="center"> 
	          <img src="media/org/esupportail/portal/channels/CWebdav/error_24px.gif" border="0"/>
              <xsl:call-template name="_error"/> 
          </td> 
     </tr> 
     </xsl:if>
	
	
	<!--**********-->
	<!-- Info bar -->
	<!--**********-->		
	<xsl:if test="/ROOT/INFORMATION!=''">           
     <tr> 
          <td align="center"> 
               <xsl:call-template name="_information"/> 
          </td> 
     </tr> 
     </xsl:if>

	
	
	
	<!--*******************************************-->
	<!-- Content of the server OR password setting -->
	<!--*******************************************-->
	<xsl:choose>
		<xsl:when test="/ROOT/PASSWORD/@login!=''">			
			<tr>
				<td>
					<xsl:call-template name="_password"/>
				</td>
			</tr>
		</xsl:when>
		<xsl:otherwise>
			<!-- xsl:if test="/ROOT/CONTENT/DIRECTORY/@label!=''" -->
				<tr>
					<td height="100px" valign="top">
						<xsl:call-template name="_content"/>&#160;
					</td>
				</tr>
			<!-- /xsl:if -->
		</xsl:otherwise>
	</xsl:choose>
	
	
	
	

	<!--************-->
	<!-- Action bar -->
	<!--************-->		
	<xsl:if test="/ROOT/ACTIONS!=''">
		<tr>
			<td>
				<xsl:call-template name="_action"/>
			</td>
		</tr>
	</xsl:if>
	
	
	<!--****************-->
	<!-- Navigation bar -->
	<!--****************-->		
	<tr>
		<td>
		<xsl:call-template name="_navigation" />
		</td>
	</tr>
</table>
</form>







</xsl:template>
</xsl:stylesheet>