<?xml version='1.0' encoding='ISO-8859-1' ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" encoding="ISO-8859-1"/>

<!--<xsl:variable name="baseActionURL"><xsl:value-of select="ROOT/baseActionURL" /></xsl:variable>-->
<xsl:param name="baseActionURL"/>
<xsl:param name="position"/>
<xsl:param name="isClipboardEmpty"/>

<xsl:template name="_action">



<script language="javascript">
<![CDATA[

function actionSubmit(actionParam) {		

	document.formulaireWebDav.modeDav.value=actionParam;
	document.formulaireWebDav.submit();
}
]]>
		</script>





		<table width="100%" border="0" cellspacing="0" cellpadding="6">
			<tr>
				
				
				
				<!-- Dossier parent -->
				<xsl:if test='/ROOT/ACTIONS/PARENT="true"'>
					<td align="center" >
						<a class="uportal-navigation-channel" href="{$baseActionURL}?modeDav=directory_back"><img src="media/org/esupportail/portal/channels/CStockage/back_24px.gif" title="Dossier parent" border="0"/><br/>Parent</a>					
					</td>
				</xsl:if>
				
				<!-- Nouveau dossier -->
				<xsl:if test='/ROOT/ACTIONS/DIRECTORY="true"'>
					<td align="center">
						<a class="uportal-navigation-channel" href="{$baseActionURL}?modeDav=set_name_for_create_dir_mode"><img src="media/org/esupportail/portal/channels/CStockage/new_folder_24px.gif" title="Nouveau dossier" border="0"/><br/>Dossier</a>					
					</td>
				</xsl:if>
				
				<!-- Upload -->
				<xsl:if test='/ROOT/ACTIONS/UPLOAD="true"'>
					<td align="center">
						<a class="uportal-navigation-channel" href="{$baseActionURL}?modeDav=set_file_to_upload_mode"><img src="media/org/esupportail/portal/channels/CStockage/upload_24px.gif" title="Dpot de fichier" border="0"/><br/>Dpt</a>					
					</td>
				</xsl:if>
				
				
				
				
				
				
				
				<!-- Espace de separation -->
				<xsl:if test='/ROOT/ACTIONS/COPY="true" or /ROOT/ACTIONS/MOVE="true" or /ROOT/ACTIONS/PASTE="true" or /ROOT/ACTIONS/RENAME="true" or /ROOT/ACTIONS/DELETE="true"'>
					<td width="10%" align="center">
						<img src="media/org/esupportail/portal/channels/CStockage/separator.jpg" border="0"/>
					</td>
				</xsl:if>
				
				
				
				
				
				
				
				<!-- Copie -->
				<xsl:if test='/ROOT/ACTIONS/COPY="true"'>
					<td align="center">
						<a class="uportal-navigation-channel" href="javascript:actionSubmit('set_clipboard_for_copy_mode');"><img src="media/org/esupportail/portal/channels/CStockage/copy_24px.gif" title="Copier" border="0"/><br/>Copier</a>					
					</td>
				</xsl:if>
				
				<!-- Couper -->
				<xsl:if test='/ROOT/ACTIONS/MOVE="true"'>
					<td align="center">
						<a class="uportal-navigation-channel" href="javascript:actionSubmit('set_clipboard_for_move_mode');"><img src="media/org/esupportail/portal/channels/CStockage/cut_24px.gif" title="Couper" border="0"/><br/>Couper</a>					
					</td>
				</xsl:if>
				
				<!-- Coller -->
				<xsl:if test='/ROOT/ACTIONS/PASTE="true"'>
				<xsl:if test="$isClipboardEmpty='false'">
					<td align="center">
						<a class="uportal-navigation-channel" href="{$baseActionURL}?modeDav=confirm_paste_mode"><img src="media/org/esupportail/portal/channels/CStockage/paste_24px.gif" title="Coller" border="0"/><br/>Coller</a>						
					</td>
				</xsl:if>
				</xsl:if>
				
				<!-- Renommer -->
				<xsl:if test='/ROOT/ACTIONS/RENAME="true"'>
					<td align="center">
						<a class="uportal-navigation-channel" href="javascript:actionSubmit('set_name_for_rename_mode');"><img src="media/org/esupportail/portal/channels/CStockage/rename_24px.gif" title="Renommer" border="0"/><br/>Renommer</a>					
					</td>
				</xsl:if>
				
				<!-- Supprimer -->
				<xsl:if test='/ROOT/ACTIONS/DELETE="true"'>
					<td align="center">
						<a class="uportal-navigation-channel" href="javascript:actionSubmit('confirm_delete_mode');"><img src="media/org/esupportail/portal/channels/CStockage/delete_24px.gif" title="Supprimer" border="0"/><br/>Supprimer</a>					
					</td>
				</xsl:if>
				
				
				
				
				
				
				
				<!-- Espace de separation -->
				<xsl:if test='/ROOT/ACTIONS/METADATA="true" or /ROOT/ACTIONS/SUBMIT="true" or /ROOT/ACTIONS/PUBLISH="true" or /ROOT/ACTIONS/REFUSE="true"'>
					<td width="10%" align="center">
						<img src="media/org/esupportail/portal/channels/CStockage/separator.jpg" border="0"/>
					</td>
				</xsl:if>
				
				
				
				
				
				
				
				<!-- Meta-donnees -->											
				<xsl:if test='/ROOT/ACTIONS/METADATA="true"'>
					<td align="center">
						<a class="uportal-navigation-channel" href="javascript:actionSubmit('set_metadata_on_document_mode');"><img src="media/org/esupportail/portal/channels/CStockage/injac/metadata_24px.gif" title="Proprits" border="0"/><br/>Proprits</a>					
					</td>
				</xsl:if>				
				
				<!-- Soumettre -->								
				<xsl:if test='/ROOT/ACTIONS/SUBMIT="true"'>
					<td align="center">
						<a class="uportal-navigation-channel" href="javascript:actionSubmit('confirm_submit_mode');"><img src="media/org/esupportail/portal/channels/CStockage/injac/submit_24px.gif" title="Soumettre" border="0"/><br/>Soumettre</a>					
					</td>
				</xsl:if>
				
				<!-- Publier -->								
				<xsl:if test='/ROOT/ACTIONS/PUBLISH="true"'>
					<td align="center">
						<a class="uportal-navigation-channel" href="javascript:actionSubmit('confirm_publish_mode');"><img src="media/org/esupportail/portal/channels/CStockage/injac/publish_24px.gif" title="Publier" border="0"/><br/>Publier</a>					
					</td>
				</xsl:if>
				
				<!-- Refuser -->								
				<xsl:if test='/ROOT/ACTIONS/REFUSE="true"'>
					<td align="center">
						<a class="uportal-navigation-channel" href="javascript:actionSubmit('confirm_reject_mode');"><img src="media/org/esupportail/portal/channels/CStockage/injac/refuse_24px.gif" title="Refuser" border="0"/><br/>Refuser</a>					
					</td>
				</xsl:if>				
				
				<!-- Dpublier -->								
				<xsl:if test='/ROOT/ACTIONS/UNPUBLISH="true"'>
					<td align="center">
						<a class="uportal-navigation-channel" href="javascript:actionSubmit('confirm_unpublish_mode');"><img src="media/org/esupportail/portal/channels/CStockage/injac/unpublish_24px.gif" title="Dpublier" border="0"/><br/>Dpublier</a>					
					</td>
				</xsl:if>
				
				
				
				
				
				
				<!-- Espace de separation -->
				<xsl:if test='/ROOT/ACTIONS/ADMIN="true" or /ROOT/ACTIONS/SPACE="true"'>
					<td width="10%" align="center">
						<img src="media/org/esupportail/portal/channels/CStockage/separator.jpg" border="0"/>
					</td>
				</xsl:if>
				
				
				
				
				
				
				
				<!-- Administrer -->							
				<xsl:if test='/ROOT/ACTIONS/ADMIN="true"'>
					<td align="center">
						<!--a class="uportal-navigation-channel" href="{$baseActionURL}?modeDav=admin_space_mode&amp;uP_root=me"><img src="media/org/esupportail/portal/channels/CStockage/injac/administration_24px.gif" title="Administrer" border="0"/><br/>Administrer</a-->					
						<a class="uportal-navigation-channel" href="{$baseActionURL}?modeDav=admin_space_mode"><img src="media/org/esupportail/portal/channels/CStockage/injac/administration_24px.gif" title="Administrer" border="0"/><br/>Administrer</a>
					</td>
				</xsl:if>
				
				<!-- Sous-espace -->								
				<xsl:if test='/ROOT/ACTIONS/SPACE="true"'>
					<td align="center">
						<a class="uportal-navigation-channel" href="{$baseActionURL}?modeDav=set_name_for_create_space_mode"><img src="media/org/esupportail/portal/channels/CStockage/new_folder_24px.gif" title="Nouveau sous-espace" border="0"/><br/>Espace</a>					
					</td>
				</xsl:if>
				
				
				
				
				
				
				
				<!-- Espace de separation -->
				<td width="100%">
					&#160;
				</td>
				
				
				
			</tr>
		</table>
		
		
		
		
		
		
		
		
</xsl:template>
</xsl:stylesheet>