<?xml version='1.0' encoding='ISO-8859-1' ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" encoding="ISO-8859-1"/>
<xsl:param name="baseActionURL"/>
<xsl:param name="mediaPath" />

<xsl:template match="/">




		<script language="javascript">
<![CDATA[


// action when we change the metadataFile
function changeMetadataFile(formulaire) {		
	document.valid_metadata.submit();	 	
}


// action when we change the rendering type
function changeRenderingType(formulaire) {		
	document.valid_rendering_type.submit();	 	
}

// action when we change the check box for public viewing
function changePublicReader(formulaire) {	
	document.reader.action = document.reader.action+"&change_public=true";	
	document.reader.submit();	 	
}
	

]]>
		</script>







<table border="0" width="100%" cellspacing="0" cellpadding="5">
	<tr class="uportal-background-light">				
		<td class="uportal-channel-table-header" nowrap="true">Administration de "<xsl:value-of select="/ROOT/space/@name"/>"</td>
		<td width="100%">&#160;</td>		
		<td align="center">
			<a class="uportal-navigation-channel" href="{$baseActionURL}?modeDav=admin_space_mode&amp;action=valid&amp;uP_root=root">
			<!--a class="uportal-navigation-channel" href="{$baseActionURL}?modeDav=admin_space_mode&amp;action=valid"-->				
				<img src="media/org/esupportail/portal/channels/CStockage/injac/valid_24px.gif" alt="Valider" border="0" />
				<br/>Valider
			</a>
		</td>
		<td align="center">
			<a class="uportal-navigation-channel" href="{$baseActionURL}?modeDav=admin_space_mode&amp;action=cancel&amp;uP_root=root">				
			<!--a class="uportal-navigation-channel" href="{$baseActionURL}?modeDav=admin_space_mode&amp;action=cancel"-->
				<img src="media/org/esupportail/portal/channels/CStockage/error_24px.gif" alt="Annuler" border="0" />
				<br/>Annuler
			</a>
		</td>
	</tr>
</table>
<br/>
<br/>





<xsl:for-each select="/ROOT/description">
<table border="0" width="100%" cellpadding="5" cellspacing="0">
	<tr class="uportal-background-highlight">
		<td class="uportal-channel-table-caption" colspan="3">Description</td>		
	</tr>
	<form action="{$baseActionURL}?modeDav=admin_space_mode&amp;uP_root=root" method="post">
	
	<tr>
		<td>&#160;</td>		
		<td class="uportal-channel-text" align="center">
			<xsl:value-of select="."/>
		</td>
		<td>&#160;</td>	
	</tr>
		
	
	<tr>
		<td width="20%">&#160;</td>		
		<td align="center" width="60%">			
			<textarea name="description" rows="3" cols="40" class="uportal-input-text"></textarea>			
		</td>
		<td width="20%">&#160;</td>						
	</tr>
	
	
	<tr>
		<td colspan="3" align="center">
			<input class="uportal-button" type="submit" value="Modifier" name="submit_description" />
		</td>		
	</tr>
	
	</form>
	
	
	
	
</table>
<br/>
</xsl:for-each>







<xsl:for-each select="/ROOT/metadata">
<table border="0" width="100%" cellpadding="5" cellspacing="0">
	<tr class="uportal-background-highlight">
		<td class="uportal-channel-table-caption" colspan="2">Mta-donnes  saisir par les utilisateurs</td>		
	</tr>
		
	
	<tr valign="top">
		<td width="100%" colspan="2" align="center">
			
		<form name="valid_metadata" action="{$baseActionURL}?modeDav=admin_space_mode&amp;uP_root=root" method="post">
			<SELECT NAME="metadataFile" SIZE="1" onChange="changeMetadataFile(this.form)">      			
				<xsl:for-each select="md">
					<xsl:choose>						
						<xsl:when test="@default='true'">
							<xsl:variable name="val"><xsl:value-of select="@name"/></xsl:variable>						
							<OPTION SELECTED="true" VALUE="{$val}"><xsl:value-of select="@label"/></OPTION>
						</xsl:when>
						<xsl:otherwise>
							<xsl:variable name="val"><xsl:value-of select="@name"/></xsl:variable>						
							<OPTION VALUE="{$val}"><xsl:value-of select="@label"/></OPTION>
						</xsl:otherwise>
					</xsl:choose>					
				</xsl:for-each>
			</SELECT>	
	    </form>		
			
		</td>		
	</tr>
	
</table>
<br/>
</xsl:for-each>





<xsl:for-each select="/ROOT/renderingType">
<table border="0" width="100%" cellpadding="5" cellspacing="0">
	<tr class="uportal-background-highlight">
		<td class="uportal-channel-table-caption" colspan="2">Type de rendu des documents publis</td>		
	</tr>
		
	
	<tr valign="top">
		<td width="100%" colspan="2" align="center">
			
		<form name="valid_rendering_type" action="{$baseActionURL}?modeDav=admin_space_mode&amp;uP_root=root" method="post">
			<SELECT NAME="renderingType" SIZE="1" onChange="changeRenderingType(this.form)">      			
				<xsl:for-each select="render">
					<xsl:choose>						
						<xsl:when test="@default='true'">
							<xsl:variable name="val"><xsl:value-of select="@name"/></xsl:variable>						
							<OPTION SELECTED="true" VALUE="{$val}"><xsl:value-of select="@label"/></OPTION>
						</xsl:when>
						<xsl:otherwise>
							<xsl:variable name="val"><xsl:value-of select="@name"/></xsl:variable>						
							<OPTION VALUE="{$val}"><xsl:value-of select="@label"/></OPTION>
						</xsl:otherwise>
					</xsl:choose>					
				</xsl:for-each>
			</SELECT>	
	    </form>		
			
		</td>		
	</tr>
	
</table>
<br/>
</xsl:for-each>





<xsl:for-each select="/ROOT/manager">
<table border="0" width="100%" cellpadding="5" cellspacing="0">
	<tr class="uportal-background-highlight">
		<td class="uportal-channel-table-caption" colspan="2">Gestionnaires</td>
	</tr>
		
	
	<tr valign="top">
		<td width="50%">
		<form method="post" action="{$baseActionURL}?modeDav=admin_space_mode&amp;uP_root=root">
			<table border="0" width="100%" cellpadding="5" cellspacing="0">
				<tr class="uportal-background-med">
					<td>&#160;</td>
					<td class="uportal-channel-table-header" nowrap="true" colspan="2" align="left" width="100%">Groupes</td>					
				</tr>
				
				<xsl:apply-templates select="groups/group" />							
			</table>
			
				<input type="hidden" name="user_type" value="manager_group" />		
				<input class="uportal-button" type="submit" value="Ajouter" name="add" />
				<input class="uportal-button" type="submit" value="Supprimer" name="delete" />
			</form>
			<br/>
		</td>
		
		<td width="50%">
		<form method="post" action="{$baseActionURL}?modeDav=admin_space_mode&amp;uP_root=root">
			<table border="0" width="100%" cellpadding="5" cellspacing="0">
				<tr class="uportal-background-med">
					<td>&#160;</td>
					<td class="uportal-channel-table-header" nowrap="true" colspan="2" align="left" width="100%">Utilisateurs</td>
				</tr>
				<xsl:apply-templates select="users/user"/>
			</table>
			
				<input type="hidden" name="user_type" value="manager_user" />		
				<input class="uportal-button" type="submit" value="Ajouter" name="add" />
				<input class="uportal-button" type="submit" value="Supprimer" name="delete" />
			</form>
			<br/>
		</td>
	</tr>
	
</table>
</xsl:for-each>







<xsl:for-each select="/ROOT/writer">
<table border="0" width="100%" cellpadding="5" cellspacing="0">
	<tr class="uportal-background-highlight">
		<td class="uportal-channel-table-caption" colspan="2">Rdacteurs</td>		
	</tr>
		
	
	<tr valign="top">
		<td width="50%">
		<form method="post" action="{$baseActionURL}?modeDav=admin_space_mode&amp;uP_root=root">
			<table border="0" width="100%" cellpadding="5" cellspacing="0">
				<tr class="uportal-background-med">
					<td>&#160;</td>
					<td class="uportal-channel-table-header" nowrap="true" colspan="2" align="left" width="100%">Groupes</td>					
				</tr>
				
				<xsl:apply-templates select="groups/group" />							
			</table>
						
				<input type="hidden" name="user_type" value="writer_group" />		
				<input class="uportal-button" type="submit" value="Ajouter" name="add" />
				<input class="uportal-button" type="submit" value="Supprimer" name="delete" />
			</form>
			<br/>
		</td>
		
		<td width="50%">
		<form method="post" action="{$baseActionURL}?modeDav=admin_space_mode&amp;uP_root=root">
			<table border="0" width="100%" cellpadding="5" cellspacing="0">
				<tr class="uportal-background-med">
					<td>&#160;</td>
					<td class="uportal-channel-table-header" nowrap="true" colspan="2" align="left" width="100%">Utilisateurs</td>
				</tr>
				<xsl:apply-templates select="users/user"/>
			</table>
						
				<input type="hidden" name="user_type" value="writer_user" />		
				<input class="uportal-button" type="submit" value="Ajouter" name="add" />
				<input class="uportal-button" type="submit" value="Supprimer" name="delete" />
			</form>
			<br/>
		</td>
	</tr>
	
</table>
</xsl:for-each>






<xsl:for-each select="/ROOT/editor">
<table border="0" width="100%" cellpadding="5" cellspacing="0">
	<tr class="uportal-background-highlight">
		<td class="uportal-channel-table-caption" colspan="2">Editeurs</td>
	</tr>
		
	
	<tr valign="top">
		<td width="50%">
		<form method="post" action="{$baseActionURL}?modeDav=admin_space_mode&amp;uP_root=root">
			<table border="0" width="100%" cellpadding="5" cellspacing="0">
				<tr class="uportal-background-med">
					<td>&#160;</td>
					<td class="uportal-channel-table-header" nowrap="true" colspan="2" align="left" width="100%">Groupes</td>					
				</tr>
				
				<xsl:apply-templates select="groups/group" />							
			</table>				
			
				<input type="hidden" name="user_type" value="editor_group" />		
				<input class="uportal-button" type="submit" value="Ajouter" name="add" />
				<input class="uportal-button" type="submit" value="Supprimer" name="delete" />
			</form>			
			<br/>
		</td>
		
		<td width="50%">
		<form method="post" action="{$baseActionURL}?modeDav=admin_space_mode&amp;uP_root=root">
			<table border="0" width="100%" cellpadding="5" cellspacing="0">
				<tr class="uportal-background-med">
					<td>&#160;</td>
					<td class="uportal-channel-table-header" nowrap="true" colspan="2" align="left" width="100%">Utilisateurs</td>
				</tr>
				<xsl:apply-templates select="users/user"/>
			</table>
						
				<input type="hidden" name="user_type" value="editor_user" />		
				<input class="uportal-button" type="submit" value="Ajouter" name="add" />
				<input class="uportal-button" type="submit" value="Supprimer" name="delete" />
			</form>
			<br/>
		</td>
	</tr>
	
</table>
</xsl:for-each>










<xsl:for-each select="/ROOT/reader">
<table border="0" width="100%" cellpadding="5" cellspacing="0">
	<tr class="uportal-background-highlight">		
		<td class="uportal-channel-table-caption" colspan="4">Lecteurs</td>		
	</tr>
	
	<tr>		
		<td class="uportal-channel-table-caption" width="30%">&#160;</td>
		<td class="uportal-channel-table-caption" width="40%" colspan="2" align="center">
			<form name="reader" method="post" action="{$baseActionURL}?modeDav=admin_space_mode&amp;uP_root=root">
			<table border="0" width="100%" cellpadding="0" cellspacing="0">
				<tr class="uportal-background-med">
					<td width="50%">&#160;</td>
					<td class="uportal-channel-table-header">
						<xsl:choose>
							<xsl:when test="@public!='true'">
								<input type="checkbox" name="public_reading" value="{@public}" onChange="changePublicReader(this.form)" onClick="changePublicReader(this.form)"/>
							</xsl:when>
							<xsl:otherwise>
	 							<input type="checkbox" checked="true" name="public_reading" value="{@public}" onChange="changePublicReader(this.form)" onClick="changePublicReader(this.form)"/>
							</xsl:otherwise>
						</xsl:choose>						
					</td>
					<td class="uportal-channel-table-header" nowrap="true" align="center" >Public</td>
					<td width="50%">&#160;</td>
				</tr>
			</table>
			</form>
		</td>
		<td class="uportal-channel-table-caption" width="30%">&#160;</td>		
	</tr>
		
	
	<tr valign="top">
		<td width="50%" colspan="2">
		<form method="post" action="{$baseActionURL}?modeDav=admin_space_mode&amp;uP_root=root">
						
			<!--xsl:if test="@public!='true'"-->
			<table border="0" width="100%" cellpadding="5" cellspacing="0">
				<tr class="uportal-background-med">
					<td>&#160;</td>
					<td class="uportal-channel-table-header" nowrap="true" colspan="2" align="left" width="100%">Groupes</td>					
				</tr>
				
				<xsl:apply-templates select="groups/group" />									
			</table>
			
			
				<input type="hidden" name="user_type" value="reader_group" />		
				<input class="uportal-button" type="submit" value="Ajouter" name="add" />
				<input class="uportal-button" type="submit" value="Supprimer" name="delete" />
			<!--/xsl:if-->
			</form>
			
			
			
			<br/>
		</td>
		
		<td width="50%" colspan="2">
		<form method="post" action="{$baseActionURL}?modeDav=admin_space_mode&amp;uP_root=root">
			
			<!--xsl:if test="@public!='true'"-->
			<table border="0" width="100%" cellpadding="5" cellspacing="0">
				<tr class="uportal-background-med">
					<td>&#160;</td>
					<td class="uportal-channel-table-header" nowrap="true" colspan="2" align="left" width="100%">Utilisateurs</td>
				</tr>
				<xsl:apply-templates select="users/user"/>
			</table>
			
			
				<input type="hidden" name="user_type" value="reader_user" />		
				<input class="uportal-button" type="submit" value="Ajouter" name="add" />
				<input class="uportal-button" type="submit" value="Supprimer" name="delete" />
			<!--/xsl:if-->
			</form>			
			
			<br/>
		</td>
	</tr>
	
</table>
</xsl:for-each>





</xsl:template>





<xsl:template match="group">
	<tr>
		<td><input type="checkbox" name="groupsList" value="{@key}"/></td>
		<td><img src="media/org/esupportail/portal/channels/CStockage/injac/group_20px.gif" border="0" /></td>
		<td class="uportal-channel-text" nowrap="true" align="left" width="100%"><xsl:value-of select="./@name" /></td>
	</tr>
</xsl:template>




<xsl:template match="user">
	<tr>
		<td><input type="checkbox" name="usersList" value="{@key}"/></td>
		<td><img src="media/org/esupportail/portal/channels/CStockage/injac/user_20px.gif" border="0" /></td>
		<td class="uportal-channel-text" nowrap="true" align="left" width="100%"><xsl:value-of select="./@name" /></td>
	</tr>
</xsl:template>

</xsl:stylesheet>