/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.jdo.jdoql;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jdo.JDOUserException;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.MetadataManager;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.jdo.QueryImpl;
import org.apache.ojb.jdo.jdoql.Acceptor;
import org.apache.ojb.jdo.jdoql.BinaryExpression;
import org.apache.ojb.jdo.jdoql.Expression;
import org.apache.ojb.jdo.jdoql.FieldAccess;
import org.apache.ojb.jdo.jdoql.Import;
import org.apache.ojb.jdo.jdoql.LocalVariable;
import org.apache.ojb.jdo.jdoql.LocalVariableAccess;
import org.apache.ojb.jdo.jdoql.MethodInvocation;
import org.apache.ojb.jdo.jdoql.NameExpression;
import org.apache.ojb.jdo.jdoql.NullLiteral;
import org.apache.ojb.jdo.jdoql.ThisExpression;
import org.apache.ojb.jdo.jdoql.Type;
import org.apache.ojb.jdo.jdoql.UnaryExpression;
import org.apache.ojb.jdo.jdoql.VisitorBase;

public class QueryTreeResolver
extends VisitorBase {
    private static HashMap _primitiveTypes = new HashMap();
    private QueryImpl _query;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$util$Collection;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolveAndCheck(QueryImpl query) throws JDOUserException {
        this._query = query;
        try {
            this.checkImports(query.getImports());
            this.visit(query.getVariables());
            this.visit(query.getParameters());
            if (query.getFilterExpression() != null) {
                query.getFilterExpression().accept(this);
            }
            this.visit(query.getOrderings());
        }
        finally {
            this._query = null;
        }
    }

    private void checkImports(Collection imports) throws JDOUserException {
        HashMap directlyImportedClasses = new HashMap();
        Iterator it = imports.iterator();
        while (it.hasNext()) {
            Import importDecl = (Import)it.next();
            if (importDecl.isOnDemand()) continue;
            String shortName = importDecl.getSpec().substring(importDecl.getSpec().lastIndexOf(46));
            if (directlyImportedClasses.containsKey(shortName)) {
                throw new JDOUserException("Multiple direct imports of classes with the same unqualified name " + shortName);
            }
            directlyImportedClasses.put(shortName, null);
        }
    }

    private void visit(Map objects) throws JDOUserException {
        if (objects != null) {
            Iterator it = objects.values().iterator();
            while (it.hasNext()) {
                ((Acceptor)it.next()).accept(this);
            }
        }
    }

    private void visit(Collection objects) throws JDOUserException {
        if (objects != null) {
            Iterator it = objects.iterator();
            while (it.hasNext()) {
                ((Acceptor)it.next()).accept(this);
            }
        }
    }

    public void visit(BinaryExpression binExpr) throws JDOUserException {
        super.visit(binExpr);
        Class leftType = binExpr.getLeftSide().getType();
        Class rightType = binExpr.getRightSide().getType();
        boolean typeWasSet = false;
        switch (binExpr.getOperator()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                if (binExpr.getOperator() == 2 && leftType == (class$java$lang$String == null ? (class$java$lang$String = QueryTreeResolver.class$("java.lang.String")) : class$java$lang$String) && rightType == (class$java$lang$String == null ? (class$java$lang$String = QueryTreeResolver.class$("java.lang.String")) : class$java$lang$String)) {
                    binExpr.setType(class$java$lang$String == null ? (class$java$lang$String = QueryTreeResolver.class$("java.lang.String")) : class$java$lang$String);
                    typeWasSet = true;
                    break;
                }
                if (!QueryTreeResolver.isNumeric(leftType) || !QueryTreeResolver.isNumeric(rightType)) break;
                binExpr.setType(QueryTreeResolver.getBroaderType(leftType, rightType));
                typeWasSet = true;
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                if (QueryTreeResolver.isInteger(leftType) && QueryTreeResolver.isInteger(rightType)) {
                    binExpr.setType(QueryTreeResolver.getBroaderType(leftType, rightType));
                    typeWasSet = true;
                    break;
                }
                if (leftType != Boolean.TYPE || rightType != Boolean.TYPE) break;
                binExpr.setType(Boolean.TYPE);
                typeWasSet = true;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                if (QueryTreeResolver.isNumeric(leftType) && QueryTreeResolver.isNumeric(rightType)) {
                    binExpr.setType(Boolean.TYPE);
                    typeWasSet = true;
                    break;
                }
                if (leftType == (class$java$lang$String == null ? (class$java$lang$String = QueryTreeResolver.class$("java.lang.String")) : class$java$lang$String) && rightType == (class$java$lang$String == null ? (class$java$lang$String = QueryTreeResolver.class$("java.lang.String")) : class$java$lang$String)) {
                    binExpr.setType(Boolean.TYPE);
                    typeWasSet = true;
                    break;
                }
                if (leftType != (class$java$util$Date == null ? (class$java$util$Date = QueryTreeResolver.class$("java.util.Date")) : class$java$util$Date) || rightType != (class$java$util$Date == null ? (class$java$util$Date = QueryTreeResolver.class$("java.util.Date")) : class$java$util$Date)) break;
                binExpr.setType(Boolean.TYPE);
                typeWasSet = true;
                break;
            }
            case 8: 
            case 9: {
                if (QueryTreeResolver.isNumeric(leftType) && QueryTreeResolver.isNumeric(rightType)) {
                    binExpr.setType(Boolean.TYPE);
                    typeWasSet = true;
                    break;
                }
                if (leftType == Boolean.TYPE && rightType == Boolean.TYPE) {
                    binExpr.setType(Boolean.TYPE);
                    typeWasSet = true;
                    break;
                }
                if (leftType.isPrimitive() || rightType.isPrimitive()) break;
                binExpr.setType(Boolean.TYPE);
                typeWasSet = true;
                break;
            }
            case 13: 
            case 14: {
                if (leftType != Boolean.TYPE || rightType != Boolean.TYPE) break;
                binExpr.setType(Boolean.TYPE);
                typeWasSet = true;
            }
        }
        if (!typeWasSet) {
            throw new JDOUserException("Binary expression cannot be applied to expressions of types " + leftType.getName() + " and " + rightType.getName());
        }
    }

    public void visit(MethodInvocation methodInvoc) throws JDOUserException {
        super.visit(methodInvoc);
        Class type = methodInvoc.getBaseExpression().getType();
        String name = methodInvoc.getName();
        if ((class$java$util$Collection == null ? (class$java$util$Collection = QueryTreeResolver.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(type)) {
            if ("contains".equals(name)) {
                if (methodInvoc.getArguments().size() != 1) {
                    throw new JDOUserException("Illegal number of arguments to method Collection.contains");
                }
            } else if ("isEmpty".equals(name)) {
                if (!methodInvoc.getArguments().isEmpty()) {
                    throw new JDOUserException("Illegal number of arguments to method Collection.isEmpty");
                }
            } else {
                throw new JDOUserException("Only methods 'contains' and 'isEmpty' are allowed to be called at collection objects");
            }
            methodInvoc.setType(Boolean.TYPE);
        } else if (type == (class$java$lang$String == null ? (class$java$lang$String = QueryTreeResolver.class$("java.lang.String")) : class$java$lang$String)) {
            if (!"startsWith".equals(name) && !"endsWith".equals(name)) {
                throw new JDOUserException("Only methods 'contains' and 'isEmpty' are allowed to be called at collection objects");
            }
            if (methodInvoc.getArguments().size() != 1) {
                throw new JDOUserException("Illegal number of arguments to method String." + name);
            }
            if (((Expression)methodInvoc.getArguments().get(0)).getType() != (class$java$lang$String == null ? (class$java$lang$String = QueryTreeResolver.class$("java.lang.String")) : class$java$lang$String)) {
                throw new JDOUserException("Illegal argument to method Collection." + name);
            }
            methodInvoc.setType(Boolean.TYPE);
        } else {
            throw new JDOUserException("Invocation of method " + methodInvoc.getName() + " at type " + type.getName() + " is not allowed");
        }
    }

    public void visit(NameExpression nameExpr) throws JDOUserException {
        super.visit(nameExpr);
        NameExpression newExpr = null;
        Class baseType = null;
        if (!nameExpr.hasBaseExpression()) {
            LocalVariable var = this._query.getVariable(nameExpr.getName());
            if (var == null) {
                var = this._query.getParameter(nameExpr.getName());
            }
            if (var != null) {
                LocalVariableAccess varAccess = new LocalVariableAccess(nameExpr.getName());
                varAccess.setAccessedVariable(var);
                newExpr = varAccess;
            } else {
                baseType = this._query.getSearchedClass();
            }
        } else {
            baseType = nameExpr.getBaseExpression().getType();
        }
        if (newExpr == null) {
            ClassDescriptor classDesc = this.findClassDescriptorFor(baseType);
            if (classDesc == null) {
                throw new JDOUserException("Access to type " + baseType.getName() + " is not allowed because the type is not persistent");
            }
            FieldAccess fieldAccess = new FieldAccess(nameExpr.getBaseExpression(), nameExpr.getName());
            ObjectReferenceDescriptor refDesc = classDesc.getObjectReferenceDescriptorByName(nameExpr.getName());
            if (refDesc != null) {
                fieldAccess.setFieldDescriptor(refDesc);
            } else {
                if (nameExpr.hasParent() && nameExpr.getParent() instanceof NameExpression) {
                    throw new JDOUserException("Cannot find reference " + nameExpr.getName() + " in type " + baseType.getName() + " because it is not defined, not persistent or not a reference");
                }
                CollectionDescriptor collDesc = classDesc.getCollectionDescriptorByName(nameExpr.getName());
                if (collDesc != null) {
                    fieldAccess.setFieldDescriptor(collDesc);
                } else {
                    FieldDescriptor fieldDesc = classDesc.getFieldDescriptorByName(nameExpr.getName());
                    if (fieldDesc == null) {
                        throw new JDOUserException("Cannot find feature " + nameExpr.getName() + " in type " + baseType.getName() + " because it is not defined or not persistent");
                    }
                    fieldAccess.setFieldDescriptor(fieldDesc);
                }
            }
            newExpr = fieldAccess;
        }
        if (nameExpr.hasParent()) {
            nameExpr.getParent().replaceChild(nameExpr, newExpr);
        }
    }

    public void visit(NullLiteral nullLit) {
        Expression parent = nullLit.getParent();
        if (parent == null) {
            return;
        }
        if (parent instanceof BinaryExpression) {
            Class type = null;
            type = ((BinaryExpression)parent).getLeftSide() == nullLit ? ((BinaryExpression)parent).getRightSide().getType() : ((BinaryExpression)parent).getLeftSide().getType();
            if (type.isPrimitive()) {
                throw new JDOUserException("Illegal binary expression with a 'null' and a primitive operand");
            }
            nullLit.setType(type);
        }
    }

    public void visit(ThisExpression thisExpr) {
        super.visit(thisExpr);
        thisExpr.setType(this._query.getSearchedClass());
    }

    public void visit(Type type) throws JDOUserException {
        ClassLoader loader = ClassHelper.getClassLoader();
        Class result = null;
        String name = type.getName();
        int pos = name.indexOf(46);
        if (pos >= 0) {
            try {
                result = Class.forName(name, true, loader);
            }
            catch (ClassNotFoundException ex) {
                // empty catch block
            }
        }
        if (result == null) {
            result = this.resolveUnqualifiedClassName(loader, name);
        }
        if (result == null) {
            throw new JDOUserException("No such class " + name);
        }
        type.setType(result);
    }

    private Class resolveUnqualifiedClassName(ClassLoader loader, String unqualifiedName) throws JDOUserException {
        Class<?> result = null;
        try {
            result = Class.forName("java.lang." + unqualifiedName, true, loader);
        }
        catch (ClassNotFoundException ex) {
            // empty catch block
        }
        Iterator it = this._query.getImports().iterator();
        while (it.hasNext()) {
            Import importDecl = (Import)it.next();
            if (importDecl.isOnDemand()) {
                try {
                    result = Class.forName(importDecl.getSpec() + "." + unqualifiedName, true, loader);
                }
                catch (ClassNotFoundException ex) {}
                continue;
            }
            int pos = importDecl.getSpec().lastIndexOf(46);
            if (!unqualifiedName.equals(importDecl.getSpec().substring(pos + 1))) continue;
            try {
                return Class.forName(importDecl.getSpec() + "." + unqualifiedName, true, loader);
            }
            catch (ClassNotFoundException ex) {
                throw new JDOUserException("The import " + importDecl.getSpec() + " is invalid");
            }
        }
        return result;
    }

    public void visit(UnaryExpression unaryExpr) throws JDOUserException {
        super.visit(unaryExpr);
        Class innerType = unaryExpr.getInnerExpression().getType();
        boolean typeWasSet = false;
        switch (unaryExpr.getOperator()) {
            case 0: 
            case 1: {
                if (!QueryTreeResolver.isNumeric(innerType)) break;
                unaryExpr.setType(innerType);
                typeWasSet = true;
                break;
            }
            case 2: {
                if (!QueryTreeResolver.isInteger(innerType)) break;
                unaryExpr.setType(innerType);
                typeWasSet = true;
                break;
            }
            case 3: {
                if (innerType != Boolean.TYPE) break;
                unaryExpr.setType(innerType);
                typeWasSet = true;
                break;
            }
            case 4: {
                Class castType = unaryExpr.getCastType().getType();
                if (QueryTreeResolver.isNumeric(castType) && QueryTreeResolver.isNumeric(innerType)) {
                    unaryExpr.setType(castType);
                    typeWasSet = true;
                    break;
                }
                if (!castType.isAssignableFrom(innerType) && !innerType.isAssignableFrom(castType)) break;
                unaryExpr.setType(castType);
                typeWasSet = true;
            }
        }
        if (!typeWasSet) {
            if (unaryExpr.getOperator() == 4) {
                throw new JDOUserException("Invalid cast expression because inner expression of type " + innerType.getName() + " cannot be cast to " + unaryExpr.getCastType().getName());
            }
            throw new JDOUserException("Invalid unary expression");
        }
    }

    private ClassDescriptor findClassDescriptorFor(Class type) {
        return MetadataManager.getInstance().getRepository().getDescriptorFor(type);
    }

    private static boolean isInteger(Class type) {
        if (type.isPrimitive()) {
            return type != Boolean.TYPE && type != Float.TYPE && type != Double.TYPE;
        }
        return type == (class$java$math$BigInteger == null ? (class$java$math$BigInteger = QueryTreeResolver.class$("java.math.BigInteger")) : class$java$math$BigInteger);
    }

    private static boolean isFloatingPoint(Class type) {
        if (type.isPrimitive()) {
            return type == Float.TYPE || type == Double.TYPE;
        }
        return type == (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = QueryTreeResolver.class$("java.math.BigDecimal")) : class$java$math$BigDecimal);
    }

    private static boolean isNumeric(Class type) {
        if (type.isPrimitive()) {
            return type != Boolean.TYPE;
        }
        return type == (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = QueryTreeResolver.class$("java.math.BigDecimal")) : class$java$math$BigDecimal) || type == (class$java$math$BigInteger == null ? (class$java$math$BigInteger = QueryTreeResolver.class$("java.math.BigInteger")) : class$java$math$BigInteger);
    }

    private static Class getBroaderType(Class typeA, Class typeB) {
        Integer numA = (Integer)_primitiveTypes.get(typeA);
        Integer numB = (Integer)_primitiveTypes.get(typeB);
        return numA < numB ? typeB : typeA;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        _primitiveTypes.put(Byte.TYPE, new Integer(0));
        _primitiveTypes.put(Character.TYPE, new Integer(1));
        _primitiveTypes.put(Short.TYPE, new Integer(2));
        _primitiveTypes.put(Integer.TYPE, new Integer(3));
        _primitiveTypes.put(Long.TYPE, new Integer(4));
        _primitiveTypes.put(class$java$math$BigInteger == null ? (class$java$math$BigInteger = QueryTreeResolver.class$("java.math.BigInteger")) : class$java$math$BigInteger, new Integer(5));
        _primitiveTypes.put(Float.TYPE, new Integer(6));
        _primitiveTypes.put(Double.TYPE, new Integer(7));
        _primitiveTypes.put(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = QueryTreeResolver.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, new Integer(8));
    }
}

