/*
ESUP-portail is a french academic project developed under the GPL (General Public License) augmented according to the following :
A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.
The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .
A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .
The different kinds of licenses governing the products developed by the Apache foundation can be found here : http://www.apache.org/licenses .
It follows that you can as well as use download contents as well modify and redistribute them provided you respect the GPL terms.
Downloading and using such contents do not provide any guaranty.
Be sure that you have well understood the terms of the license before using the contents it covers.
The ESUP-portail distribution includes the following distributions :
    * UPortal :
      software developed by JA-SIG (Java Architecture - Special Interest Group)
      You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html
    * CAS :
      SSO solution developed by Yale University
      You can find the project page here : http://www.yale.edu/tp/auth
    * Cocoon :
      XML framework distributed by the Apache foundation under Apache license;
      Please find the full text here : http://cocoon.apache.org/2.1/license.html
    * Mod_dav:
      A DAV module for Apache web server
      You can find the project page here : http://www.webdav.org/mod_dav
    * IMP :
      webmail from Horde application framework
      You can find the project page here : http://www.horde.org
    * . To be completed
*/

package org.esupportail.portal.channels.CStockage.channelAction;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CStockage.channelAction.classic.sharing.GroupForSharing;
import org.esupportail.portal.channels.CStockage.channelAction.classic.sharing.SharingTool;
import org.esupportail.portal.channels.CStockage.channelAction.classic.sharing.UserForSharing;
import org.esupportail.portal.channels.CStockage.config.ChannelConfiguration;
import org.esupportail.portal.channels.CStockage.config.Space;
import org.esupportail.portal.channels.CStockage.exception.BadConnexionParameters;
import org.esupportail.portal.channels.CStockage.exception.CancelException;
import org.esupportail.portal.channels.CStockage.exception.ChannelException;
import org.esupportail.portal.channels.CStockage.exception.ConnexionParametersRequired;
import org.esupportail.portal.channels.CStockage.exception.DataBaseException;
import org.esupportail.portal.channels.CStockage.exception.PropertiesException;
import org.esupportail.portal.channels.CStockage.exception.ServerException;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.IServant;
import org.jasig.portal.PortalException;
import org.jasig.portal.UPFileSpec;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.utils.XSLT;
import org.xml.sax.ContentHandler;

/**
 * Id: AbstractChannelAction.java,v 1.0 24 sept. 2004
 * Copyright (c) 2004 Esup Portail (www.esup-portail.org)
 * Classes: AbstractChannelAction
 * Original Author: Yohan Colmant
 * 
 */
public abstract class AbstractChannelAction {
	
	

	/**
	 * Logger object
	 */
	protected static final Log log = LogFactory.getLog(AbstractChannelAction.class);
	
	
	
	
	
	/**
	 * the space containing this channel action
	 */
	protected Space currentSpace;
	
  	/**
	 * The default spaces
	 */
	protected ArrayList spaces;
	
	
	
	/**
	 * Object used to keep the objects used between 2 actions, for example, the clipboard
	 */
	protected BufferAction buffer;
	
	/**
	 * The user login in the portal
	 */
	protected String userPortalLogin;
	
	/**
	 * The groups of the user in the portal
	 */
	protected Vector userGroups;
	
	

	/**
	 * The servant channel used for groups and users selection
	 */
	protected IServant slave;
	

	/**
	 * The object used to manage the sharing of folder
	 */
	protected SharingTool sharingTool;
	
	

	/**
	 * The current user IPerson object
	 */
	private IPerson person;
	

	

	/**
	 * The stylesheet used
	 */
	protected StringBuffer stylesheet;
	
	
	
	/**
	 * Init the object used to manage the actions of the channel
	 * @param person the uportal person object
	 * @param currentSpace the current space used
	 * @param spaces all the spaces used
	 * @param buffer the buffer used to get for example the clipboard
	 * @param userPortalLogin The user login in the portal
	 * @param userGroups The groups of the user in the portal
	 * @throws ChannelException
	 */
	public void init(IPerson person, Space currentSpace, ArrayList spaces, BufferAction buffer, String userPortalLogin, Vector userGroups) throws ChannelException {
		this.person = person;
		this.currentSpace = currentSpace;		
		this.spaces = spaces;
		this.buffer = buffer;
		this.userPortalLogin = userPortalLogin;
		this.userGroups = userGroups;
		
		// init the sharing tool
		if (ChannelConfiguration.getInstance().isSpacesPersonalization())
			sharingTool = new SharingTool();		
	}
	
	
	
	/**
	 * Init the personal spaces into the menu
	 * @throws DataBaseException
	 */
	public void initPersonalSpacesIntoMenu() throws DataBaseException, ChannelException {

		// init the personal spaces
		if (ChannelConfiguration.getInstance().isSpacesPersonalization()) {
			setAvailableAndUsedSpaces();
			setSpacesIntoMenu();
		}
		
		// init each personal space connexion
		/*for (int i=0; i<spaces.size(); i++) {
			Space space = (Space)spaces.get(i);
			if (space.isPersonnalSpace() && space.getServerAccessObject()==null) {				
				//System.out.println("\n\n\n\n\n"+space.getLabel());
				// set the server access
				boolean serverOk = false;
				try {
					serverOk = space.setServerAccessObject();
				}
				catch(Exception e) {
					log.error("initPersonalSpacesIntoMenu"+" :: "+e);
					serverOk = false;
				}
				//System.out.println("   server ok ? "+serverOk);
				// set for the space, the channel action object used								
				boolean wellDone = false;
				if (serverOk) {
					wellDone = space.setChannelActionObject(spaces, config, buffer, userPortalLogin, this.userGroups);
					//System.out.println("   action ok ? "+wellDone);
				}
				if (!wellDone) {
					spaces.remove(i);
					i--;
				}
				
				
			}
						
		}*/
	}
	
	
	
	
	/**
	 * Manage the actions when refreshing the channel
	 * @param staticData the static data channel object
	 * @param runtimeData the runtime data channel object
	 * @param out the contentHandler used in the renderXml
	 * @param xslt the xslt motor object
	 * @param setStaticDataException the excpetion throwed in the setStaticData method
	 * @throws PortalException
	 */
	public void checkCalledAction(ChannelStaticData staticData, ChannelRuntimeData runtimeData, ContentHandler out, XSLT xslt, ChannelException setStaticDataException) throws PortalException {

		
		// the baseActionUrl
		String baseActionUrl = runtimeData.getBaseActionURL();
		
		// set the mod
		// in the channel, there are 2 action menus. 
		// those menus have the same name modeDav. 
		// To differentiate the menu that we have selected, we check the value of the both. 
		// the menu with a not null value is the one we have selected.  
		String currentMode = null;
		String[] mod=runtimeData.getParameterValues("modeDav");
		if (mod != null){
			for (int i = 0; i<mod.length;i++){
				if (!mod[i].equals("")) {
					currentMode = mod[i];
				}
			}
		}

		// log
		if (log.isDebugEnabled()){
			log.debug("checkCalledAction"+" :: currentMode = "+currentMode);
		}	
		
		// check if servant is active or not
		if (slave!=null) {
			slave.setRuntimeData(runtimeData);
			if (!slave.isFinished()) {								
				slave.renderXML(out);
				return;
			}
			else {								
				currentMode = Constants.VALID_SERVANT_RESULTS;
			}
		}
		
		// the string we will return
		StringBuffer xml = new StringBuffer();
		xml.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");		
		xml.append("<ROOT>");		
		
		// the stylesheet we are going to use
		stylesheet = new StringBuffer();

		// Xml string generated by the diferents methods
		StringBuffer xmlTemp = new StringBuffer();		
		
		try {

			// if password set
			try {				
				if (currentMode!=null && currentMode.equals(Constants.PASSWORD_MODE)) {
					String login = runtimeData.getParameter("loginOfUser");
					String password = runtimeData.getParameter("password");
					this.currentSpace.setLogin(login);
					this.currentSpace.setPassword(password);
					
					// if the login is different, we check the path if there is {storageFormLogin}
					this.currentSpace.checkPath(person);
					
					this.currentSpace.getServerAccessObject().init(this.currentSpace);
					currentMode = Constants.SHOW_CURRENT_DIR_MODE;
				}
			}
			catch(MalformedURLException e) {							
				if (log.isDebugEnabled()){
					log.debug("checkCalledAction"+" :: "+e);
				}
				throw new PropertiesException();
			}		
			
			
			// if none staticdata exception
			if (setStaticDataException==null) {
				
				// if it the asked authentication, and none password still set
				if (this.currentSpace.isAskedAuthentication() && this.currentSpace.getPassword()==null) {
					throw new ConnexionParametersRequired();
				}
				
				// else, connect to the server
				else {
					try {					
						this.currentSpace.getServerAccessObject().connect();												
						checkCurrentDirectoryProperties();						
					}
					catch(BadConnexionParameters e) {
						throw e;
					}
					catch(Exception e) {
						setStaticDataException= new ServerException();
					}
				}
			}			
			
			// check the setStaticDataException
			if (setStaticDataException!=null) {

				// log
				if (log.isDebugEnabled()){
					log.debug("checkCalledAction"+" :: setStaticDataException = "+setStaticDataException);
				}
				
				throw setStaticDataException;
			}
			
			
			// set the default mod
			if (currentMode == null) {			
				currentMode = Constants.SHOW_CURRENT_DIR_MODE;
			}

			//////////////////////////////////////////////////////
			// N A V I G A T I O N
			// Display the current directory
			if (currentMode.equals(Constants.SHOW_CURRENT_DIR_MODE)) {				
				stylesheet = new StringBuffer("CStockage");
				xmlTemp = renderXmlShowCurrentDir(runtimeData);							
			}
			// Go to the parent directory
			else if (currentMode.equals(Constants.DIRECTORY_BACK)) {	
				directoryBack();
				stylesheet = new StringBuffer("CStockage");
				xmlTemp = renderXmlShowCurrentDir(runtimeData);							
			}
			

			//////////////////////////////////////////////////////
			// S H A R I N G
			// Manage the shared spaces 
			else if (currentMode.equals(Constants.MANAGE_SHARED_SPACES)) {				
				stylesheet = new StringBuffer("manageSharedSpaces");
				xmlTemp = renderXmlManageSharedSpaces(runtimeData);					
			}

			
			//////////////////////////////////////////////////////
			// S P E C I F I C    A C T I O N
			else  {	
				xmlTemp = specificCheckCalledAction(currentMode, staticData, runtimeData, out, xslt, setStaticDataException);
				if (xmlTemp == null)
					return;
			}

			 
			xml.append(xmlTemp);						
		}		
		catch(BadConnexionParameters e) {
			stylesheet = new StringBuffer("CStockage");
			try {
				xml.append(renderXmlBadConnexionParametersException(e));
				
				// log
				if (log.isDebugEnabled()){
					log.debug("checkCalledAction"+" :: "+e);
				}
			}
			catch(PropertiesException ex) {
				xml.append(renderXmlChannelException(ex));
			}
		}
		catch(ConnexionParametersRequired e) {
			stylesheet = new StringBuffer("CStockage");			
			try {
				xml.append(renderXmlBadConnexionParametersException(e));
				
				// log
				if (log.isDebugEnabled()){
					log.debug("checkCalledAction"+" :: "+e);
				}
			}
			catch(PropertiesException ex) {
				xml.append(renderXmlChannelException(ex));
			}
		}
		catch(ChannelException e) {			
			stylesheet = new StringBuffer("CStockage");
			xml.append(renderXmlChannelException(e));
			// log
			if (log.isDebugEnabled()){
				log.debug("checkCalledAction"+" :: "+e);
			}
		}
		
		try {
			// discconnect from the dav
			this.currentSpace.getServerAccessObject().disconnect();
		}
		catch (Exception e) {
			// log
			if (log.isDebugEnabled()){
				log.debug("checkCalledAction"+" :: "+e);
			}
		}
		// System.out.println(xml+"\n\n\n");
		
		// set the stylesheet and the parameters

		//specify the stylesheet selector		
		xslt.setXSL("CStockage.ssl", stylesheet.toString(), runtimeData.getBrowserInfo());		
		
		//url to the channel
		xslt.setStylesheetParameter("baseActionURL",baseActionUrl);				
		
		//url to the download worker
		String downloadUrl = runtimeData.getBaseWorkerURL(UPFileSpec.FILE_DOWNLOAD_WORKER,true).replaceAll("%2F","/");
		xslt.setStylesheetParameter( "downloadURL", downloadUrl);	
		
		// the parameter to know if there is a resource in the clipboard
		if (buffer.getClipboard() != null)
			xslt.setStylesheetParameter("isClipboardEmpty","false");			      
		
		// the parameter used in the copy/move mode. tell if the mode is copy or move
		String clipboardParameter = buffer.getClipboardParameter();
		if (clipboardParameter != null) {
			xslt.setStylesheetParameter("clipboardParameter",clipboardParameter);			

		}

		// if we redirect in https
		try {
			xslt.setStylesheetParameter("redirection", ChannelConfiguration.getInstance().isHttpsRedirection()+"");
		}
		catch(PropertiesException e) {
			xslt.setStylesheetParameter("redirection", "false");
			
			// log
			if (log.isDebugEnabled()){
				log.debug("checkCalledAction"+" :: "+e);
			}
		}
		
		// the final balise
		xml.append("</ROOT>");

		//System.out.println(xml+"\n\n");
		
		//pass the result XML to the styling engine.
		String s = xml.toString();		
		xslt.setXML(s);		

		// set the output Handler for the output.
		xslt.setTarget(out);
	
		// do the deed
		xslt.transform();	
	}
	
	
	
	
	/**
	 * For the selected mode, we check the properties of the current directory
	 * @throws Exception
	 */
	protected abstract void checkCurrentDirectoryProperties() throws Exception;
	
	
	
	
	/**
	 * Return the xml when we have to show a information message
	 * @return the xml when we have to show a information message
	 */
	protected abstract StringBuffer renderXmlWithInformation(String informationCode) throws PropertiesException ;
	
	
	/**
	 * Return the xml when we have a BadConnexionParameters exception
	 * @param e the throwed exception
	 * @return the xml when we have a BadConnexionParameters exception
	 */
	protected abstract StringBuffer renderXmlBadConnexionParametersException(ChannelException e) throws PropertiesException;
	
	
	/**
	 * Return the xml when we have a ChannelException exception
	 * @param e the throwed exception
	 * @return the xml when we have a ChannelException exception
	 */
	protected abstract StringBuffer renderXmlChannelException(ChannelException e);
	
	

	
	
	
	
	
	/**
	 * Manage the specific actions when refreshing the channel for the specific channel mode
	 * @param currentMode the current channel mode
	 * @param staticData the static data channel object
	 * @param runtimeData the runtime data channel object
	 * @param out the contentHandler used in the renderXml
	 * @param xslt the xslt motor object
	 * @param setStaticDataException the excpetion throwed in the setStaticData method
	 * @throws PortalException
	 */
	public abstract StringBuffer specificCheckCalledAction(String currentMode, ChannelStaticData staticData, ChannelRuntimeData runtimeData, ContentHandler out, XSLT xslt, ChannelException setStaticDataException) throws ChannelException, PortalException ;
	
	
	
	
	
	
	

	/**
	 * Generate the XML String for this mod
	 * @param runtimeData the runtime data channel object
	 * @return le XML pour ce mode
	 * @throws ChannelException
	 */
	protected abstract StringBuffer renderXmlShowCurrentDir(ChannelRuntimeData runtimeData) throws ChannelException;
	
	
	/**
	 * Go to the parent directory
	 * @throws ChannelException
	 */
	protected abstract void directoryBack() throws ChannelException;
	
	
	
	
	
	
	



	/**************************
	 *   Manage shared spaces
	 **************************/
		
	
	/**
	 * The spaces still in use
	 */
	private TreeMap usedSpaces;
	
	/**
	 * The avalaible spaces
	 */
	private TreeMap availableSpaces;
	
	
	
	

	/**
	 * Generate the XML when we want to manage the shared spaces
	 * @param runtimeData the runtime data channel object
	 * @return the XML for this mode
	 * @throws CancelException
	 * @throws DataBaseException
	 */
	private StringBuffer renderXmlManageSharedSpaces(ChannelRuntimeData runtimeData) throws ChannelException, PropertiesException, CancelException, DataBaseException, ServerException {
		
		// if it is the first call
		if (usedSpaces == null && availableSpaces == null) {
			setAvailableAndUsedSpaces();
		}
		
		// if cancel
		String action = runtimeData.getParameter("action");
		if (action!=null) {
			if (action.equals("cancel")) {
				renderXmlManageSharedSpacesCancel();
			}
			
			// if valid		
			if (action.equals("valid")) {
				return renderXmlManageSharedSpacesValid(runtimeData);
			}
		}
		
		// if add
		String add = runtimeData.getParameter("add");
		if (add != null) {
			renderXmlManageSharedSpacesAdd(runtimeData);
		}

		// if delete
		String delete = runtimeData.getParameter("delete");
		if (delete != null) {
			renderXmlManageSharedSpacesDelete(runtimeData);
		}
		
		// generate the xml
		return renderXmlManageSharedSpacesGetXmlForRender(runtimeData);
	}
	
	
	
	/**
	 * Set the used spaces and the avalaible spaces for this user
	 */
	private void setAvailableAndUsedSpaces() throws DataBaseException, PropertiesException {
		
		usedSpaces = new TreeMap();
		availableSpaces = new TreeMap();
		
		// we get each space from the preferences user
		Vector idUsedUsers = this.sharingTool.getIdOfSpaceFromPreferencesUser(userPortalLogin);		
		
		// get each shared space for the current user
		Vector spaces = this.sharingTool.getAvailableSpacesForUser(userPortalLogin, userPortalLogin);
		for (int i=0; i<spaces.size(); i++) {
			Space space = (Space)spaces.elementAt(i);
			
			String id = space.getIdInDatabase();
			if (!idUsedUsers.contains(id)) {
				if (!availableSpaces.containsKey(id))
					availableSpaces.put(id, space);
			}
			else {
				if (!usedSpaces.containsKey(id))
					usedSpaces.put(id, space);
			}
		}
		

		// get each shared space for the groups of the current user
		for (int g=userGroups.size()-1; g>=0; g--) {
			spaces = this.sharingTool.getAvailableSpacesForGroup((String)userGroups.elementAt(g), userPortalLogin);
			for (int i=0; i<spaces.size(); i++) {
				Space space = (Space)spaces.elementAt(i);
				
				String id = space.getIdInDatabase();
				if (!idUsedUsers.contains(id)) {
					if (!availableSpaces.containsKey(id))
						availableSpaces.put(id, space);
				}
				else {
					if (!usedSpaces.containsKey(id))
						usedSpaces.put(id, space);
				}
					
			}
		}
		
	}
	
	
	

	/**
	 * Generate the XML when we want to manage the shared spaces
	 * @param runtimeData the runtime data channel object
	 * @return the XML for this mode
	 * @throws CancelException
	 */
	private StringBuffer renderXmlManageSharedSpacesGetXmlForRender(ChannelRuntimeData runtimeData) throws ServerException, PropertiesException  {
		
		StringBuffer xml = new StringBuffer();
		
		xml.append("<used>");
		xml.append(renderXmlManageSharedSpacesGetXmlForRenderOnlySpaces(usedSpaces));		
		xml.append("</used>");
		
		xml.append("<available>");		
		xml.append(renderXmlManageSharedSpacesGetXmlForRenderOnlySpaces(availableSpaces));
		xml.append("</available>");
		
		return xml;
	}
	
	
	
	
	/**
	 * Generate the XML when we want to manage the shared spaces
	 * @param spaces spaces list
	 * @return the XML for this mode
	 * @throws ServerException
	 * @throws PropertiesException
	 */
	private StringBuffer renderXmlManageSharedSpacesGetXmlForRenderOnlySpaces(TreeMap spaces) throws ServerException, PropertiesException  {
		
		StringBuffer xmlReadOnly = new StringBuffer();
		StringBuffer xmlWrite = new StringBuffer();
		StringBuffer xmlManage = new StringBuffer();
				
		Iterator used = spaces.values().iterator();
		while (used.hasNext()) {			
			Space space = (Space)used.next();			
			String target = null;
			if (space.isSharedForTheUser()) {
				target = new UserForSharing(space.getTargetOfSharing()).getDisplayName();
			}
			else {
				target = new GroupForSharing(space.getTargetOfSharing(), null).getDisplayName();
			}
			
			if (!space.userCanWrite()) {
				xmlReadOnly.append("<space key=\""+space.getIdInDatabase()+"\" writing=\""+space.userCanWrite()+"\" from=\""+(new UserForSharing(space.getOwner()).getDisplayName())+"\" target=\""+target+"\">"+space.getLabel()+"</space>");
			}
			else {
				if (!space.isSharing()) {
					xmlWrite.append("<space key=\""+space.getIdInDatabase()+"\" writing=\""+space.userCanWrite()+"\" from=\""+(new UserForSharing(space.getOwner()).getDisplayName())+"\" target=\""+target+"\">"+space.getLabel()+"</space>");
				}
				else {
					xmlManage.append("<space key=\""+space.getIdInDatabase()+"\" writing=\""+space.userCanWrite()+"\" from=\""+(new UserForSharing(space.getOwner()).getDisplayName())+"\" target=\""+target+"\">"+space.getLabel()+"</space>");
				}
			}
		}				
		
		StringBuffer xml = new StringBuffer();
		xml.append("<read_only>");
		xml.append(xmlReadOnly);
		xml.append("</read_only>");
		xml.append("<read_and_write>");
		xml.append(xmlWrite);
		xml.append("</read_and_write>");
		xml.append("<read_and_write_and_manage>");
		xml.append(xmlManage);
		xml.append("</read_and_write_and_manage>");
		return xml;
	}
	
	

	/**
	 * Generate the XML when we click on "cancel" when we manage the shared spaces
	 * @throws CancelException
	 */
	private void renderXmlManageSharedSpacesCancel() throws CancelException {
		usedSpaces = null;
		availableSpaces = null;
		throw new CancelException();
	}
	
	
	/**
	 * Set the personal spaces into the spaces menu
	 * @throws DataBaseException
	 */
	private void setSpacesIntoMenu() throws DataBaseException, ChannelException {			

		// delete each space wich has been deleted from the database and from the spaces list
		for (int i=0; i<spaces.size(); i++) {
			Space s = (Space)spaces.get(i);
			
			if (s.isPersonnalSpace() && !usedSpaces.containsKey(s.getIdInDatabase())) {
				
				// delete from the database
				sharingTool.delStorageUsersPreferencesForUser(s.getIdInDatabase(), userPortalLogin);								
				
				// delete from the list
				spaces.remove(i);
				i--;
				
				// if the space deleted is the current space
				if (s.getIdInDatabase().equals(currentSpace.getIdInDatabase())) {
					currentSpace = (Space)spaces.get(0);
				}
			}
		}
		
		// add each used space into the list and in the user preferences
		Iterator used = usedSpaces.values().iterator();
		while(used.hasNext()) {
			Space s = (Space)used.next();
			
			if (!spaces.contains(s)) {
				
				// add into the user preferences
				String spaceId = s.getIdInDatabase();
				sharingTool.addStorageUsersPreferences(spaceId, userPortalLogin);
				
				// add into the used list
				spaces.add(s);			
			}
		}
		
		// init each personal space connexion
		for (int i=0; i<spaces.size(); i++) {
			Space space = (Space)spaces.get(i);
			if (space.isPersonnalSpace() && space.getServerAccessObject()==null) {				
				//System.out.println("\n\n\n\n\n"+space.getLabel());
				// set the server access
				boolean serverOk = false;
				try {
					serverOk = space.setServerAccessObject();
				}
				catch(Exception e) {
					log.error("initPersonalSpacesIntoMenu"+" :: "+e);
					//serverOk = false;
				}
				//System.out.println("   server ok ? "+serverOk);
				// set for the space, the channel action object used
				
				boolean wellDone = false;
				//if (serverOk) {
					wellDone = space.setChannelActionObject(person, spaces, buffer, userPortalLogin, this.userGroups);
					//System.out.println("   action ok ? "+wellDone);
				/*}				

				if (!wellDone) {
					spaces.remove(i);
					i--;
				}*/
				
				
			}
						
		}
		
		usedSpaces = null;
		availableSpaces = null;		
	}
	
	

	/**
	 * Generate the XML when we click on "valid" when we manage the shared spaces
	 * @param runtimeData the runtime data channel object
	 * @return the XML for this mode
	 * @throws DataBaseException
	 */
	private StringBuffer renderXmlManageSharedSpacesValid(ChannelRuntimeData runtimeData) throws DataBaseException, ChannelException {
		setSpacesIntoMenu();
		
		return renderXmlWithInformation("2015");
	}
	
	
	


	/**
	 * Generate the XML when we click on "add" when we manage the shared spaces
	 * @param runtimeData the runtime data channel object
	 * @return the XML for this mode
	 */
	private StringBuffer renderXmlManageSharedSpacesAdd(ChannelRuntimeData runtimeData) throws ServerException, PropertiesException  {
		
		/*Iterator iter = usedSpaces.values().iterator();
		while(iter.hasNext()) {
			System.out.println(iter.next());
		}*/
		
		
		// we check the selected spaces, remove them from "availableSpaces" and add to "usedSpaces"
		String[] available = runtimeData.getParameterValues("available");
		for (int i=0; available!=null && i<available.length; i++) {
			String spaceId = available[i];
			Space space = (Space)availableSpaces.remove(spaceId);
			usedSpaces.put(spaceId, space);
		}		
		
		return renderXmlManageSharedSpacesGetXmlForRender(runtimeData);
	}
	
	

	/**
	 * Generate the XML when we click on "delete" when we manage the shared spaces
	 * @param runtimeData the runtime data channel object
	 * @return the XML for this mode
	 */
	private StringBuffer renderXmlManageSharedSpacesDelete(ChannelRuntimeData runtimeData) throws ServerException, PropertiesException  {

		// we check the selected spaces, remove them from "usedSpaces" and add to "availableSpaces"
		String[] used = runtimeData.getParameterValues("used");
		for (int i=0; used!=null && i<used.length; i++) {
			String spaceId = used[i];
			Space space = (Space)usedSpaces.remove(spaceId);
			availableSpaces.put(spaceId, space);
		}	
		
		return renderXmlManageSharedSpacesGetXmlForRender(runtimeData);
	}
	
}
