/*
ESUP-portail is a french academic project developed under the GPL (General Public License) augmented according to the following :
A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.
The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .
A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .
The different kinds of licenses governing the products developed by the Apache foundation can be found here : http://www.apache.org/licenses .
It follows that you can as well as use download contents as well modify and redistribute them provided you respect the GPL terms.
Downloading and using such contents do not provide any guaranty.
Be sure that you have well understood the terms of the license before using the contents it covers.
The ESUP-portail distribution includes the following distributions :
    * UPortal : 
      software developed by JA-SIG (Java Architecture - Special Interest Group)
      You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html
    * CAS :
      SSO solution developed by Yale University
      You can find the project page here : http://www.yale.edu/tp/auth
    * Cocoon :
      XML framework distributed by the Apache foundation under Apache license;
      Please find the full text here : http://cocoon.apache.org/2.1/license.html
    * Mod_dav:
      A DAV module for Apache web server
      You can find the project page here : http://www.webdav.org/mod_dav
    * IMP :
      webmail from Horde application framework
      You can find the project page here : http://www.horde.org
    * . To be completed
*/
package org.esupportail.portal.channels.CStockage.channelAction.classic.sharing;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ojb.broker.util.GUID;
import org.esupportail.portal.channels.CStockage.config.ChannelConfiguration;
import org.esupportail.portal.channels.CStockage.exception.DataBaseException;
import org.esupportail.portal.channels.CStockage.exception.PropertiesException;
import org.esupportail.portal.utils.database.Database;
import org.esupportail.portal.utils.database.Query;




/**
 * Id: DataBaseAccess.java,v 1.0 13 janv. 2005
 * Copyright (c) 2005 Esup Portail (www.esup-portail.org)
 * Classes: DataBaseAccess
 * Original Author: Yohan Colmant
 * This class manage the access to the database, for the sharing actions.
 */
public class DataBaseAccess {


	/**
	 * Logger object
	 */
	protected static final Log log = LogFactory.getLog(DataBaseAccess.class);
	
	
	
	/**
	 * If the database parameters are still initialized
	 */
	public static boolean initialized = false;
	
	
	
	
	/**
	 * The database access object
	 */
	private static Database dataBaseAccess;
	
	
	
	

	/**
	 * Constructor
	 * Initialize the parameters for a connexion to the database
	 * @throws PropertiesException
	 */
	public DataBaseAccess() throws PropertiesException {
		
		ChannelConfiguration config = ChannelConfiguration.getInstance();
		
		// init the static parameters
		if (!initialized) {
			dataBaseAccess = config.getPool();	
		}
		
	}
	
	
	

	/**
	 * Connect to the database
	 * @throws DataBaseException
	 */
	/*public void connect() throws DataBaseException {
		try {
	    	if (cnt==null || cnt.isClosed()) {
	    		Class.forName(dataBaseDriver);
	    		cnt = DriverManager.getConnection(dataBaseURL, dataBaseLogin, dataBasePassword);
	    	}
	    }
		catch(ClassNotFoundException e) {						
			log.error("connect :: "+ e);
			throw new DataBaseException();
		}
		catch(SQLException e) {						
			log.error("connect :: "+ e);
			throw new DataBaseException();
		}
	}*/
		
	
	
	
	/**
	 * Disconnection from the database
	 */
	/*public void disconnect() {
		try {			
			if (!cnt.isClosed())
				cnt.close();			
	    }		
		catch(SQLException e) {					
			log.error("disconnect :: "+ e);
		}
	}*/
	
	
	
	
	/**
	 * Add sharing properties into the database
	 * @param serverUrl the url of the server
	 * @param path the resource path
	 * @param label the space's label
	 * @param targetKey the key of the target user
	 * @param ownerUserKey the key of the owner
	 * @param xmlSpace the space into an xml format
	 * @param reading if we have the reading rights
	 * @param writing if we have the writing rights
	 * @param manage if we have the sharing rights
	 * @return the result of the query
	 * @throws DataBaseException
	 */
	public int addStorageAvailableSpace(String serverUrl, String path, String label, String targetKey, boolean targetIsUser, String ownerUserKey, String xmlSpace, boolean reading, boolean writing, boolean manage) throws DataBaseException {

		try {
			
			// the query manager
			Query queryManager = new Query(dataBaseAccess);
			
			// check if it is still shared
			boolean isShared = isAlreadyAvailableForTarget(queryManager, serverUrl, path, targetKey, targetIsUser);
			if (isShared)
				return 1;
		
			
			// the SQL query
			String query = QueriesManagement.getQuery(QueriesManagement.ADD_STORAGE_AVAILABLE_SPACE);		
			
			// prepare the SQL query	    	   		    	    	
			queryManager.setSql(query);

			// the id
			queryManager.getStmt().setString(1,new GUID().toString());
			
			// the server url
			queryManager.getStmt().setString(2,serverUrl);
			
			// the path
			queryManager.getStmt().setString(3,path);

			// the label
			queryManager.getStmt().setString(4,label);
			
			// the key of the target
			queryManager.getStmt().setString(5,targetKey);

			// the target is a user or a group
			if (targetIsUser)
				queryManager.getStmt().setString(6, "T");
			else queryManager.getStmt().setString(6, "F");
			
			// the key of the owner
			queryManager.getStmt().setString(7, ownerUserKey);
			
			// the space in the xml form
			queryManager.getStmt().setString(8, xmlSpace);
			
			// reading
			if (reading)
				queryManager.getStmt().setString(9, "T");
			else queryManager.getStmt().setString(9, "F");
			
			// writing
			if (writing)
				queryManager.getStmt().setString(10, "T");
    		else queryManager.getStmt().setString(10, "F");

			// manage
			if (manage)
				queryManager.getStmt().setString(11, "T");
    		else queryManager.getStmt().setString(11, "F");
			
			// execute the query			
			int res = queryManager.update();
    	
			// close
			queryManager.close();
			
			// return the result
			return res;
			
		}
		catch(SQLException e) {
			log.error("addStorageAvailableSpace :: "+ e);
			throw new DataBaseException();
		}
	}
	

	
	
	
	
	
	/**
	 * Delete sharing properties into the database
	 * @param id the space id
	 * @return the result of the query
	 * @throws DataBaseException
	 */
	public int delStorageAvailableSpace(String id) throws DataBaseException {

		try {

			// the query manager
			Query queryManager = new Query(dataBaseAccess);			
			
			// the SQL query
			String query = QueriesManagement.getQuery(QueriesManagement.DEL_STORAGE_AVAILABLE_SPACE);		
			
			// prepare the SQL query	    	   		    	    	
			queryManager.setSql(query);

			// the server url
			queryManager.getStmt().setString(1,id);

			// execute the query			
			int res = queryManager.update();
    	
			// close
			queryManager.close();
			
			// return the result
			return res;
		}
		catch(SQLException e) {
			log.error("delStorageAvailableSpace :: "+ e);
			throw new DataBaseException();
		}
	}
	
	
	
	
	
	/**
	 * Get the users for whose the resource is shared
	 * @param serverUrl the url of the server
	 * @param path the path of the resource
	 * @param targetIsUser to know if the target of this sharing is a user or not
	 * @return a vector. Each element is an array of [id, label, targetKey, read:'T'|'F', write:'T'|'F', manage:'T'|'F']
	 * @throws DataBaseException
	 */
	public Vector getTargetsOfAvailableSpace(String serverUrl, String path, boolean targetIsUser) throws DataBaseException {
		
		try {		

			// the query manager
			Query queryManager = new Query(dataBaseAccess);
			
			// the query
			String query = QueriesManagement.getQuery(QueriesManagement.GET_TARGET_OF_AVAILABLE_SPACE);
			
			// prepare statement
			queryManager.setSql(query);
	    	
			// the server url
			queryManager.getStmt().setString(1,serverUrl);
			
			// the path
			queryManager.getStmt().setString(2,path);

			// the target is a user or a group
			if (targetIsUser)
				queryManager.getStmt().setString(3, "T");
			else queryManager.getStmt().setString(3, "F");
			
			// execute the query
			queryManager.select();
			ResultSet rs = queryManager.getRs();
			
			// the list of results
			Vector results = new Vector();
			
			// get each result
			while (queryManager.getRs().next()) {
				
				// a result line
				String[] line = new String[6];

				// the id
				String id = rs.getString(1);
				line[0] = id;
				
				// the label
				String label = rs.getString(2);
				line[1] = label;
				
				// the target user key
				String targetKey = rs.getString(3);
				line[2] = targetKey;

				// the reading
				String read = rs.getString(4);
				line[3] = read;
				
				// the writing
				String write = rs.getString(5);
				line[4] = write;	
				
				// the management
				String manage = rs.getString(6);
				line[5] = manage;	
				
				// add to the result
				results.add(line);
			}
	      
			// close the result
			queryManager.close();
	    	
	    	return results;
		}
		catch(SQLException e) {			
			log.error("getTargetsOfAvailableSpacesForOwner :: "+ e);
			throw new DataBaseException();
		}				
	}
	
	
	
	
	
	

	/**
	 * Check if the space is already shared for a specified user
	 * @param queryManager the query manager for the database access
	 * @param serverUrl the url of the server
	 * @param path the path of the resource
	 * @param targetKey the key of the user we want to check
	 * @param targetIsUser to know if the target of this sharing is a user or not
	 * @return true if already shared, else false
	 * @throws DataBaseException
	 */
	private boolean isAlreadyAvailableForTarget(Query queryManager, String serverUrl, String path, String targetKey, boolean targetIsUser) throws DataBaseException {
			
		try {

			// the query
			String query = QueriesManagement.getQuery(QueriesManagement.IS_ALREADY_AVAILABLE_FOR_TARGET);
			
			// prepare statement
			queryManager.setSql(query);
	    	
			// the server url
			queryManager.getStmt().setString(1,serverUrl);
			
			// the path
			queryManager.getStmt().setString(2,path);

			// the target user key
			queryManager.getStmt().setString(3,targetKey);

			// the target is a user or a group
			if (targetIsUser)
				queryManager.getStmt().setString(4, "T");
			else queryManager.getStmt().setString(4, "F");
			
			// execute the query
			queryManager.select();
	    	
			// is shared ?
			boolean isShared = queryManager.getRs().next();

			// close the result
			//queryManager.close();
	    				
			return isShared;
		}
		catch(SQLException e) {			
			log.error("isAlreadyAvailableForTarget :: "+ e);
			throw new DataBaseException();
		}		
	}
	
	
	
	

	
	

	
	/**
	 * Update the label of the sharing properties into the database
	 * @param newLabel the new label of the shared spaces
	 * @param serverUrl the url of the server
	 * @param path the resource path
	 * @return the result of the query
	 * @throws DataBaseException
	 */
	public int updateLabelAvailableSpace(String newLabel, String serverUrl, String path) throws DataBaseException {
		
		try {

			// the query manager
			Query queryManager = new Query(dataBaseAccess);			
			
			// the SQL query
			String query = QueriesManagement.getQuery(QueriesManagement.UPDATE_LABEL_AVAILABLE_SPACE);		
			
			// prepare the SQL query	    	   		    	    	
			queryManager.setSql(query);

			// the new label
			queryManager.getStmt().setString(1,newLabel);
			
			// the server url
			queryManager.getStmt().setString(2,serverUrl);
			
			// the path
			queryManager.getStmt().setString(3,path);
			
			// execute the query
			int res = queryManager.update();

			// close
			queryManager.close();
			
			// return the result
			return res;	
		}
		catch(SQLException e) {
			log.error("updateLabelAvailableSpace :: "+ e);
			throw new DataBaseException();
		}
	}
	
	
	
	
	
	/**
	 * Update the "reading" and "writing" attributes for a specifical sharing
	 * @param reading the reading value 'T' or 'F'
	 * @param writing the writing value 'T' or 'F'
	 * @param manage the manage value 'T' or 'F'
	 * @param serverUrl the url of the server
	 * @param path the resource path
	 * @param targetKey the key of the target
	 * @param targetIsUser to know if the target of this sharing is a user or not
	 * @return the result of the query
	 * @throws DataBaseException
	 */
	public int updateReadAndWriteAndManageSpaceUser(boolean reading, boolean writing, boolean manage, String serverUrl, String path, String targetKey, boolean targetIsUser) throws DataBaseException {
	
		try {

			// the query manager
			Query queryManager = new Query(dataBaseAccess);
			
			// the SQL query
			String query = QueriesManagement.getQuery(QueriesManagement.UPDATE_READ_AND_WRITE_AND_MANAGE_SPACE);		
			
			// prepare the SQL query	    	   		    	    	
			queryManager.setSql(query);

			// the reading
			if (reading)
				queryManager.getStmt().setString(1, "T");
			else queryManager.getStmt().setString(1, "F");			
			
			// the writing
			if (writing)
				queryManager.getStmt().setString(2, "T");
			else queryManager.getStmt().setString(2, "F");

			// the management
			if (manage)
				queryManager.getStmt().setString(3, "T");
			else queryManager.getStmt().setString(3, "F");
			
			// the server url
			queryManager.getStmt().setString(4,serverUrl);
			
			// the path
			queryManager.getStmt().setString(5,path);

			// the key of the target
			queryManager.getStmt().setString(6,targetKey);			

			// the target is a user or a group
			if (targetIsUser)
				queryManager.getStmt().setString(7, "T");
			else queryManager.getStmt().setString(7, "F");
			
			// execute the query
			int res = queryManager.update();

			// close
			queryManager.close();
			
			// return the result
			return res;	
		}
		catch(SQLException e) {
			log.error("updateReadAndWriteAndManageSpaceUser :: "+ e);
			throw new DataBaseException();
		}
	}
	
	
	

	
	
	/**
	 * Get the available spaces for a group or a user
	 * @param targetKey the key of the target
	 * @param targetIsUser to know if the target of this sharing is a user or not
	 * @return a vector. Each element is an array of [id, url, path, label, owner, xmlSpace, read:'T'|'F', write:'T'|'F']
	 * @throws DataBaseException
	 */
	public Vector getAvailableSpacesForTarget(String targetKey, boolean targetIsUser) throws DataBaseException {

		try {

			// the query manager
			Query queryManager = new Query(dataBaseAccess);
			
			// the query
			String query = QueriesManagement.getQuery(QueriesManagement.GET_AVAILABLE_SPACES_FOR_TARGET);
			
			// prepare statement
			queryManager.setSql(query);
	    	
			// the target
			queryManager.getStmt().setString(1, targetKey);

			// the target is a user or a group
			if (targetIsUser)
				queryManager.getStmt().setString(2, "T");
			else queryManager.getStmt().setString(2, "F");
			
			// execute the query
			queryManager.select();
			ResultSet rs = queryManager.getRs();
	    	
			// the list of results
			Vector results = new Vector();
			
			// get each result
			while (rs.next()) {
				
				// a result line
				String[] line = new String[9];

				// the id
				String id = rs.getString(1);
				line[0] = id;

				// the url of the server
				String url = rs.getString(2);
				line[1] = url;

				// the path
				String path = rs.getString(3);
				line[2] = path;
				
				// the label
				String label = rs.getString(4);
				line[3] = label;

				// the owner
				String owner = rs.getString(5);
				line[4] = owner;

				// the xml space
				String xmlSpace = rs.getString(6);
				line[5] = xmlSpace;
				
				// the reading
				String read = rs.getString(7);
				line[6] = read;
				
				// the writing
				String write = rs.getString(8);
				line[7] = write;

				// the management
				String manage = rs.getString(9);
				line[8] = manage;
				
				// add to the result
				results.add(line);
			}

			// close
			queryManager.close();
			
	    	return results;
		}
		catch(SQLException e) {			
			log.error("getAvailableSpacesForTarget :: "+ e);
			throw new DataBaseException();
		}				
	}
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	/**
	 * Add a user preference into the database
	 * @param id the id of the sharement in the other database
	 * @param userKey the key of the user who wants to add preference into the database
	 * @return the result of the query
	 * @throws DataBaseException
	 */
	public int addStorageUsersPreferences(String id, String userKey) throws DataBaseException {
		
		try {

			// the query manager
			Query queryManager = new Query(dataBaseAccess);
			
			// check if it is still shared
			boolean isShared = isAlreadyInPreferencesForUser(queryManager, id, userKey);
			if (isShared)
				return 1;
			
			// the SQL query
			String query = QueriesManagement.getQuery(QueriesManagement.ADD_STORAGE_USERS_PREFERENCES);		
			
			// prepare the SQL query	    	   		    	    	
			queryManager.setSql(query);
			
			// the id key
			queryManager.getStmt().setString(1,new GUID().toString());
			
			// the id of available space
			queryManager.getStmt().setString(2,id);

			// the user key
			queryManager.getStmt().setString(3,userKey);
			
			// execute the query
			int res = queryManager.update();

			// close
			queryManager.close();
			
			// return the result
			return res;	
		}
		catch(SQLException e) {
			log.error("addStorageUsersPreferences :: "+ e);
			throw new DataBaseException();
		}
	}
	
	
	
	
	


	/**
	 * Check if the space is already in the user preferences
	 * @param queryManager the query manager to access the database
	 * @param id the id of the shared space
	 * @param userKey the key of the user to check
	 * @return true if already shared, else false
	 * @throws DataBaseException
	 */
	private boolean isAlreadyInPreferencesForUser(Query queryManager, String id, String userKey) throws DataBaseException {
		
		try {					    				
			// the query
			String query = QueriesManagement.getQuery(QueriesManagement.IS_ALREADY_IN_PREFERENCES_FOR_A_USER);

			// prepare statement
			queryManager.setSql(query);
	    	
			// the id
			queryManager.getStmt().setString(1, id);

			// the user key
			queryManager.getStmt().setString(2,userKey);
			
			// execute the query
			queryManager.select();
	    	
			// is shared ?
			boolean isShared = queryManager.getRs().next();
			
			// close the result
			//queryManager.close();
	    	
	    	return isShared;
		}
		catch(SQLException e) {			
			log.error("isAlreadyInPreferencesForUser :: "+ e);
			throw new DataBaseException();
		}				
	}
	
	

	
	

	/**
	 * Get the list of ids of spaces which has already been selected by the current user
	 * @param targetKey the user or group target key
	 * @return a Vector
	 * @throws DataBaseException
	 */
	public Vector getIdOfSpaceFromPreferences(String targetKey) throws DataBaseException {
		
		try {	

			// the query manager
			Query queryManager = new Query(dataBaseAccess);
			
			// the query
			String query = QueriesManagement.getQuery(QueriesManagement.GET_ID_OF_SPACE_FROM_PREFERENCES);
			
			// prepare statement
			queryManager.setSql(query);
	    	
			// the target
			queryManager.getStmt().setString(1, targetKey);
			
			// execute the query
			queryManager.select();
			ResultSet rs = queryManager.getRs();
	    	
			// the result
			Vector result = new Vector();
			
			// for each element
			while (rs.next()) {
				result.add(rs.getString(1));
			}

			// close
			queryManager.close();
			
	    	return result;
		}
		catch(SQLException e) {			
			log.error("getIdOfSpaceFromPreferences :: "+ e);
			throw new DataBaseException();
		}				
	}
	
	

	/**
	 * Delete a user preference from the database
	 * @param id the id of the sharement in the other database
	 * @param userKey the key of the user
	 * @return the result of the query
	 * @throws DataBaseException
	 */
	public int delStorageUsersPreferencesForUser(String id, String userKey) throws DataBaseException {
		//System.out.println(id+" for "+userKey);
		try {

			// the query manager
			Query queryManager = new Query(dataBaseAccess);
			
			// the SQL query
			String query = QueriesManagement.getQuery(QueriesManagement.DEL_STORAGE_USERS_PREFERENCES_FOR_USER);		
			
			// prepare the SQL query	    	   		    	    	
			queryManager.setSql(query);

			// the id
			queryManager.getStmt().setString(1,id);

			// the user key
			queryManager.getStmt().setString(2,userKey);
			
			// execute the query
			int res = queryManager.update();

			// close
			queryManager.close();
			
			// return the result
			return res;	
		}
		catch(SQLException e) {
			log.error("delStorageUsersPreferencesForUser :: "+ e);
			throw new DataBaseException();
		}
	}
	
	

	/**
	 * Delete users preferences for a shared space from the database
	 * @param id the id of the sharement in the other database
	 * @return the result of the query
	 * @throws DataBaseException
	 */
	public int delStorageUsersPreferences(String id) throws DataBaseException {
		//System.out.println(id+" for "+userKey);
		try {

			// the query manager
			Query queryManager = new Query(dataBaseAccess);
			
			// the SQL query
			String query = QueriesManagement.getQuery(QueriesManagement.DEL_STORAGE_USERS_PREFERENCES);		
			
			// prepare the SQL query	    	   		    	    	
			queryManager.setSql(query);

			// the id
			queryManager.getStmt().setString(1,id);

			// execute the query
			int res = queryManager.update();

			// close
			queryManager.close();
			
			// return the result
			return res;	
		}
		catch(SQLException e) {
			log.error("delStorageUsersPreferences :: "+ e);
			throw new DataBaseException();
		}
	}
	
	
	
	
	
	
	
	
	
	
	

	/**
	 * Get the id of shared spaces from url and path
	 * @param url the url of the space
	 * @param path the path of the space
	 * @return the list of ids
	 * @throws DataBaseException
	 */
	public Vector getIdOfSpacesWithPath(String url, String path) throws DataBaseException {

		try {

			// the query manager
			Query queryManager = new Query(dataBaseAccess);
			
			// the SQL query
			String query = QueriesManagement.getQuery(QueriesManagement.GET_ID_OF_SPACES_WITH_PATH);		
			
			// prepare the SQL query	    	   		    	    	
			queryManager.setSql(query);

			// the url
			queryManager.getStmt().setString(1,url);

			// the path
			queryManager.getStmt().setString(2,path);
			
			// execute the query
			queryManager.select();
			ResultSet rs = queryManager.getRs();
    	
			// the ids
			Vector ids = new Vector();
			while (rs.next()) {
				ids.add(rs.getString(1));
			}

			// close
			queryManager.close();
			
			// return the result
			return ids;	
		}
		catch(SQLException e) {
			log.error("getIdOfSpacesWithPath :: "+ e);
			throw new DataBaseException();
		}
	}

	
	
	/**
	 * Update the path of shared spaces
	 * @param url the url of the space
	 * @param oldPath the old path of the space
	 * @param newPath the new path of the space
	 * @return the result of the query
	 * @throws DataBaseException
	 */
	public int updatePathOfSharing(String url, String oldPath, String newPath) throws DataBaseException {

		try {

			// the query manager
			Query queryManager = new Query(dataBaseAccess);
			
			// the SQL query
			String query = QueriesManagement.getQuery(QueriesManagement.UPDATE_PATH_OF_SHARING);		
			
			// prepare the SQL query	    	   		    	    	
			queryManager.setSql(query);

			// the new path
			queryManager.getStmt().setString(1,newPath);
			
			// the url
			queryManager.getStmt().setString(2,url);

			// the old path
			queryManager.getStmt().setString(3,oldPath);

			// execute the query
			int res = queryManager.update();
			
			// close
			queryManager.close();
			
			// return the result
			return res;	
		}
		catch(SQLException e) {
			log.error("updatePathOfSharing :: "+ e);
			throw new DataBaseException();
		}
	}
}
