/*
ESUP-portail is a french academic project developed under the GPL (General Public License) augmented according to the following :
A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.
The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .
A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .
The different kinds of licenses governing the products developed by the Apache foundation can be found here : http://www.apache.org/licenses .
It follows that you can as well as use download contents as well modify and redistribute them provided you respect the GPL terms.
Downloading and using such contents do not provide any guaranty.
Be sure that you have well understood the terms of the license before using the contents it covers.
The ESUP-portail distribution includes the following distributions :
    * UPortal :
      software developed by JA-SIG (Java Architecture - Special Interest Group)
      You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html
    * CAS :
      SSO solution developed by Yale University
      You can find the project page here : http://www.yale.edu/tp/auth
    * Cocoon :
      XML framework distributed by the Apache foundation under Apache license;
      Please find the full text here : http://cocoon.apache.org/2.1/license.html
    * Mod_dav:
      A DAV module for Apache web server
      You can find the project page here : http://www.webdav.org/mod_dav
    * IMP :
      webmail from Horde application framework
      You can find the project page here : http://www.horde.org
    * . To be completed
*/
package org.esupportail.portal.channels.CStockage.channelAction.classic.sharing;


import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CStockage.exception.ServerException;
import org.esupportail.portal.channels.CStockage.userManagement.Group;
import org.jasig.portal.groups.EntityGroupImpl;

/**
 * Id: Group.java,v 1.0 7 oct. 2004
 * Copyright (c) 2004 Esup Portail (www.esup-portail.org)
 * Classes: Group
 * Original Author: Yohan Colmant
 * Represents a group for the management
 */
public class GroupForSharing extends Group {


	/**
	 * Logger object
	 */
	protected static final Log log = LogFactory.getLog(GroupForSharing.class);
	
	
	
	

	/**
	 * When used for acl management, to know if this user has reading rights
	 */
	private boolean reading = false;
	
	/**
	 * When used for acl management, to know if this user has writing rights
	 */
	private boolean writing = false;
	
	/**
	 * If the group can manage the rights
	 */
	private boolean manage = false;
	
	
	
	/**
	 * The ID of this sharing in the database
	 */
	private String idOfSharing;
	
	
	
	
	
	
	/**
	 * Default constructor
	 */
	public GroupForSharing() {
		
	}
	
	
	
	/**
	 * Constructor
	 * @param key the group key
	 * @param displayName The displayed group name
	 * @throws ServerException
	 */
	public GroupForSharing(String key, String displayName) throws ServerException {
		super(key, displayName);
	}
	
	/**
	 * Constructor
	 * @param group this portal group value
	 * @throws ServerException
	 */
	public GroupForSharing(EntityGroupImpl group) throws ServerException {
		super(group);	
	}
	
	/**
	 * Constructor
	 * @param hierarchy this portal group hierarchy in this form: G1/G2/G3 where G1 is the root
	 * @throws ServerException
	 */
	public GroupForSharing(String hierarchy) throws ServerException {
		super(hierarchy);		
	}

	
	
	
	
	


	

	/**
	 * @return Returns the reading.
	 */
	public boolean isReading() {
		return reading;
	}
	/**
	 * @param reading The reading to set.
	 */
	public void setReading(boolean reading) {
		this.reading = reading;
	}
	/**
	 * @return Returns the writing.
	 */
	public boolean isWriting() {
		return writing;
	}
	/**
	 * @param writing The writing to set.
	 */
	public void setWriting(boolean writing) {
		this.writing = writing;
	}
	
	
	
	
	

	/**
	 * @return Returns the manage.
	 */
	public boolean isManage() {
		return manage;
	}
	/**
	 * @param manage The manage to set.
	 */
	public void setManage(boolean manage) {
		this.manage = manage;
	}
	
	
	
	/**
	 * @return Returns the idOfSharing.
	 */
	public String getIdOfSharing() {
		return idOfSharing;
	}
	/**
	 * @param idOfSharing The idOfSharing to set.
	 */
	public void setIdOfSharing(String idOfSharing) {
		this.idOfSharing = idOfSharing;
	}
	
	
	
	
	

	/**
	 * Clone this object to another similary one
	 * @return this cloned object
	 */
	public Object clone() {
		GroupForSharing clone = new GroupForSharing();
		clone.setKey(this.getKey());
		clone.setDisplayName(this.getDisplayName());
		clone.setReading(this.isReading());
		clone.setWriting(this.isWriting());
		clone.setManage(this.isManage());
		clone.setIdOfSharing(this.getIdOfSharing());
		return clone;
	}
	
	
}
