/*
ESUP-portail is a french academic project developed under the GPL (General Public License) augmented according to the following :
A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.
The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .
A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .
The different kinds of licenses governing the products developed by the Apache foundation can be found here : http://www.apache.org/licenses .
It follows that you can as well as use download contents as well modify and redistribute them provided you respect the GPL terms.
Downloading and using such contents do not provide any guaranty.
Be sure that you have well understood the terms of the license before using the contents it covers.
The ESUP-portail distribution includes the following distributions :
    * UPortal : 
      software developed by JA-SIG (Java Architecture - Special Interest Group)
      You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html
    * CAS :
      SSO solution developed by Yale University
      You can find the project page here : http://www.yale.edu/tp/auth
    * Cocoon :
      XML framework distributed by the Apache foundation under Apache license;
      Please find the full text here : http://cocoon.apache.org/2.1/license.html
    * Mod_dav:
      A DAV module for Apache web server
      You can find the project page here : http://www.webdav.org/mod_dav
    * IMP :
      webmail from Horde application framework
      You can find the project page here : http://www.horde.org
    * . To be completed
*/
package org.esupportail.portal.channels.CStockage.channelAction.classic.sharing;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CStockage.exception.DataBaseException;


/**
 * Id: QueriesManagement.java,v 1.0 8 mars 2005
 * Copyright (c) 2005 Esup Portail (www.esup-portail.org)
 * Classes: QueriesManagement
 * Original Author: Yohan Colmant
 * This class manage the access to the queries from the configuration file
 */
public class QueriesManagement {

	/**
	 * Logger object
	 */
	protected static final Log log = LogFactory.getLog(QueriesManagement.class);
	
	
	
	
	/**
	 * The mysql driver
	 */
	private static String MYSQL_DRIVER = "com.mysql.jdbc.Driver";
	
	/**
	 * The oracle driver
	 */
	private static String ORACLE_DRIVER = "oracle.jdbc.driver.OracleDriver";
	
	/**
	 * The postgres driver
	 */
	private static String POSTGRES_DRIVER = "org.postgresql.Driver";
	
	
	
	

	/**
	 * The sql queries file
	 */
	private static String SQL_QUERIES_FILE_NAME = "sql_queries.properties";
	
	
	
	/**
	 * The path of the properties directory
	 */
	private static String propertiesPath = "/properties/channels/org_esup/CStockage/database/";
	
	
	
	
	
	
	
	/**
	 * The "add.storage_available_space" property value
	 */
	public static String ADD_STORAGE_AVAILABLE_SPACE = "add.storage_available_space";

	/**
	 * The "del.storage_available_space" property value
	 */
	public static String DEL_STORAGE_AVAILABLE_SPACE = "del.storage_available_space";
	
	/**
	 * The "get.targets_of_available_space" property value
	 */
	public static String GET_TARGET_OF_AVAILABLE_SPACE = "get.targets_of_available_space";
		
	/**
	 * The "is.already_available_for_target" property value
	 */
	public static String IS_ALREADY_AVAILABLE_FOR_TARGET = "is.already_available_for_target";
	
	/**
	 * The "update.label_available_space" property value
	 */
	public static String UPDATE_LABEL_AVAILABLE_SPACE = "update.label_available_space";
	
	/**
	 * The "update.read_and_write_and_manage_space" property value
	 */
	public static String UPDATE_READ_AND_WRITE_AND_MANAGE_SPACE = "update.read_and_write_and_manage_space";

	/**
	 * The "get.available_spaces_for_target" property value
	 */
	public static String GET_AVAILABLE_SPACES_FOR_TARGET = "get.available_spaces_for_target";
	
	
	
	
	
	
	
	
	
	
	
	
	
	/**
	 * The "add.storage_users_preferences" property value
	 */
	public static String ADD_STORAGE_USERS_PREFERENCES = "add.storage_users_preferences";

	/**
	 * The "is.already_in_preferences_for_a_user" property value
	 */
	public static String IS_ALREADY_IN_PREFERENCES_FOR_A_USER = "is.already_in_preferences_for_a_user";

	/**
	 * The "get.id_of_space_from_preferences" property value
	 */
	public static String GET_ID_OF_SPACE_FROM_PREFERENCES = "get.id_of_space_from_preferences";

	/**
	 * The "del.storage_users_preferences_for_user" property value
	 */
	public static String DEL_STORAGE_USERS_PREFERENCES_FOR_USER = "del.storage_users_preferences_for_user";

	/**
	 * The "del.storage_users_preferences" property value
	 */
	public static String DEL_STORAGE_USERS_PREFERENCES = "del.storage_users_preferences";

	
	
	
	

	/**
	 * The "get.id_of_spaces_with_path" property value
	 */
	public static String GET_ID_OF_SPACES_WITH_PATH = "get.id_of_spaces_with_path";

	/**
	 * The "update.path_of_sharing" property value
	 */
	public static String UPDATE_PATH_OF_SHARING = "update.path_of_sharing";
	
	
	
	
	
	
	/**
	 * The properties object
	 */
	private static Properties properties;
	
	
	
	
	/**
	 * Get a query from the properties file
	 * @param queryName the name of the query we want to get
	 * @return the SQL query
	 * @throws DataBaseException
	 */
	public static String getQuery(String queryName) throws DataBaseException {
		if (properties==null) {
			QueriesManagement qm = new QueriesManagement();
			properties = qm.getProperties();
		}		
		
		return properties.getProperty(queryName);
	}
	
	
	
	
	
	/**
	 * Constructor
	 */
	public QueriesManagement() {
	}
	
	
	
	/**
	 * Constructor
	 * Initialize the parameters for a connexion to the database
	 * @throws DataBaseException
	 */
	public Properties getProperties() throws DataBaseException {
		String fileName = SQL_QUERIES_FILE_NAME;
		
		// initialize the properties object
		String filePath = propertiesPath + fileName;
		URL url = QueriesManagement.class.getResource(filePath);
		
		try {
			FileInputStream fis = new FileInputStream(url.getFile());
			Properties props = new Properties();
			props.load(fis);			
			fis.close();
			return props;
		}
		catch(IOException e) {
			log.error("getProperties"+" :: unable to open the database properties file");
			throw new DataBaseException();
		}
	}
	
	
	
	
	
	
	
	
}
